/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import org.eclipse.jdt.annotation.Nullable;

public enum ContentStatus {
    OK(200),
    CREATED(201),
    ACCEPTED(202),
    NON_AUTHORITATIVE_INFORMATION(203),
    NO_CONTENT(204),
    RESET_CONTENT(205),
    MULTIPLE_CHOICE(300),
    MOVED_PERMANENTLY(301),
    FOUND(302),
    SEE_OTHER(303),
    TEMPORARY_REDIRECT(307),
    BAD_REQUEST(400),
    FORBIDDEN(403),
    NOT_FOUND(404),
    NOT_ACCEPTABLE(406),
    REQUEST_TIMEOUT(408),
    CONFLICT(409),
    GONE(410),
    LENGTH_REQUIRED(411),
    PAYLOAD_TOO_LARGE(413),
    URI_TOO_LONG(414),
    UNSUPPORTED_MEDIA_TYPE(415),
    UNPROCESSABLE_ENTITY(422),
    LOCKED(423),
    FAILED_DEPENDENCY(424),
    PRECONDITION_REQUIRED(428),
    TOO_MANY_REQUESTS(429),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431),
    UNAVAILABLE_FOR_LEGAL_REASONS(451),
    INTERNAL_SERVER_ERROR(500),
    NOT_IMPLEMENTED(501),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504),
    INSUFFICIENT_STORAGE(507);

    private final int _code;
    private final String _string;

    private ContentStatus(int code) {
        this._code = code;
        this._string = this.name().toLowerCase().replace('_', '-');
    }

    public int code() {
        return this._code;
    }

    public static @Nullable ContentStatus forCode(int code) {
        for (ContentStatus status : ContentStatus.values()) {
            if (status.code() != code) continue;
            return status;
        }
        return null;
    }

    public static boolean isRedirect(ContentStatus status) {
        return status._code >= 300 && status._code < 400;
    }

    public String toString() {
        return this._string;
    }
}

