/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.pageseeder.berlioz.config.ConfigException;
import org.pageseeder.berlioz.xml.BerliozErrorHandler;
import org.pageseeder.berlioz.xml.Xml;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class ConfigLoader<T>
extends DefaultHandler {
    protected T config;

    ConfigLoader(T config) {
        this.config = Objects.requireNonNull(config, "Config items must be specified");
    }

    T getConfig() {
        return this.config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <X> X parse(ConfigHandler<X> handler, File file) throws ConfigException {
        if (file.length() > 1000000L) {
            throw new ConfigException("Configuration files must should not exceed 1MB", new IllegalArgumentException());
        }
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            X x = ConfigLoader.parse(handler, in);
            return x;
        }
        catch (IOException ex) {
            throw new ConfigException("Unable to open config file", ex);
        }
    }

    public static <X> X parse(ConfigHandler<X> handler, InputStream in) throws ConfigException {
        byte[] bytes = ConfigLoader.toByteArray(in);
        try {
            int end;
            SAXParser parser = Xml.newSafeParser(false);
            int start = ConfigLoader.find(bytes, "<!DOCTYPE ".getBytes());
            if (start != -1 && (end = ConfigLoader.find(bytes, ">".getBytes()[0], start + 10) + 1) != -1) {
                LoggerFactory.getLogger(ConfigLoader.class).warn("Doctype declaration found in config file");
                String doctype = new String(Arrays.copyOfRange(bytes, start, end));
                if (doctype.contains("-//Berlioz") || doctype.contains("//Weborganic")) {
                    byte[] clean = new byte[bytes.length - (end + start)];
                    System.arraycopy(bytes, 0, clean, 0, start);
                    System.arraycopy(bytes, end, clean, end - (end + start), bytes.length - end);
                    bytes = clean;
                }
            }
            if (handler.getSchema() != null) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    InputStream inputStream = ConfigLoader.class.getResourceAsStream("/schema/" + handler.getSchema() + ".xsd");
                    StreamSource schemaFile = new StreamSource(inputStream);
                    Schema schema = factory.newSchema(schemaFile);
                    Validator validator = schema.newValidator();
                    validator.validate(new StreamSource(is));
                }
                catch (SAXException ex) {
                    throw new ConfigException("Error during validation", ex);
                }
            }
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setContentHandler(handler);
            reader.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            reader.setErrorHandler(BerliozErrorHandler.getInstance());
            reader.parse(new InputSource(new ByteArrayInputStream(bytes)));
            return handler.getConfig();
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigException("Could not configure SAX parser.", ex);
        }
        catch (IOException | SAXException ex) {
            throw new ConfigException("Error while parsing: " + ex.getMessage(), ex);
        }
    }

    private static byte[] toByteArray(InputStream in) throws ConfigException {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException ex) {
            throw new ConfigException(ex.getMessage(), ex);
        }
    }

    private static int find(byte[] source, byte[] pattern) {
        for (int i = 0; i < source.length; ++i) {
            if (!ConfigLoader.match(source, pattern, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean match(byte[] source, byte[] pattern, int at) {
        if (source[at] == pattern[0] && at < source.length - pattern.length) {
            for (int i = 1; i < pattern.length; ++i) {
                if (source[at + i] == pattern[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int find(byte[] source, byte b, int from) {
        for (int i = from; i < source.length; ++i) {
            if (source[i] != b) continue;
            return i;
        }
        return -1;
    }

    static abstract class ConfigHandler<T>
    extends DefaultHandler {
        ConfigHandler() {
        }

        abstract String getSchema();

        abstract T getConfig();
    }
}

