/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.bundler;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.bundler.BundleConfig;
import org.pageseeder.berlioz.bundler.BundleType;
import org.pageseeder.berlioz.content.Cacheable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.Environment;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.servlet.HttpContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GetWebBundles
implements ContentGenerator,
Cacheable {
    private static final Map<String, BundleConfig> CSS_CONFIGS = new HashMap<String, BundleConfig>();
    private static final Map<String, BundleConfig> JS_CONFIGS = new HashMap<String, BundleConfig>();
    private static volatile @Nullable Boolean isWritable = null;

    @Override
    public @Nullable String getETag(ContentRequest req) {
        boolean doBundle;
        HttpContentRequest hreq = (HttpContentRequest)req;
        Service service = hreq.getService();
        Environment env = req.getEnvironment();
        String config = GetWebBundles.getConfig(req);
        BundleConfig js = this.getConfig(config, BundleType.JS, env.getPublicFolder());
        BundleConfig css = this.getConfig(config, BundleType.CSS, env.getPublicFolder());
        if (isWritable == null) {
            isWritable = js.store().exists() && js.store().canWrite();
        }
        if (doBundle = GetWebBundles.canBundle(req)) {
            long etagJS = js.getLastModifiedBundle(service);
            long etagCSS = css.getLastModifiedBundle(service);
            return Long.toString(Math.max(etagJS, etagCSS));
        }
        return null;
    }

    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        HttpContentRequest hreq = (HttpContentRequest)req;
        Service service = hreq.getService();
        Environment env = req.getEnvironment();
        boolean doBundle = GetWebBundles.canBundle(req);
        String config = GetWebBundles.getConfig(req);
        BundleConfig js = this.getConfig(config, BundleType.JS, env.getPublicFolder());
        if (doBundle) {
            List<File> bundles = js.getBundles(service);
            String location = js.location();
            for (File file : bundles) {
                xml.openElement("script", false);
                xml.attribute("src", (String)location + file.getName());
                xml.attribute("bundled", "true");
                xml.attribute("minimized", Boolean.toString(js.minimize()));
                xml.closeElement();
            }
        } else {
            List<String> paths = js.getPaths(service);
            for (String path : paths) {
                xml.openElement("script", false);
                xml.attribute("src", path);
                xml.attribute("bundled", "false");
                xml.attribute("minimized", "false");
                xml.closeElement();
            }
        }
        BundleConfig css = this.getConfig(config, BundleType.CSS, env.getPublicFolder());
        if (doBundle) {
            List<File> bundles = css.getBundles(service);
            String location = css.location();
            for (File bundle : bundles) {
                xml.openElement("style", false);
                xml.attribute("src", location + bundle.getName());
                xml.attribute("bundled", "true");
                xml.attribute("minimized", Boolean.toString(css.minimize()));
                xml.closeElement();
            }
        } else {
            List<String> paths = css.getPaths(service);
            for (String string : paths) {
                xml.openElement("style", false);
                xml.attribute("src", string);
                xml.attribute("bundled", "false");
                xml.attribute("minimized", "false");
                xml.closeElement();
            }
        }
    }

    private static String getConfig(ContentRequest req) {
        return Objects.requireNonNull(req.getParameter("config", "default"));
    }

    private static boolean canBundle(ContentRequest req) {
        return isWritable == Boolean.TRUE && !"false".equals(req.getParameter("berlioz-bundle", "true"));
    }

    private BundleConfig getConfig(String name, BundleType type, File root) {
        Map<String, BundleConfig> configs = type == BundleType.JS ? JS_CONFIGS : CSS_CONFIGS;
        BundleConfig config = configs.get(name);
        if (config == null) {
            config = BundleConfig.newInstance(name, type, root);
            configs.put(name, config);
        }
        return config;
    }
}

