/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.Attributes;

final class JSONState {
    private final Deque<JSONContext> context = new ArrayDeque<JSONContext>();
    private final Deque<JSONTypeMap> types = new ArrayDeque<JSONTypeMap>();
    private final Deque<String> names = new ArrayDeque<String>();

    JSONState() {
    }

    public void pushState() {
        this.context.push(JSONContext.ROOT);
        this.types.push(JSONTypeMap.EMPTY);
        this.names.push("");
    }

    public void pushState(JSONContext context, Attributes atts, @Nullable String name) {
        this.context.push(context);
        JSONTypeMap map = JSONTypeMap.make(this.currentTypeMap(), atts);
        this.types.push(map);
        this.names.push(name != null ? name : "");
    }

    public void popState() {
        this.context.pop();
        this.types.pop();
        this.names.pop();
    }

    public JSONContext currentContext() {
        JSONContext c = this.context.peek();
        if (c == null) {
            throw new IllegalStateException("No JSON context!");
        }
        return c;
    }

    public boolean isContext(JSONContext context) {
        return this.currentContext() == context;
    }

    public String currentName() {
        String name = this.names.peek();
        if (name == null) {
            throw new IllegalStateException("No JSON name");
        }
        return name;
    }

    private JSONTypeMap currentTypeMap() {
        JSONTypeMap type = this.types.peek();
        if (type == null) {
            throw new IllegalStateException("No JSON type map");
        }
        return type;
    }

    public JSONType getType(String name) {
        return this.currentTypeMap().getType(name);
    }

    public String toString() {
        return (Object)((Object)this.currentContext()) + "|" + this.currentTypeMap() + '|' + this.currentName();
    }

    private static final class JSONTypeMap {
        public static final JSONTypeMap EMPTY = new JSONTypeMap();
        private final Map<String, JSONType> map;

        private JSONTypeMap() {
            this.map = Collections.emptyMap();
        }

        private JSONTypeMap(Map<String, JSONType> map) {
            this.map = map;
        }

        public JSONType getType(String name) {
            JSONType type = this.map.get(name);
            return type != null ? type : JSONType.DEFAULT;
        }

        public static JSONTypeMap make(JSONTypeMap inherited, Attributes atts) {
            JSONTypeMap current = inherited;
            String toBoolean = atts.getValue("http://pageseeder.org/JSON", "boolean");
            String toNumber = atts.getValue("http://pageseeder.org/JSON", "number");
            String toString = atts.getValue("http://pageseeder.org/JSON", "string");
            String toNull = atts.getValue("http://pageseeder.org/JSON", "null");
            if (toBoolean == null && toNumber == null && toString == null && toNull == null) {
                return current;
            }
            HashMap<String, JSONType> updated = new HashMap<String, JSONType>(current.map);
            if (toBoolean != null) {
                for (String name : toBoolean.split(" ")) {
                    updated.put(name, JSONType.BOOLEAN);
                }
            }
            if (toNumber != null) {
                for (String name : toNumber.split(" ")) {
                    updated.put(name, JSONType.NUMBER);
                }
            }
            if (toString != null) {
                for (String name : toString.split(" ")) {
                    updated.put(name, JSONType.STRING);
                }
            }
            if (toNull != null) {
                for (String name : toNull.split(" ")) {
                    updated.put(name, JSONType.NULL);
                }
            }
            return new JSONTypeMap(updated);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static enum JSONContext {
        ROOT,
        OBJECT,
        ARRAY,
        NULL,
        VALUE;

    }

    public static enum JSONType {
        STRING,
        NUMBER,
        BOOLEAN,
        NULL,
        DEFAULT;

    }
}

