/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.xref;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.publication.ContentAdjustor;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.url.URLCreator;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.xref.XRefType;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;

public class XRef {
    private static final String IMAGE = "image";
    private static final String LINK = "link";
    private static final Pattern FRAGMENT_DOCUMENT_FILENAME_DOCID = Pattern.compile(".{0,500}?\\{(fragment|document|filename|docid)}.{0,500}");
    private static final Pattern LEVEL_MATCHER = Pattern.compile("(?<=(^|\\|))level=(.*?)\\|");
    private static final Pattern CONFIG_MATCHER = Pattern.compile("(?<=(^|\\|))config=(.*?)\\|");
    private static final Pattern URL_FRAGMENT = Pattern.compile("^(?:[a-zA-Z0-9-._~!$&'()*+,;=:/?@]|%[0-9A-Fa-f]{2})*$");
    private @Nullable String id;
    private final URI sourceURI;
    private final @Nullable String sourceFragment;
    private final @Nullable String sourceUriTitle;
    private final XRefType xrefType;
    private @Nullable String targetTitle;
    private @Nullable URI targetUri;
    private @Nullable String targetUriid;
    private @Nullable String targetDocid;
    private @Nullable String targetHref;
    private @Nullable String targetFragment;
    private boolean targetFragmentMissing = false;
    private final boolean reverseLink;
    private final @Nullable String reverseTitle;
    private final @Nullable String config;
    private final @Nullable String level;
    private final @Nullable String display;
    private final String type;
    private final String reverseType;
    private final String[] labels;
    private @Nullable String content;
    private boolean isNew;
    private boolean isOld;
    private @Nullable XLink xlink;
    private boolean wasModified = false;
    private @Nullable String warning = null;
    private @Nullable List<String> imageOrLinkAttributes = null;

    public XRef(URI source, String fragment, Attributes atts, String type, boolean readId, boolean ignoreURIID) {
        this.sourceURI = source;
        this.id = readId ? XRef.getAttributeValue("id", atts) : null;
        this.sourceFragment = fragment;
        this.sourceUriTitle = null;
        this.xrefType = XRefType.fromString(type);
        this.targetDocid = XRef.getAttributeValue("docid", atts);
        this.targetUriid = ignoreURIID ? null : XRef.getAttributeValue("uriid", atts);
        this.isNew = true;
        this.isOld = false;
        String[] stringArray = this.labels = atts.getValue("labels") == null ? new String[]{} : Strings.split((String)atts.getValue("labels"), (char)',');
        if (this.xrefType == XRefType.IMAGE) {
            this.targetHref = XRef.getAttributeValue("src", atts);
            if (this.targetHref != null) {
                this.targetHref = this.targetHref.replaceAll("(^\\./)", "");
            }
            if (ignoreURIID && this.targetHref != null && this.targetHref.startsWith(GlobalSettings.getSitePrefix() + "/uri/")) {
                this.targetHref = null;
            }
            this.type = IMAGE;
            this.reverseLink = true;
            this.reverseTitle = null;
            this.reverseType = "none";
            this.targetFragment = "default";
            this.imageOrLinkAttributes = new ArrayList<String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getLocalName(i);
                if (!"width".equals(name) && !"height".equals(name) && !"alt".equals(name)) continue;
                this.imageOrLinkAttributes.add(name + "=" + atts.getValue(i));
            }
            this.targetTitle = null;
            this.display = null;
            this.level = null;
            this.config = null;
        } else if (this.xrefType == XRefType.LINK) {
            this.targetHref = XRef.getAttributeValue("href", atts, "");
            String hash = null;
            this.targetHref = this.targetHref.replaceAll("(^\\./)", "");
            int hashIndex = this.targetHref.indexOf(35);
            if (hashIndex != -1) {
                hash = this.targetHref.substring(hashIndex + 1);
                this.targetHref = this.targetHref.substring(0, hashIndex);
            }
            this.type = LINK;
            this.reverseLink = true;
            this.reverseTitle = null;
            this.reverseType = "none";
            String targetFrag = XRef.getAttributeValue("frag", atts);
            this.targetFragment = "default".equalsIgnoreCase(targetFrag) ? "default" : (targetFrag != null && !targetFrag.isEmpty() ? targetFrag : (hash == null || hash.isEmpty() ? "default" : hash));
            this.imageOrLinkAttributes = new ArrayList<String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getLocalName(i);
                if (!"role".equals(name)) continue;
                this.imageOrLinkAttributes.add(name + "=" + atts.getValue(i));
            }
            this.targetTitle = null;
            this.display = null;
            this.level = null;
            this.config = null;
        } else {
            String targetFragment = XRef.getAttributeValue("frag", atts);
            this.targetFragment = "default".equalsIgnoreCase(targetFragment) ? "default" : targetFragment;
            this.type = XRef.getAttributeValue("type", atts, "none");
            this.reverseLink = !"false".equals(atts.getValue("reverselink"));
            this.reverseTitle = XRef.getAttributeValue("reversetitle", atts);
            this.reverseType = XRef.getAttributeValue("reversetype", atts, "none");
            this.targetTitle = XRef.getAttributeValue("title", atts);
            this.display = XRef.getAttributeValue("display", atts, "document");
            this.level = XRef.getAttributeValue("level", atts);
            this.targetHref = XRef.getAttributeValue("href", atts);
            this.config = XRef.getAttributeValue("config", atts);
            if (this.targetHref != null) {
                this.targetHref = this.targetHref.replaceAll("(^\\./)", "");
            }
        }
    }

    public XRef(URI source, String fragment, Attributes atts) {
        this.sourceURI = source;
        this.id = XRef.getAttributeValue("id", atts);
        this.targetFragment = fragment;
        this.xrefType = XRefType.REVERSEXREF;
        this.sourceFragment = XRef.getAttributeValue("frag", atts);
        this.sourceUriTitle = XRef.getAttributeValue("urititle", atts);
        this.reverseLink = true;
        this.display = XRef.getAttributeValue("forwarddisplay", atts, "document");
        this.reverseType = XRef.getAttributeValue("type", atts, "none");
        this.reverseTitle = XRef.getAttributeValue("title", atts);
        this.type = XRef.getAttributeValue("forwardtype", atts, "none");
        this.targetTitle = XRef.getAttributeValue("forwardtitle", atts);
        this.labels = atts.getValue("labels") == null ? new String[]{} : Strings.split((String)atts.getValue("labels"), (char)',');
        this.level = XRef.getAttributeValue("level", atts);
        this.config = XRef.getAttributeValue("config", atts);
        this.isNew = true;
        this.isOld = false;
    }

    public XRef(XRef xref) {
        this.sourceURI = xref.sourceURI;
        this.sourceFragment = xref.sourceFragment;
        this.sourceUriTitle = xref.sourceUriTitle;
        this.xrefType = xref.xrefType;
        this.targetTitle = xref.targetTitle;
        this.targetFragment = xref.targetFragment;
        this.reverseLink = xref.reverseLink;
        this.display = xref.display;
        this.type = xref.type;
        this.reverseType = xref.reverseType;
        this.reverseTitle = xref.reverseTitle;
        this.labels = xref.labels;
        this.targetDocid = xref.targetDocid;
        this.targetHref = xref.targetHref;
        this.level = xref.level;
        this.targetUriid = xref.targetUriid;
        this.isNew = xref.isNew;
        this.isOld = xref.isOld;
        this.content = xref.content;
        this.targetUri = xref.targetUri;
        this.wasModified = xref.wasModified;
        this.xlink = xref.xlink;
        this.imageOrLinkAttributes = xref.imageOrLinkAttributes;
        this.config = xref.config;
        this.warning = xref.warning;
    }

    public XRef(XLink xl) {
        URI target = null;
        URI source = null;
        String sourceFrag = null;
        String targetFrag = null;
        String thetype = null;
        String title = null;
        String revTitle = null;
        Iterator lfxs = xl.getLocatorsForXLink();
        boolean reverseXRef = false;
        while (lfxs.hasNext()) {
            LocatorForXLink lfx = (LocatorForXLink)lfxs.next();
            String lfxRole = lfx.getRole();
            if (lfxRole == null) continue;
            Locator loc = lfx.getLocator();
            if (lfxRole.startsWith("xref-source")) {
                source = loc.getURI();
                sourceFrag = loc.getFragment();
                thetype = lfx.getLabel();
                revTitle = lfx.getTitle();
                reverseXRef = lfxRole.endsWith("-link");
                continue;
            }
            target = loc.getURI();
            targetFrag = loc.getFragment();
            title = lfx.getTitle();
        }
        String contentRole = xl.getContentRole();
        this.sourceFragment = sourceFrag;
        this.sourceUriTitle = null;
        this.targetUri = target;
        this.targetTitle = "".equals(title) ? null : title;
        this.targetFragment = "".equals(targetFrag) ? null : targetFrag;
        this.reverseLink = reverseXRef;
        this.display = contentRole == null || contentRole.length() <= 5 ? null : contentRole.substring(5);
        this.type = thetype == null ? "none" : thetype;
        this.reverseType = "none";
        this.isNew = false;
        this.isOld = false;
        this.reverseTitle = revTitle;
        this.labels = Labels.getLabels((XLink)xl);
        if (IMAGE.equals(thetype)) {
            this.xrefType = XRefType.IMAGE;
            this.imageOrLinkAttributes = new ArrayList<String>();
        } else if (LINK.equals(thetype)) {
            this.xrefType = XRefType.LINK;
            this.imageOrLinkAttributes = new ArrayList<String>();
        } else {
            this.xrefType = XRefType.UNKNOWN;
        }
        this.content = null;
        this.sourceURI = source;
        this.level = XRef.getLevelFromXlink(xl);
        this.config = XRef.getConfigFromXlink(xl);
        this.xlink = xl;
    }

    private static @Nullable String getAttributeValue(String name, Attributes atts) {
        String v = atts.getValue(name);
        if (v == null || v.isEmpty()) {
            return null;
        }
        return XRef.normalizeWhitespace(v);
    }

    private static String getAttributeValue(String name, Attributes atts, String def) {
        String v = atts.getValue(name);
        if (v == null || v.isEmpty()) {
            return def;
        }
        return XRef.normalizeWhitespace(v);
    }

    private static String normalizeWhitespace(String s) {
        return s.replaceAll("[\t\n\r]", " ");
    }

    public void setContent(String cont) {
        this.content = cont;
    }

    public @Nullable URI getTargetURI() {
        return this.targetFragmentMissing ? null : this.targetUri;
    }

    public @Nullable String getTargetURIId() {
        return this.targetUriid;
    }

    public URI getSourceURI() {
        return this.sourceURI;
    }

    public void retrieveTarget(Database db, String scheme, String host, Integer port, String basePath, URLCreator urlCreator) {
        this.warning = null;
        boolean searched = false;
        String hrefFailed = null;
        String docidFailed = null;
        String uriidFailed = null;
        String fragmentFailed = null;
        boolean hrefSuccess = false;
        boolean docidSuccess = false;
        boolean uriidSuccess = false;
        if (this.targetUri == null) {
            try {
                searched = this.retrieveTargetWithHRef(db, scheme, host, port, basePath, urlCreator);
                hrefSuccess = this.targetUri != null;
            }
            catch (FoundationException ex) {
                hrefFailed = ex.getMessage();
                searched = true;
            }
        }
        if (this.targetUri == null) {
            try {
                searched = this.retrieveTargetWithDocID(db, host) || searched;
                docidSuccess = this.targetUri != null;
            }
            catch (FoundationException ex) {
                docidFailed = ex.getMessage();
                searched = true;
            }
        }
        if (this.targetUri == null) {
            try {
                searched = this.retrieveTargetWithURIID(db) || searched;
                uriidSuccess = this.targetUri != null;
            }
            catch (FoundationException ex) {
                uriidFailed = ex.getMessage();
                searched = true;
            }
        }
        if (this.xrefType == XRefType.LINK && this.targetFragment != null) {
            if (this.targetFragment.length() > 250) {
                fragmentFailed = "URL fragment too long: '#" + this.targetFragment + "'";
                this.targetUri = null;
            } else if (!URL_FRAGMENT.matcher(this.targetFragment).matches()) {
                fragmentFailed = "URL fragment invalid: '#" + this.targetFragment + "'";
                this.targetUri = null;
            }
        } else if (!this.retrieveTargetFragment(db)) {
            fragmentFailed = "Failed to find xref fragment: '" + this.targetFragment + "'";
            this.targetFragmentMissing = true;
        }
        if (!searched) {
            String pathAtt = this.xrefType == XRefType.LINK ? "href" : (this.xrefType == XRefType.IMAGE ? "docid, src" : "docid, href");
            this.warning = "Failed to retrieve document, one of " + pathAtt + " or uriid must be specified";
            if (this.sourceURI != null) {
                this.warning = this.warning + " (URIID " + this.sourceURI.getId() + ")";
            }
        } else if (!(this.xrefType == XRefType.LINK && this.targetHref != null && this.targetHref.startsWith("mailto:") || hrefFailed == null && uriidFailed == null && docidFailed == null)) {
            this.warning = "Failed to retrieve " + (this.xrefType == XRefType.LINK ? "URL" : (this.xrefType == XRefType.IMAGE ? IMAGE : "document")) + " with ";
            boolean comma = false;
            if (hrefFailed != null) {
                this.warning = this.warning + hrefFailed;
                comma = true;
            }
            if (docidFailed != null) {
                if (comma) {
                    this.warning = this.warning + ", ";
                }
                this.warning = this.warning + docidFailed;
                comma = true;
            }
            if (uriidFailed != null) {
                if (comma) {
                    this.warning = this.warning + " and ";
                }
                this.warning = this.warning + uriidFailed;
            }
            if (hrefSuccess) {
                this.warning = this.warning + " but succeeded using path " + this.targetHref;
            }
            if (docidSuccess) {
                this.warning = this.warning + " but succeeded using docid " + this.targetDocid;
            }
            if (uriidSuccess) {
                this.warning = this.warning + " but succeeded using uriid " + this.targetUriid;
            }
            if (this.sourceURI != null) {
                this.warning = this.warning + " (URIID " + this.sourceURI.getId() + ")";
            }
        }
        if (fragmentFailed != null) {
            this.warning = this.warning == null ? "" : this.warning + ", ";
            this.warning = this.warning + fragmentFailed;
        }
    }

    private boolean retrieveTargetWithDocID(Database db, String host) throws FoundationException {
        if (this.targetDocid == null) {
            return false;
        }
        try {
            this.targetUri = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)host, (String)this.targetDocid);
        }
        catch (QueryFailedException ex) {
            throw new FoundationException("ID '" + this.targetDocid + "': " + ex.getMessage(), null);
        }
        if (this.targetUri == null) {
            throw new FoundationException("ID '" + this.targetDocid + "'");
        }
        this.checkForImage("ID '" + this.targetDocid + "'");
        this.wasModified = this.targetUriid == null || !this.targetUriid.equals(String.valueOf(this.targetUri.getId()));
        return true;
    }

    public boolean retrieveTargetWithURIID(Database db) throws FoundationException {
        if (this.targetUriid == null) {
            return false;
        }
        try {
            this.targetUri = DatabaseQuery.getURIById((Database)db, (Long)Long.parseLong(this.targetUriid));
        }
        catch (QueryFailedException ex) {
            throw new FoundationException("URIID '" + this.targetUriid + "': " + ex.getMessage());
        }
        if (this.targetUri == null) {
            throw new FoundationException("URIID '" + this.targetUriid + "'");
        }
        this.checkForImage("URIID '" + this.targetUriid + "'");
        this.checkForURL("URIID '" + this.targetUriid + "'");
        return true;
    }

    private boolean retrieveTargetWithHRef(Database db, String scheme, String host, Integer port, String basePath, URLCreator urlCreator) throws FoundationException {
        if (this.targetHref == null) {
            return false;
        }
        String siteprefix = GlobalSettings.getSitePrefix();
        if ("#".equals(this.targetHref)) {
            this.targetUri = this.sourceURI;
        } else {
            if (this.targetHref.startsWith("#")) {
                throw new FoundationException("relative path '" + this.targetHref + "'");
            }
            if (this.xrefType == XRefType.IMAGE && this.targetHref.startsWith(siteprefix + "/uri/")) {
                String uriid = this.targetHref.substring(siteprefix.length() + 5);
                if (uriid.indexOf(46) > 0) {
                    uriid = uriid.substring(0, uriid.indexOf(46));
                }
                try {
                    this.targetUri = DatabaseQuery.getURIById((Database)db, (Long)Long.parseLong(uriid));
                }
                catch (NumberFormatException ex) {
                    throw new FoundationException("image path '" + this.targetHref + "': is not supported");
                }
                catch (QueryFailedException ex) {
                    throw new FoundationException("image path '" + this.targetHref + "': " + ex.getMessage());
                }
                if (this.targetUri == null) {
                    throw new FoundationException("image path '" + this.targetHref + "'", null);
                }
                this.checkForImage("full path '" + this.targetHref + "'");
            } else if (this.xrefType == XRefType.LINK) {
                URL url;
                try {
                    url = RuleUtils.urlEncodeNormalize(this.targetHref);
                    this.targetUri = URIRule.getURIByURL(db, url);
                }
                catch (DatabaseException | MalformedURLException e) {
                    throw new FoundationException("URL '" + this.targetHref + "': " + e.getMessage());
                }
                if (this.targetUri == null) {
                    if (urlCreator == null) {
                        throw new FoundationException("URL '" + this.targetHref + "'");
                    }
                    if (!URIRule.isExternal(url, db)) {
                        throw new FoundationException("URL '" + this.targetHref + "': the target is not an external URL");
                    }
                    if (url.getPath().length() > 500) {
                        throw new FoundationException("URL path too long '" + this.targetHref + "'");
                    }
                    this.targetUri = urlCreator.create(this.targetHref, db, true);
                } else if (!URIs.isExternal((URI)this.targetUri)) {
                    throw new FoundationException("URL '" + this.targetHref + "': the target is not an external URL");
                }
            } else if (this.targetHref.startsWith("http://") || this.targetHref.startsWith("https://")) {
                try {
                    this.targetUri = URIRule.getURIByURL(db, RuleUtils.urlEncodeNormalize(this.targetHref));
                }
                catch (DatabaseException | MalformedURLException e) {
                    throw new FoundationException("URL '" + this.targetHref + "': " + e.getMessage());
                }
                if (this.targetUri == null) {
                    throw new FoundationException("URL '" + this.targetHref + "'");
                }
                this.checkForImage("URL '" + this.targetHref + "'");
            } else {
                if (RuleUtils.containsInvalidURLChars(this.targetHref)) {
                    throw new FoundationException("path '" + this.targetHref + "': path must be URL encoded");
                }
                if (this.targetHref.startsWith("/")) {
                    try {
                        this.targetUri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)this.targetHref);
                    }
                    catch (QueryFailedException ex) {
                        throw new FoundationException("full path '" + this.targetHref + "': " + ex.getMessage());
                    }
                    if (this.targetUri == null) {
                        throw new FoundationException("full path '" + this.targetHref + "'", null);
                    }
                    this.checkForImage("full path '" + this.targetHref + "'");
                } else {
                    try {
                        this.targetUri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)XRef.computeURIFullPath(basePath, this.targetHref));
                    }
                    catch (DatabaseException ex) {
                        throw new FoundationException("relative path '" + this.targetHref + "': " + ex.getMessage());
                    }
                    if (this.targetUri == null) {
                        throw new FoundationException("relative path '" + this.targetHref + "'");
                    }
                    this.checkForImage("relative path '" + this.targetHref + "'");
                }
            }
        }
        this.wasModified = this.targetUriid == null || !this.targetUriid.equals(String.valueOf(this.targetUri.getId()));
        return true;
    }

    private boolean retrieveTargetFragment(Database db) {
        if (this.targetUri == null || "default".equals(this.targetFragment)) {
            return true;
        }
        Group group = URIRule.getDefaultGroupForURI(this.targetUri);
        if (group == null) {
            return true;
        }
        List<String> frags = URIRule.loadFragments(this.targetUri, group, true, db);
        if (frags == null) {
            return true;
        }
        boolean found = false;
        if (frags != null) {
            for (String frag : frags) {
                if (!frag.equalsIgnoreCase(this.targetFragment)) continue;
                this.targetFragment = frag;
                found = true;
                break;
            }
        }
        return found;
    }

    private void checkForImage(String prefix) throws FoundationException {
        if (this.targetUri == null || this.xrefType != XRefType.IMAGE) {
            return;
        }
        if (this.targetUri.getType() == null || !this.targetUri.getType().startsWith("image/")) {
            this.targetUri = null;
            throw new FoundationException(prefix + ": the target is not an image");
        }
    }

    private void checkForURL(String prefix) throws FoundationException {
        if (this.targetUri == null || this.xrefType != XRefType.LINK) {
            return;
        }
        if (!URIs.isExternal((URI)this.targetUri)) {
            this.targetUri = null;
            throw new FoundationException(prefix + ": the target is not an external URL");
        }
    }

    public @Nullable String getWarning() {
        return this.warning;
    }

    public @Nullable String getSourceFragment() {
        return this.sourceFragment;
    }

    public boolean wasModified() {
        return this.wasModified;
    }

    public void setAdd(boolean add) {
        this.isNew = add;
    }

    public boolean getAdd() {
        return this.isNew;
    }

    public void setDel(boolean del) {
        this.isOld = del;
    }

    public boolean getDel() {
        return this.isOld;
    }

    public void setXLink(XLink xl) {
        this.xlink = xl;
    }

    public void setTargetUri(@Nullable URI turi) {
        this.targetUri = turi;
    }

    public @Nullable XLink getXLink() {
        return this.xlink;
    }

    public String getType() {
        return this.type;
    }

    public boolean isImage() {
        return this.xrefType == XRefType.IMAGE;
    }

    public boolean isLink() {
        return this.xrefType == XRefType.LINK;
    }

    public boolean isAlternate() {
        return "alternate".equals(this.type);
    }

    public String getReverseType() {
        return this.reverseType;
    }

    public @Nullable String getDisplay() {
        return this.display;
    }

    public boolean getReverseLink() {
        return this.reverseLink;
    }

    public @Nullable String getReverseTitle() {
        return this.reverseTitle;
    }

    public @Nullable String getLevel() {
        return this.level;
    }

    public @Nullable String getConfig() {
        return this.config;
    }

    public @Nullable String getTargetFragment() {
        return this.targetFragment;
    }

    public @Nullable String getTargetHref() {
        return this.targetHref;
    }

    public @Nullable String getTitle() {
        return this.targetTitle;
    }

    public void setTitle(String title) {
        this.targetTitle = title.isEmpty() ? null : title;
    }

    public @Nullable Long getUriid() {
        return this.targetUri == null || this.targetFragmentMissing ? null : this.targetUri.getId();
    }

    public String[] getLabels() {
        return this.labels;
    }

    public boolean equals(Object x) {
        if (!(x instanceof XRef)) {
            return false;
        }
        XRef xr = (XRef)x;
        if (xr.getTargetFragment() == null || this.targetFragment == null ? xr.getTargetFragment() != null || this.targetFragment != null : !xr.getTargetFragment().trim().equals(this.targetFragment.trim())) {
            return false;
        }
        if (xr.getDisplay() == null || this.display == null ? xr.getDisplay() != null || this.display != null : !xr.getDisplay().equals(this.display)) {
            return false;
        }
        if (xr.getUriid() == null || this.getUriid() == null ? xr.getUriid() != null || this.getUriid() != null : !xr.getUriid().equals(this.getUriid())) {
            return false;
        }
        if (!"document".equals(this.display) && (xr.getTitle() == null || this.targetTitle == null ? xr.getTitle() != null || this.targetTitle != null : !xr.getTitle().equals(this.targetTitle))) {
            return false;
        }
        if (xr.getType() == null || this.type == null ? xr.getType() != null || this.type != null : !xr.getType().equalsIgnoreCase(this.type) && (!"Include".equals(this.type) || !"embed".equals(xr.getType()) && !"none".equals(xr.getType())) && (!"Include".equals(xr.getType()) || !"embed".equals(this.type) && !"none".equals(this.type)) && (!"Replace".equals(this.type) || !"embed".equals(xr.getType()) && !"none".equals(xr.getType())) && (!"Replace".equals(xr.getType()) || !"embed".equals(this.type) && !"none".equals(this.type)) && (!"Transclude".equals(this.type) && !"Embed".equals(this.type) || !"none".equals(xr.getType())) && (!"Transclude".equals(xr.getType()) && !"Embed".equals(xr.getType()) || !"none".equals(this.type))) {
            return false;
        }
        if (this.reverseLink) {
            if (!Objects.equals(xr.getReverseTitle(), this.reverseTitle)) {
                return false;
            }
            if (xr.getReverseType() == null || this.reverseType == null ? xr.getReverseType() != null || this.reverseType != null : !xr.getReverseType().equalsIgnoreCase(this.reverseType)) {
                return false;
            }
        }
        if (xr.getLabels() == null || this.labels == null ? xr.getLabels() != null || this.labels != null : !Arrays.equals(xr.getLabels(), this.labels)) {
            return false;
        }
        if (xr.getLevel() == null || this.level == null ? xr.getLevel() != null || this.level != null : !this.level.equals(xr.getLevel())) {
            return false;
        }
        if (xr.config == null || this.config == null ? xr.config != null || this.config != null : !xr.config.equals(this.config)) {
            return false;
        }
        if (this.reverseLink != xr.getReverseLink()) {
            return false;
        }
        return xr.getAdd() == this.isNew;
    }

    public int hashCode() {
        return (this.display != null ? this.display.hashCode() * 11 : 0) + (this.targetFragment != null ? this.targetFragment.hashCode() * 13 : 0) + (this.targetTitle != null ? this.targetTitle.hashCode() * 7 : 0) + (this.reverseLink ? 5 : 0) + (this.reverseType != null ? this.reverseType.hashCode() * 29 : 0) + (this.type != null ? this.type.hashCode() * 3 : 0) + (this.level != null ? this.level.hashCode() * 17 : 0) + (this.reverseTitle != null ? this.reverseTitle.hashCode() * 23 : 0) + (this.config != null ? this.config.hashCode() * 31 : 0);
    }

    public String toString() {
        return String.valueOf((Object)this.xrefType) + " xref with target_title = " + this.targetTitle + " target_uriid = " + this.targetUriid + " target_loc_frag = " + this.targetFragment + " target_docid = " + this.targetDocid + " target_href = " + this.targetHref + " target_reverselink = " + this.reverseLink + " reverse_title = " + this.reverseTitle + " target_display = " + this.display + " target_type = " + this.type + " level = " + this.level + " labels = " + Arrays.toString(this.labels) + " labels.length = " + this.labels.length + " reverse_target_type = " + this.reverseType + " target_add = " + this.isNew + " target_del = " + this.isOld;
    }

    public void reverseXRefToPSML(XMLWriter xml) throws IOException {
        this.reverseXRefToPSML(xml, true);
    }

    public void reverseXRefToPSML(XMLWriter xml, boolean close) throws IOException {
        if (!this.reverseLink) {
            return;
        }
        xml.openElement("reversexref");
        if (this.sourceURI != null) {
            String doctype;
            xml.attribute("uriid", String.valueOf(this.sourceURI.getId()));
            boolean external = URIs.isExternal((URI)this.sourceURI);
            if (external) {
                xml.attribute("external", "true");
                xml.attribute("href", URIs.getURIString((URI)this.sourceURI));
            } else {
                xml.attribute("href", this.sourceURI.getPath());
            }
            xml.attribute("frag", this.sourceFragment);
            String docTitle = this.sourceUriTitle != null ? this.sourceUriTitle : this.sourceURI.getDisplayTitle();
            String docLabels = this.sourceURI.getLabels();
            xml.attribute("urititle", docTitle);
            if (docLabels != null) {
                xml.attribute("urilabels", docLabels);
            }
            if (this.sourceURI.getDocID() != null) {
                xml.attribute("docid", this.sourceURI.getDocID());
            }
            if (this.sourceURI.getType() != null) {
                xml.attribute("mediatype", this.sourceURI.getType());
            }
            if (!Strings.isEmpty((String)(doctype = URIRule.getStyleConfig(this.sourceURI)))) {
                xml.attribute(external ? "urltype" : "documenttype", doctype);
            }
            if (URIRule.isArchived(this.sourceURI)) {
                xml.attribute("archived", "true");
            }
        }
        if (this.xlink != null) {
            xml.attribute("id", String.valueOf(this.xlink.getId()));
        } else if (this.id != null) {
            xml.attribute("id", this.id);
        }
        xml.attribute("title", this.reverseTitle);
        if (this.config != null) {
            xml.attribute("config", this.config);
        }
        xml.attribute("type", XRef.normaliseTypeForPSML(this.reverseType));
        xml.attribute("forwardtype", XRef.normaliseTypeForPSML(this.type));
        if (!Strings.isEmpty((String)this.targetTitle)) {
            xml.attribute("forwardtitle", this.targetTitle);
        }
        if (this.display != null) {
            xml.attribute("forwarddisplay", this.display);
        }
        xml.attribute("forwardfrag", this.targetFragment);
        if (this.level != null) {
            xml.attribute("level", this.level);
        }
        if (this.labels != null && this.labels.length > 0) {
            xml.attribute("labels", String.join((CharSequence)",", this.labels));
        }
        if (close) {
            xml.closeElement();
        }
    }

    private static String normaliseTypeForPSML(@Nullable String type) {
        if (type == null || type.isEmpty()) {
            return "none";
        }
        String newtype = type.toLowerCase();
        if (!("none".equals(newtype) || IMAGE.equals(newtype) || LINK.equals(newtype) || "embed".equals(newtype) || "transclude".equals(newtype) || "alternate".equals(newtype) || "math".equals(newtype))) {
            newtype = "embed";
        }
        return newtype;
    }

    public void xRefToPSML(XMLWriter xml, Database db, boolean close) throws IOException {
        this.xRefToPSML(xml, db, close, false, true);
    }

    public void xRefToPSML(XMLWriter xml, @Nullable Database db, boolean close, boolean dbformat) throws IOException {
        this.xRefToPSML(xml, db, close, dbformat, false);
    }

    public void xRefToPSML(XMLWriter xml, @Nullable Database db, boolean close, boolean dbformat, boolean xrefElement) throws IOException {
        xml.openElement(xrefElement ? "xref" : this.xrefType.toPSMLElement());
        if (this.xrefType == XRefType.IMAGE && !xrefElement) {
            if (this.targetUri != null) {
                xml.attribute("src", this.targetUri.getPath());
                xml.attribute("uriid", String.valueOf(this.targetUri.getId()));
                if (this.targetUri.getDocID() != null) {
                    xml.attribute("docid", this.targetUri.getDocID());
                }
                if (!dbformat && URIRule.isArchived(this.targetUri)) {
                    xml.attribute("archived", "true");
                }
            } else {
                if (!dbformat) {
                    xml.attribute("unresolved", "true");
                }
                if (this.targetHref != null) {
                    xml.attribute("src", this.targetHref);
                }
                if (this.targetDocid != null) {
                    xml.attribute("docid", this.targetDocid);
                }
            }
            if (this.labels != null && this.labels.length > 0) {
                xml.attribute("labels", String.join((CharSequence)",", this.labels));
            }
            for (String att : this.imageOrLinkAttributes) {
                String name = att.substring(0, att.indexOf(61));
                String value = att.substring(1 + att.indexOf(61));
                xml.attribute(name, value);
            }
        } else if (this.xrefType == XRefType.LINK && !xrefElement) {
            String frag;
            String string = frag = this.targetFragment != null && !"default".equals(this.targetFragment) ? "#" + this.targetFragment : "";
            if (this.targetUri != null) {
                xml.attribute("href", URIs.getURIString((URI)this.targetUri) + frag);
                xml.attribute("uriid", String.valueOf(this.targetUri.getId()));
                if (!dbformat && URIRule.isArchived(this.targetUri)) {
                    xml.attribute("archived", "true");
                }
            } else {
                if (!dbformat) {
                    xml.attribute("unresolved", "true");
                }
                if (this.targetHref != null) {
                    xml.attribute("href", this.targetHref + frag);
                } else if (!frag.isEmpty()) {
                    xml.attribute("href", frag);
                }
            }
            if (!frag.isEmpty()) {
                xml.attribute("frag", this.targetFragment);
            }
            if (this.labels != null && this.labels.length > 0) {
                xml.attribute("labels", String.join((CharSequence)",", this.labels));
            }
            for (String att : this.imageOrLinkAttributes) {
                String name = att.substring(0, att.indexOf(61));
                String value = att.substring(1 + att.indexOf(61));
                xml.attribute(name, value);
            }
            if (Strings.isEmpty((String)this.content) && dbformat && this.targetUri != null) {
                xml.writeText(this.targetUri.getDisplayTitle());
            } else {
                xml.writeXML(this.content);
            }
        } else {
            if (!dbformat) {
                if (this.xlink != null) {
                    xml.attribute("id", String.valueOf(this.xlink.getId()));
                } else if (this.id != null) {
                    xml.attribute("id", this.id);
                } else {
                    xml.attribute("unresolved", "true");
                }
            }
            if (this.targetTitle != null) {
                xml.attribute("title", this.targetTitle);
            }
            xml.attribute("frag", this.targetFragment);
            if (!dbformat && this.sourceFragment != null) {
                xml.attribute("reversefrag", this.sourceFragment);
            }
            if (this.reverseLink) {
                xml.attribute("reversetitle", this.reverseTitle);
                xml.attribute("reverselink", "true");
                if (this.reverseType != null) {
                    xml.attribute("reversetype", XRef.normaliseTypeForPSML(this.reverseType));
                }
            } else {
                xml.attribute("reverselink", "false");
            }
            xml.attribute("display", this.display);
            if (this.level != null) {
                xml.attribute("level", this.level);
            }
            if (this.config != null) {
                xml.attribute("config", this.config);
            }
            if (this.type != null) {
                xml.attribute("type", XRef.normaliseTypeForPSML(this.type));
            }
            if (this.labels != null && this.labels.length > 0) {
                xml.attribute("labels", String.join((CharSequence)",", this.labels));
            }
            String docTitle = null;
            if (this.targetUri != null) {
                xml.attribute("uriid", String.valueOf(this.targetUri.getId()));
                if (URIs.isExternal((URI)this.targetUri)) {
                    xml.attribute("external", "true");
                    xml.attribute("href", URIs.getURIString((URI)this.targetUri));
                } else {
                    xml.attribute("href", this.targetUri.getPath());
                }
                if (this.targetUri.getDocID() != null) {
                    xml.attribute("docid", this.targetUri.getDocID());
                }
                docTitle = this.targetUri.getDisplayTitle();
                String docLabels = this.targetUri.getLabels();
                if (!dbformat) {
                    String doctype;
                    String uritype;
                    xml.attribute("urititle", docTitle);
                    if (docLabels != null) {
                        xml.attribute("urilabels", docLabels);
                    }
                    if ((uritype = this.targetUri.getType()) != null && !uritype.isEmpty()) {
                        xml.attribute("mediatype", uritype);
                    }
                    if ((doctype = URIRule.getStyleConfig(this.targetUri)) != null && !doctype.isEmpty()) {
                        xml.attribute("documenttype", doctype);
                    }
                    if (URIRule.isArchived(this.targetUri)) {
                        xml.attribute("archived", "true");
                    }
                }
            } else {
                if (this.targetHref != null) {
                    xml.attribute("href", this.targetHref);
                }
                if (this.targetDocid != null) {
                    xml.attribute("docid", this.targetDocid);
                }
            }
            if (close) {
                if (this.display != null && this.display.startsWith("document") && this.targetUri != null) {
                    if ("document+manual".equals(this.display) && this.targetTitle != null) {
                        xml.writeText(docTitle + ": " + this.targetTitle);
                    } else if ("document+fragment".equals(this.display)) {
                        xml.writeText(docTitle + ": " + this.targetFragment);
                    } else {
                        xml.writeText(docTitle);
                    }
                } else if ("manual".equals(this.display) && this.targetTitle != null) {
                    xml.writeText(this.targetTitle);
                } else if ("template".equals(this.display)) {
                    if (this.targetTitle == null || this.targetUri == null || !FRAGMENT_DOCUMENT_FILENAME_DOCID.matcher(this.targetTitle).matches() && ContentAdjustor.PREFIX_HEADING_PARENTNUMBER.matcher(this.targetTitle).matches()) {
                        xml.writeXML(this.content == null ? "untitled" : this.content);
                    } else {
                        xml.writeText(this.templateTitle());
                    }
                } else if (this.content != null && !this.content.isEmpty()) {
                    xml.writeXML(this.content);
                } else {
                    xml.writeText("untitled");
                }
            }
        }
        if (close) {
            xml.closeElement();
        }
    }

    private String templateTitle() {
        return this.targetTitle.replace("{fragment}", this.targetFragment).replace("{document}", this.targetUri.getDisplayTitle()).replace("{filename}", URIRule.getFilenameAsString(this.targetUri.getDecodedPath())).replace("{docid}", this.targetUri.getDocID() == null ? "" : this.targetUri.getDocID()).replaceAll("\\{(prefix|heading|parentnumber)}", "x");
    }

    public void xRefToPSMLForComparison(XMLWriter xml) throws IOException {
        xml.openElement(this.xrefType.toPSMLElement());
        if (this.labels != null && this.labels.length > 0) {
            xml.attribute("labels", String.join((CharSequence)",", this.labels));
        }
        if (this.xrefType == XRefType.IMAGE) {
            if (this.targetUri != null) {
                xml.attribute("src", this.targetUri.getPath());
                xml.attribute("uriid", String.valueOf(this.targetUri.getId()));
                if (this.targetUri.getDocID() != null) {
                    xml.attribute("docid", this.targetUri.getDocID());
                }
            } else {
                if (this.targetHref != null) {
                    xml.attribute("src", this.targetHref);
                }
                if (this.targetUriid != null) {
                    xml.attribute("uriid", this.targetUriid);
                }
                if (this.targetDocid != null) {
                    xml.attribute("docid", this.targetDocid);
                }
            }
            for (String att : this.imageOrLinkAttributes) {
                String name = att.substring(0, att.indexOf(61));
                String value = att.substring(1 + att.indexOf(61));
                xml.attribute(name, value);
            }
        } else if (this.xrefType == XRefType.LINK) {
            if (this.targetUri != null) {
                xml.attribute("href", URIs.getURIString((URI)this.targetUri));
                xml.attribute("uriid", String.valueOf(this.targetUri.getId()));
            } else {
                if (this.targetHref != null) {
                    xml.attribute("href", this.targetHref);
                }
                if (this.targetUriid != null) {
                    xml.attribute("uriid", this.targetUriid);
                }
            }
            for (String att : this.imageOrLinkAttributes) {
                String name = att.substring(0, att.indexOf(61));
                String value = att.substring(1 + att.indexOf(61));
                xml.attribute(name, value);
            }
            if (Strings.isEmpty((String)this.content) && this.targetUri != null) {
                xml.writeText(this.targetUri.getDisplayTitle());
            } else {
                xml.writeXML(this.content);
            }
        } else {
            xml.attribute("title", this.targetTitle);
            xml.attribute("frag", this.targetFragment);
            if (this.reverseLink) {
                xml.attribute("reverselink", "true");
                xml.attribute("reversetitle", this.reverseTitle);
                if (this.reverseType != null) {
                    xml.attribute("reversetype", XRef.normaliseTypeForPSML(this.reverseType));
                }
            } else {
                xml.attribute("reverselink", "false");
            }
            xml.attribute("display", this.display);
            if (this.type != null) {
                xml.attribute("type", XRef.normaliseTypeForPSML(this.type));
            }
            if (this.level != null) {
                xml.attribute("level", this.level);
            }
            if (this.config != null) {
                xml.attribute("config", this.config);
            }
            if (this.targetUri != null) {
                xml.attribute("uriid", String.valueOf(this.targetUri.getId()));
                if (URIs.isExternal((URI)this.targetUri)) {
                    xml.attribute("href", URIs.getURIString((URI)this.targetUri));
                } else {
                    xml.attribute("href", this.targetUri.getPath());
                }
                if (this.targetUri.getDocID() != null) {
                    xml.attribute("docid", this.targetUri.getDocID());
                }
            } else {
                if (this.targetUriid != null) {
                    xml.attribute("uriid", this.targetUriid);
                }
                if (this.targetHref != null) {
                    xml.attribute("href", this.targetHref);
                }
                if (this.targetDocid != null) {
                    xml.attribute("docid", this.targetDocid);
                }
            }
        }
        if (this.xrefType == XRefType.XREF && "template".equals(this.display) && !Strings.isEmpty((String)this.content) && this.targetTitle != null && ContentAdjustor.PREFIX_HEADING_PARENTNUMBER.matcher(this.targetTitle).matches()) {
            xml.writeXML(this.content);
        }
        xml.closeElement();
    }

    private static String computeURIFullPath(String basePath, String hRef) {
        int previousSlash;
        String fullpath = basePath + "/" + hRef;
        int doubledot = fullpath.indexOf("/../");
        while (doubledot != -1 && (previousSlash = fullpath.substring(0, doubledot).lastIndexOf(47)) != -1) {
            fullpath = fullpath.substring(0, previousSlash) + fullpath.substring(doubledot + 3);
            doubledot = fullpath.indexOf("/../");
        }
        return fullpath;
    }

    public static @Nullable String getLevelFromXlink(XLink xl) {
        Matcher matcher;
        String properties = xl.getProperties();
        if (properties != null && (matcher = LEVEL_MATCHER.matcher(properties)).find()) {
            return matcher.group(2);
        }
        return null;
    }

    public static @Nullable String getConfigFromXlink(XLink xl) {
        Matcher matcher;
        String properties = xl.getProperties();
        if (properties != null && (matcher = CONFIG_MATCHER.matcher(properties)).find()) {
            return matcher.group(2);
        }
        return null;
    }
}

