/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.pageseeder.base.util.Thumbnail;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.DefaultResourceCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFThumbnail
implements Thumbnail {
    public static final int MAX_SECONDS = 30;
    private static final int DEFAULT_SIZE = 200;
    private static final int THREAD_PRIORITY = Math.round(1.0f);
    private static ExecutorService threadPool = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "ps-pdf-thumbnail-creator");
        t.setPriority(THREAD_PRIORITY);
        return t;
    });
    private int height = 200;
    private int width = 200;
    private String filename = null;

    @Override
    public void setHeight(int height) throws IllegalArgumentException {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setWidth(int width) throws IllegalArgumentException {
        this.width = width;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean createThumbnail(File original, File thumbnail) throws IOException {
        try (FileInputStream in = new FileInputStream(original);){
            boolean bl = this.createThumbnail(in, thumbnail);
            return bl;
        }
    }

    @Override
    public boolean createThumbnail(InputStream in, File thumbnail) {
        PDFThumbnailCreator creator = new PDFThumbnailCreator(this.filename, in, thumbnail, this.width, this.height);
        Future<String> running = PDFThumbnail.startThread(creator);
        try {
            running.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            running.cancel(true);
        }
        catch (InterruptedException | ExecutionException ex) {
            return false;
        }
        return true;
    }

    private static Future<String> startThread(Callable<String> thread) {
        return threadPool.submit(thread);
    }

    static {
        System.setProperty("org.apache.pdfbox.rendering.UsePureJavaCMYKConversion", "true");
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    private static class PDFThumbnailCreator
    implements Callable<String> {
        private static final Logger LOGGER = LoggerFactory.getLogger(PDFThumbnailCreator.class);
        private final String filename;
        private final int height;
        private final int width;
        private final InputStream in;
        private final File thumbnail;

        private PDFThumbnailCreator(String filename, InputStream in, File thumbnail, int width, int height) {
            this.filename = filename;
            this.width = width;
            this.height = height;
            this.in = in;
            this.thumbnail = thumbnail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            LOGGER.debug("Creating thumbnail ({}x{}) for PDF {}", new Object[]{this.width, this.height, this.filename});
            try {
                String string;
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(this.thumbnail));
                try {
                    try (PDDocument document = PDDocument.load((InputStream)this.in, (MemoryUsageSetting)MemoryUsageSetting.setupTempFileOnly());){
                        document.setResourceCache((ResourceCache)new DefaultResourceCache(){

                            public void put(COSObject indirect, PDXObject obj) {
                            }
                        });
                        PDRectangle page = document.getPage(0).getCropBox();
                        float scaleWidth = (float)this.width / page.getWidth();
                        float scaleHeight = (float)this.height / page.getHeight();
                        float scale = Math.min(scaleHeight, scaleWidth);
                        LOGGER.debug("Scale is {}", (Object)Float.valueOf(scale));
                        PDFRenderer pdfRenderer = new PDFRenderer(document);
                        pdfRenderer.setSubsamplingAllowed(true);
                        BufferedImage image = pdfRenderer.renderImage(0, scale, ImageType.RGB);
                        ImageIOUtil.writeImage((BufferedImage)image, (String)"jpeg", (OutputStream)bout);
                    }
                    string = "success";
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bout.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        if (Thread.interrupted()) {
                            LOGGER.error("PDF creation interrupted for {}", (Object)this.filename, (Object)ex);
                        } else {
                            LOGGER.error("Failed to create PDF for {}", (Object)this.filename, (Object)ex);
                        }
                        String string2 = "error";
                        return string2;
                    }
                }
                bout.close();
                return string;
            }
            finally {
                LOGGER.debug("Finished for {}!", (Object)this.filename);
            }
        }
    }
}

