/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.url;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.url.URLConfigHandler;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

public class URLFiles {
    public static final String URL_FOLDER = "url";
    public static final String URL_CONFIG = "url-config.xml";
    public static final String URL_TEMPLATE = "url-template.psml";
    public static final String DEFAULT = "default";

    private URLFiles() {
    }

    public static Set<String> listAvailableTypes(@Nullable String template) {
        String globalTemplate;
        HashSet<String> types = new HashSet<String>();
        if (template != null && !template.isEmpty()) {
            URLFiles.addTypes(types, new Template(template));
        }
        if ((globalTemplate = GlobalSettings.getGlobalTemplate()) != null && !globalTemplate.isEmpty() && !globalTemplate.equals(template)) {
            URLFiles.addTypes(types, new Template(globalTemplate));
        }
        if (!DEFAULT.equals(template) && !DEFAULT.equals(globalTemplate)) {
            URLFiles.addTypes(types, Template.DEFAULT);
        }
        return types;
    }

    public static @Nullable File findURLTemplate(@Nullable String type) {
        return URLFiles.findURLFile(type, URL_TEMPLATE);
    }

    public static @Nullable File findURLConfig(@Nullable String type) {
        return URLFiles.findURLFile(type, URL_CONFIG);
    }

    public static @Nullable URLConfig loadURLConfig(@Nullable String urltype, @Nullable LabelConfig projectLabels) throws FoundationException {
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        String groupTemplate = globalTemplate != null ? globalTemplate : DEFAULT;
        String type = urltype == null ? DEFAULT : urltype;
        File config = URLFiles.findURLConfig(type);
        if (config == null || !config.exists()) {
            return null;
        }
        List<LabelInfo> urlLabels = projectLabels == null ? null : projectLabels.getLabelInfos(LabelType.URL);
        URLConfigHandler handler = new URLConfigHandler(groupTemplate, urltype, urlLabels);
        TemplateFiles resources = new TemplateFiles(Template.DEFAULT);
        File defaultConfig = resources.findFile(URL_FOLDER + File.separator + type + File.separator + URL_CONFIG);
        URLFiles.parseDocumentConfig(defaultConfig, handler);
        resources = new TemplateFiles(groupTemplate);
        File cfg = resources.findFile(URL_FOLDER + File.separator + type + File.separator + URL_CONFIG);
        if (defaultConfig == null || !defaultConfig.equals(cfg)) {
            handler.startDocument();
            URLFiles.parseDocumentConfig(cfg, handler);
        }
        return handler.getConfig();
    }

    private static void addTypes(Set<String> types, Template template) {
        File[] subs;
        File webapp = new File(Settings.getContextPath());
        File dir = TemplateFiles.get((Template)template, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)URL_FOLDER);
        File[] fileArray = subs = dir == null ? null : dir.listFiles();
        if (subs != null) {
            for (File sub : subs) {
                if (sub == null || !sub.exists() || !sub.isDirectory() || sub.getName().startsWith(".")) continue;
                types.add(sub.getName());
            }
        }
    }

    private static @Nullable File findURLFile(@Nullable String type, String filename) {
        String globalTemplate = GlobalSettings.getGlobalTemplate((String)DEFAULT);
        String urltype = type == null ? DEFAULT : type;
        TemplateFiles resources = new TemplateFiles(globalTemplate);
        return resources.findFile(URL_FOLDER + File.separator + urltype + File.separator + filename);
    }

    private static void parseDocumentConfig(@Nullable File config, URLConfigHandler handler) throws FoundationException {
        if (config != null && config.exists() && config.isFile()) {
            ArrayList<String> errors = new ArrayList<String>();
            try (FileInputStream in = new FileInputStream(config);){
                XMLHelpers.parse(in, handler, errors, null);
            }
            catch (IOException ex) {
                throw new FoundationException("Failed to load URL config: " + ex.getMessage());
            }
            if (!errors.isEmpty()) {
                throw new FoundationException("Failed to parse URL config: " + (String)errors.get(0));
            }
        }
    }
}

