/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.serial;

import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.SubGroupRole;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.URISharing;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.serial.CSVOutputPrinter;
import com.pageseeder.base.serial.JSONOutputPrinter;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.io.CharsetDetector;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.HostAlias;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UniversalPrinter
extends OutputPrinter {
    private static final int MAX_NB_FIELDS = 15;
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalPrinter.class);
    private static final String GENERAL_URI_PATH = "/com.pageseeder.general/";
    private final OutputPrinter out;

    public UniversalPrinter(OutputPrinter out) {
        this.out = out;
    }

    public static UniversalPrinter newWriter(OutputType outputType) {
        switch (outputType) {
            case XML: {
                return new UniversalPrinter(new XMLOutputPrinter());
            }
            case JSON: {
                return new UniversalPrinter(new JSONOutputPrinter());
            }
        }
        throw new IllegalArgumentException("Unsupported output type " + String.valueOf((Object)outputType));
    }

    public static UniversalPrinter newWriter(Writer writer, OutputType outputType) {
        switch (outputType) {
            case XML: {
                return new UniversalPrinter(new XMLOutputPrinter(writer));
            }
            case JSON: {
                return new UniversalPrinter(new JSONOutputPrinter(writer));
            }
            case CSV: {
                return new UniversalPrinter(new CSVOutputPrinter(writer));
            }
        }
        throw new IllegalArgumentException("Unsupported output type " + String.valueOf((Object)outputType));
    }

    public void setCSVOutput(String object, List<String> columns) {
        if (this.out instanceof CSVOutputPrinter) {
            ((CSVOutputPrinter)this.out).setColumns(object, columns);
        }
    }

    public void setCSVOutput(String object, Map<String, String> columnsToHeaders) {
        if (this.out instanceof CSVOutputPrinter) {
            CSVOutputPrinter csv = (CSVOutputPrinter)this.out;
            csv.setColumns(object, columnsToHeaders.keySet());
            csv.setHeaders(columnsToHeaders.values());
        }
    }

    public void setCSVHeaders(List<String> headers) {
        if (this.out instanceof CSVOutputPrinter) {
            ((CSVOutputPrinter)this.out).setHeaders(headers);
        }
    }

    public void setCSVDateTimeFields(List<String> fields) {
        if (this.out instanceof CSVOutputPrinter) {
            ((CSVOutputPrinter)this.out).setDateTimeFields(fields);
        }
    }

    @Override
    public OutputType getType() {
        return this.out.getType();
    }

    @Override
    public void startObject(String name, OutputPrinter.ObjectOption option) {
        this.out.startObject(name, option);
    }

    @Override
    public void endObject() {
        this.out.endObject();
    }

    @Override
    public void startCollection(String name, OutputPrinter.CollectionOption option) {
        this.out.startCollection(name, option);
    }

    @Override
    public void endCollection() {
        this.out.endCollection();
    }

    @Override
    public void field(String name, boolean value, OutputPrinter.FieldOption option) {
        this.out.field(name, value, option);
    }

    @Override
    public void field(String name, long value, OutputPrinter.FieldOption option) {
        this.out.field(name, value, option);
    }

    @Override
    public void field(String name, String value, OutputPrinter.FieldOption option) {
        this.out.field(name, value, option);
    }

    @Override
    public void field(String name, String[] values, OutputPrinter.FieldOption option) {
        this.out.field(name, values, option);
    }

    public void write(UniversallyPrintable o) {
        o.print(this);
    }

    @Override
    public void close() {
        this.out.close();
    }

    public String toString() {
        return this.out.toString();
    }

    public void writeClient(Client client) {
        this.out.startObject("client");
        if (client.getId() != null) {
            this.out.field("id", client.getId());
        }
        this.out.field("identifier", client.getIdentifier());
        this.out.field("requires-consent", client.getRequiresConsent());
        this.out.field("confidential", client.getConfidential());
        this.out.field("name", client.getName());
        this.out.field("grant-type", client.getGrantType().toString());
        this.out.optionalField("created", client.getDateCreated());
        this.out.optionalField("modified", client.getDateModified());
        this.out.optionalField("last-token", client.getDateLastToken());
        this.out.optionalField("app", client.getAppName());
        this.out.optionalField("webhook-secret", client.getWebhookSecret());
        this.out.optionalField("redirect-uri", client.getRedirectURI());
        this.out.optionalField("description", client.getDescription());
        this.out.optionalField("client-uri", client.getClientURI());
        this.out.optionalField("scope", client.getScope());
        this.out.field("access-token-max-age", client.getAccessTokenMaxAge(TimeUnit.SECONDS));
        this.out.field("refresh-token-max-age", client.getRefreshTokenMaxAge(TimeUnit.SECONDS));
        Member member = client.getMember();
        if (member != null) {
            this.writeMember(member);
        }
        this.out.endObject();
    }

    public void writeComment(XLink comment) {
        this.writeComment(comment, null, null, null, false, true, true, false);
    }

    public void writeComment(XLink comment, @Nullable Database db, @Nullable Locator ignore, @Nullable Collection<Group> groups, boolean discussionid, boolean content, boolean attachments, boolean emails) {
        this.writeComment(comment, db, ignore, groups, discussionid, content, attachments, emails, null);
    }

    public void writeComment(XLink comment, @Nullable Database db, @Nullable Locator ignore, @Nullable Collection<Group> groups, boolean discussionid, boolean content, boolean attachments, boolean emails, @Nullable String xhtmlContent) {
        this.writeComment(comment, db, ignore, groups, discussionid, content, attachments, emails, xhtmlContent, null, null);
    }

    public void writeComment(XLink comment, @Nullable Database db, @Nullable Locator ignore, @Nullable Collection<Group> groups, boolean discussionid, boolean content, boolean attachments, boolean emails, @Nullable String xhtmlContent, @Nullable UserDetails userdetails, @Nullable String textContent) {
        List locators;
        Iterator replyTos;
        this.out.startObject("comment");
        this.out.field("id", comment.getId());
        boolean workflow = XLinks.isWorkflow((XLink)comment);
        XLink replyto = null;
        URI contextUri = null;
        Locator contextLoc = null;
        if ((discussionid || db != null || workflow) && (replyTos = comment.getReplyTos()).hasNext()) {
            replyto = (XLink)replyTos.next();
        }
        if (discussionid) {
            if (replyto != null) {
                this.out.field("discussionid", replyto.getId());
            } else {
                this.out.field("discussionid", comment.getId());
            }
        }
        if (workflow && (contextLoc = replyto != null ? LocatorRule.getLocatorByXLink(replyto) : LocatorRule.getLocatorByXLink(comment)) != null) {
            contextUri = contextLoc.getURI();
        }
        if (comment.getContentRole() != null) {
            this.out.field("contentrole", (String)(comment.getContentRole().endsWith("Documentation-Release") && comment.getStatus() != null ? (XLinks.isArchived((XLink)comment) ? "archive-" : "") + "Workflow" : comment.getContentRole()));
        }
        this.out.optionalField("type", comment.getType());
        this.out.optionalField("created", comment.getDate());
        this.out.optionalField("status", comment.getStatus());
        this.out.optionalField("priority", comment.getPriority());
        if (comment.getDueDate() != null) {
            this.out.field("due", ISO8601.format((long)comment.getDueDate().getTime(), (ISO8601)ISO8601.DATETIME));
        }
        Map props = ObjectProperties.toMap((String)comment.getProperties());
        HashMap noLabels = null;
        if (!props.isEmpty()) {
            noLabels = new HashMap(props);
            noLabels.remove("label");
            String properties = ObjectProperties.toString(noLabels);
            if (properties != null && !properties.isEmpty()) {
                this.out.field("properties", properties);
            }
        }
        if (!comment.getAccepted().booleanValue()) {
            this.out.field("moderated", true);
        }
        if (comment.getAuthorOnly().booleanValue()) {
            this.out.field("draft", true);
        }
        if (comment.getContentTitle() != null) {
            this.out.field("title", contextUri != null ? contextUri.getDisplayTitle() : comment.getContentTitle(), OutputPrinter.FieldOption.XML_ELEMENT);
        } else {
            this.out.field("title", "", OutputPrinter.FieldOption.XML_ELEMENT);
        }
        String[] labels = UniversalPrinter.cleanLabels((List)props.get("label"));
        if (labels.length > 0) {
            this.out.field("labels", labels, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        this.writeAuthor(comment, emails);
        Date modifiedDate = comment.getModifiedDate();
        if (comment.getModifiedBy() != null) {
            this.writeMember(comment.getModifiedBy(), emails, "modifiedby", modifiedDate);
        } else if (modifiedDate != null) {
            this.out.startObject("modifiedby");
            this.out.field("date", ISO8601.DATETIME.format(modifiedDate.getTime()));
            this.out.field("fullname", "Deleted member", OutputPrinter.FieldOption.XML_ELEMENT);
            this.out.endObject();
        }
        if (comment.getAssignedTo() != null) {
            this.writeMember(comment.getAssignedTo(), emails, "assignedto", comment.getAssignedDate());
        }
        if (noLabels != null && !noLabels.isEmpty()) {
            this.out.startCollection("properties");
            for (Map.Entry p : noLabels.entrySet()) {
                List values = (List)p.getValue();
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    this.out.startObject("property");
                    this.out.field("name", (String)p.getKey());
                    this.out.field("value", value);
                    this.out.endObject();
                }
            }
            this.out.endCollection();
        }
        if (content) {
            this.out.startCollection("content", OutputPrinter.CollectionOption.JSON_ONLY);
            Iterator conti = comment.getContents();
            Object contenttype = null;
            if (conti.hasNext()) {
                Content cont = (Content)conti.next();
                contenttype = cont.getType();
                this.out.startObject("content");
                this.out.field("type", (String)contenttype);
                if (cont.getData() != null) {
                    if (cont.getType() != null && (cont.getType().endsWith("/xml") || cont.getType().endsWith("+xml"))) {
                        this.out.field("value", cont.getData(), OutputPrinter.FieldOption.XML_COPY);
                    } else {
                        this.out.field("value", cont.getData(), OutputPrinter.FieldOption.XML_TEXT);
                    }
                }
                this.out.endObject();
            }
            if (textContent != null && !"text/plain".equals(contenttype)) {
                this.out.startObject("content");
                this.out.field("type", "text/plain");
                this.out.field("value", textContent, OutputPrinter.FieldOption.XML_TEXT);
                this.out.endObject();
            }
            if (xhtmlContent != null && !"application/xhtml+xml".equals(contenttype)) {
                this.out.startObject("content");
                this.out.field("type", "application/xhtml+xml");
                this.out.field("value", xhtmlContent, OutputPrinter.FieldOption.XML_COPY);
                this.out.endObject();
            }
            this.out.endCollection();
        }
        if (replyto != null && db != null) {
            this.out.startObject("context");
            if (contextLoc == null) {
                contextLoc = LocatorRule.getLocatorByXLink(replyto);
            }
            if (contextLoc != null) {
                String frag = contextLoc.getFragment();
                if (frag != null && !"default".equals(frag)) {
                    this.out.field("fragment", frag.endsWith("//Discussion") ? frag.substring(0, frag.length() - 12) : frag);
                }
                contextUri = contextLoc.getURI();
            }
            if (contextUri != null) {
                this.outputURI(contextUri, userdetails, db);
            }
            this.out.endObject();
        }
        Collection lfxs = comment.getLocatorsForXLinkCol();
        if (db != null) {
            for (Locator locator : lfxs.stream().filter(it -> it.getRole() == null).map(LocatorForXLink::getLocator).filter(it -> ignore == null || !ignore.getId().equals(it.getId())).collect(Collectors.toList())) {
                String frag = locator.getFragment();
                URI u = locator.getURI();
                this.out.startObject("context");
                if (frag != null && !"default".equals(frag)) {
                    this.out.field("fragment", frag.endsWith("//Discussion") ? frag.substring(0, frag.length() - 12) : frag);
                }
                this.outputURI(u, userdetails, db);
                this.out.endObject();
            }
        }
        if (attachments && !(locators = lfxs.stream().filter(it -> it.getRole() != null).map(LocatorForXLink::getLocator).filter(it -> ignore == null || !ignore.getId().equals(it.getId())).collect(Collectors.toList())).isEmpty()) {
            this.out.startCollection("attachments", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Locator locator : locators) {
                String frag = locator.getFragment();
                URI u = locator.getURI();
                this.out.startObject("attachment");
                if (frag != null && !"default".equals(frag)) {
                    this.out.field("fragment", frag.endsWith("//Discussion") ? frag.substring(0, frag.length() - 12) : frag);
                }
                this.outputURI(u, null, db);
                this.out.endObject();
            }
            this.out.endCollection();
        }
        if (groups != null) {
            this.out.startCollection("groups", OutputPrinter.CollectionOption.JSON_ONLY);
            Collection<Group> grpc = XLinkRule.getGroups(comment);
            if (!GroupRule.containsAdminGroup(groups)) {
                grpc = GroupRule.removeOtherNonPublicGroups(grpc, groups);
            }
            for (Group group : grpc) {
                if ("admin".equals(group.getName())) continue;
                this.out.startObject("group");
                this.out.field("id", group.getId());
                this.out.field("name", group.getName());
                this.out.endObject();
            }
            this.out.endCollection();
        }
        this.out.endObject();
    }

    public void writeAuthor(XLink xl, boolean email) {
        Member member = xl.getMember();
        if (member != null) {
            this.writeMember(member, email, "author", null);
        } else if (xl.getAuthorName() != null || xl.getAuthorEmail() != null) {
            this.out.startObject("author");
            if (email && xl.getAuthorEmail() != null && !"No Email".equals(xl.getAuthorEmail())) {
                this.out.optionalField("email", xl.getAuthorEmail());
            }
            this.out.optionalField("fullname", xl.getAuthorName(), OutputPrinter.FieldOption.XML_ELEMENT);
            this.out.endObject();
        }
    }

    private void outputURI(URI uri, @Nullable UserDetails userdetails, @Nullable Database db) {
        block7: {
            int i = uri.getPath().indexOf(GENERAL_URI_PATH);
            if (i != -1 && db != null) {
                String groupid = uri.getPath().substring(i + GENERAL_URI_PATH.length());
                try {
                    Long grpid = Long.parseLong(groupid);
                    Group group = DatabaseQuery.getGroupById((Database)db, (Long)grpid);
                    if (group != null) {
                        this.writeGroup(group);
                        break block7;
                    }
                    LOGGER.error("Failed to load group for group id: {}", (Object)grpid);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Failed to parse group id ({}) from path: {}", (Object)groupid, (Object)uri.getPath());
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to load group for group id: {}", (Object)groupid);
                }
            } else {
                this.writeURI(uri, false);
                if (userdetails != null) {
                    this.writeURISharingDetails(uri.getId(), userdetails, db);
                }
                this.out.endObject();
            }
        }
    }

    public void writeDiscussion(Discussion disc, @Nullable Database db, @Nullable Collection<Group> groups) {
        this.writeDiscussion(disc, "discussion", db, groups, true, true, false, null);
    }

    public void writeDiscussion(Discussion disc, String element, @Nullable Database db, @Nullable Collection<Group> groups, boolean content, boolean attachments, boolean emails, @Nullable UserDetails userdetails) {
        List replies;
        Member assignedTo;
        URI uri;
        XLink last;
        block22: {
            this.out.startObject(element);
            this.out.field("id", disc.getThreadID());
            this.out.optionalField("title", disc.getTitle());
            if (disc.getReplyCount() != null && disc.getReplyCount() != -1) {
                this.out.field("replycount", disc.getReplyCount().intValue());
            }
            if (disc.getLastCommentID() != null) {
                this.out.field("lastcommentid", disc.getLastCommentID());
            }
            this.out.optionalField("lastcommentdate", disc.getLastCommentDate());
            Object object = disc.getLastReply() != null ? disc.getLastReply() : (last = disc.getThreadID().equals(disc.getLastCommentID()) ? disc.getRootComment() : null);
            if ("task".equals(element) && last != null) {
                this.out.optionalField("status", last.getStatus());
                this.out.optionalField("priority", last.getPriority());
                this.out.optionalField("due", last.getDueDate());
            }
            if ((uri = disc.getUri()) != null) {
                int i = uri.getPath().indexOf(GENERAL_URI_PATH);
                if (i != -1) {
                    if (db != null) {
                        String groupid = uri.getPath().substring(i + GENERAL_URI_PATH.length());
                        try {
                            Long grpid = Long.parseLong(groupid);
                            Group group = DatabaseQuery.getGroupById((Database)db, (Long)grpid);
                            if (group != null) {
                                this.writeGroup(group);
                                break block22;
                            }
                            LOGGER.error("Failed to load group for group id: {}", (Object)grpid);
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.error("Failed to parse group id ({}) from path: {}", (Object)groupid, (Object)uri.getPath());
                        }
                        catch (QueryFailedException ex) {
                            LOGGER.error("Failed to load group for group id: {}", (Object)groupid);
                        }
                    }
                } else {
                    this.writeExternalURI(uri, false, null);
                    if (userdetails != null) {
                        this.writeURISharingDetails(uri.getId(), userdetails, db);
                    }
                    this.out.endObject();
                }
            }
        }
        if (disc.getLocator() != null && !"default".equals(disc.getLocator().getFragment())) {
            String frag = disc.getLocator().getFragment();
            if (frag != null) {
                this.out.startObject("locator");
                this.out.field("fragment", frag.endsWith("//Discussion") ? frag.substring(0, frag.length() - 12) : frag);
                this.out.endObject();
            } else {
                Long uriid = uri != null ? uri.getId() : null;
                LOGGER.error("Fragment is null for locatorid: {} in uriid: {}", (Object)disc.getLocator().getId(), (Object)uriid);
            }
        }
        if ("task".equals(element) && last != null && (assignedTo = last.getAssignedTo()) != null) {
            this.writeMember(assignedTo, emails, "assignedto", last.getAssignedDate());
        }
        this.out.startCollection("comments", OutputPrinter.CollectionOption.JSON_ONLY);
        if (disc.getRootComment() != null) {
            this.writeComment(disc.getRootComment(), null, null, groups, false, content, attachments, emails);
        }
        if ((replies = disc.getReplies()) != null) {
            for (XLink xl : replies) {
                this.writeComment(xl, null, null, groups, false, content, attachments, emails);
            }
        } else if (disc.getLastReply() != null) {
            this.writeComment(disc.getLastReply(), null, null, groups, false, content, attachments, emails);
        }
        if (disc.getDraftReply() != null) {
            this.writeComment(disc.getDraftReply(), null, null, groups, false, content, attachments, emails);
        }
        this.out.endCollection();
        this.out.endObject();
    }

    public void writeDraftEdit(XLink draft, Locator locator, @Nullable Collection<Group> groups, boolean close) {
        this.out.startObject("draft");
        this.out.field("id", draft.getId());
        this.out.optionalField("created", draft.getDate());
        this.writeAuthor(draft, false);
        Member accepted = draft.getStatusChangedBy();
        if (accepted != null) {
            this.writeMember(accepted, false, "acceptedby", draft.getStatusChangedDate());
        }
        URI u = locator.getURI();
        this.out.startObject("context");
        this.out.optionalField("fragment", locator.getFragment());
        this.writeURI(u);
        this.out.endObject();
        if (groups != null) {
            this.out.startCollection("groups", OutputPrinter.CollectionOption.JSON_ONLY);
            Collection<Group> grpc = XLinkRule.getGroups(draft);
            if (!GroupRule.containsAdminGroup(groups)) {
                grpc = GroupRule.removeOtherNonPublicGroups(grpc, groups);
            }
            for (Group group : grpc) {
                if ("admin".equals(group.getName())) continue;
                this.out.startObject("group");
                this.out.field("id", group.getId());
                this.out.field("name", group.getName());
                this.out.endObject();
            }
            this.out.endCollection();
        }
        if (close) {
            this.out.endObject();
        }
    }

    public void writeEditMembers(XLink edit) {
        Member statusChangedBy;
        this.writeAuthor(edit, false);
        Member modifiedBy = edit.getModifiedBy();
        if (modifiedBy != null) {
            this.writeMember(modifiedBy, false, "draftauthor", edit.getModifiedDate());
        }
        if ((statusChangedBy = edit.getStatusChangedBy()) != null) {
            this.writeMember(statusChangedBy, false, "acceptedby", edit.getStatusChangedDate());
        }
    }

    public void writeExternalURI(URI uri) {
        this.writeExternalURI(uri, true, null);
    }

    public void writeExternalURI(URI uri, boolean close, @Nullable Database db) {
        String[] beh;
        this.out.startObject("uri");
        this.out.field("id", uri.getId());
        this.out.field("scheme", uri.getScheme());
        this.out.field("host", uri.getHost().getName());
        this.out.field("port", uri.getPort().intValue());
        this.out.field("path", URIRule.getURIPathForOutput(uri));
        this.out.field("decodedpath", URIRule.getURIDecodedPathForOutput(uri));
        boolean external = URIs.isExternal((URI)uri);
        this.out.field("external", external);
        if (external) {
            if (uri.isArchived()) {
                this.out.field("archived", true);
            }
            if (uri.isFolder()) {
                this.out.field("folder", true);
            }
        } else if (URIRule.isInternalArchived(uri)) {
            this.out.field("archived", true);
        }
        if (!external && "folder".equals(uri.getType()) && db != null) {
            try {
                int groupCount = DatabaseQuery.getNumberGroupsByURIId((Database)db, (Long)uri.getId());
                this.out.field("sharing", groupCount > 1 ? "shared" : "private", close ? OutputPrinter.FieldOption.DEFAULT : OutputPrinter.FieldOption.NOT_JSON);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load shared groups for folder {}", (Object)uri.getId(), (Object)ex);
            }
        }
        this.out.optionalField("docid", uri.getDocID());
        this.out.optionalField("mediatype", uri.getType());
        if (uri.getBehavior() != null && (beh = uri.getBehavior().split("-")).length >= 2) {
            this.out.field(external ? "urltype" : "documenttype", beh[1]);
        }
        if (uri.getSize() != null && uri.getSize() > 0L) {
            this.out.field("size", uri.getSize());
        }
        this.out.optionalField("created", uri.getDateCreated());
        this.out.optionalField("modified", uri.getLastModified());
        if (external) {
            if (URIs.isURLPSSource((URI)uri)) {
                this.out.field("source", "pageseeder");
            } else if (uri.getHost().isVirtual()) {
                this.out.field("source", "virtual");
            }
        }
        this.out.optionalField("title", uri.getUserTitle());
        this.out.field("displaytitle", uri.getDisplayTitle(), OutputPrinter.FieldOption.XML_ELEMENT);
        this.out.optionalField("description", uri.getDescription(), OutputPrinter.FieldOption.XML_ELEMENT);
        String[] cleaned = UniversalPrinter.cleanLabels(uri.getLabels());
        if (cleaned.length > 0) {
            this.out.field("labels", cleaned, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (close) {
            this.out.endObject();
        }
    }

    public void writeURLUsage(URI uri, Long memberid, boolean allgroups, Database db) throws QueryFailedException {
        UserDetails userdetails = new UserDetailsManager().get(db, memberid, false);
        String adminEnable = GlobalSettings.getString((String)"adminEnable", (String)"");
        boolean allowPersonalGroups = adminEnable.contains("access-personal");
        String myPersonalGroupName = "member-" + memberid + "-home";
        Set groups = DatabaseQuery.getGroupsByURIReverseXRefsComments((Database)db, (Long)uri.getId());
        ArrayList<Group> accessGroups = new ArrayList<Group>();
        for (Group group : groups) {
            boolean groupPersonalCheck;
            boolean groupAccessCheck = allgroups || userdetails.flags().containsKey(group.getName());
            boolean bl = groupPersonalCheck = !GroupRule.isPersonalGroup(group.getName()) || allowPersonalGroups || myPersonalGroupName.equals(group.getName());
            if (!groupAccessCheck || !groupPersonalCheck) continue;
            accessGroups.add(group);
        }
        this.out.startObject("usage");
        if (accessGroups.size() != groups.size()) {
            this.out.field("hidden", groups.size() - accessGroups.size());
        }
        this.out.startCollection("groups", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group group : accessGroups) {
            this.writeGroup(group);
        }
        this.out.endCollection();
        this.out.endObject();
    }

    public void writeFile(File f, int recurse, boolean content) {
        this.writeFile(f, recurse, content, null);
    }

    public void writeFile(File f, int recurse, boolean content, @Nullable FileFields fields) {
        File webapp = new File(Settings.getContextPath());
        this.writeFile(f, webapp, recurse, content, fields);
    }

    public void writeFile(File f, File from, int recurse, boolean content, @Nullable FileFields fields) {
        String location;
        try {
            location = "/" + Files.path((File)from, (File)f);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.out.startObject("file");
        this.out.field("name", f.getName());
        this.out.field("path", location);
        if (f.exists()) {
            if (f.isDirectory()) {
                this.out.field("type", "folder");
                if (fields != null) {
                    fields.print(this.out, f, location);
                }
                if (recurse > 0) {
                    File[] files = f.listFiles(file -> file.canRead() && !file.isHidden() && file.getName().indexOf(46) != 0);
                    if (files == null) {
                        throw new IllegalStateException("Unable to list file in directory");
                    }
                    if (files.length > 0) {
                        this.out.startCollection("files", OutputPrinter.CollectionOption.JSON_ONLY);
                        for (File x : files) {
                            this.writeFile(x, recurse - 1, content, fields);
                        }
                        this.out.endCollection();
                    }
                }
            } else {
                String type = Medias.getMediaType(f);
                boolean isText = Medias.isText(type);
                this.out.field("type", "file");
                this.out.optionalField("mediatype", type);
                this.out.field("length", f.length());
                this.out.optionalField("modified", ISO8601.format((long)f.lastModified(), (ISO8601)ISO8601.DATETIME));
                this.out.field("text", isText);
                if (fields != null) {
                    fields.print(this.out, f, location);
                }
                if (content && isText && f.canRead()) {
                    CharBuffer cs = null;
                    try {
                        cs = CharsetDetector.decode((File)f);
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Unable to detect encoding for file");
                    }
                    if (cs != null) {
                        this.out.field("content", cs.toString(), OutputPrinter.FieldOption.XML_TEXT);
                    }
                }
            }
        } else {
            this.out.field("status", "not-found");
            String type = Medias.getMediaType(f);
            if (type != null) {
                boolean isText = Medias.isText(type);
                this.out.field("mediatype", type);
                this.out.field("text", isText);
            }
            if (fields != null) {
                fields.print(this.out, f, location);
            }
        }
        this.out.endObject();
    }

    public void writeGroup(Group group) {
        this.writeGroup(group, true, false, true, true);
    }

    public void writeGroup(Group group, boolean close, boolean allsettings, boolean asgroup) {
        this.writeGroup(group, close, allsettings, asgroup, null);
    }

    public void writeGroup(Group group, boolean close, boolean allsettings, boolean asgroup, @Nullable Database db) {
        this.writeGroup(group, close, allsettings, asgroup, !allsettings || db == null || GroupRule.hasModerator(group, db));
    }

    public void writeGroup(Group group, boolean close, boolean allsettings, boolean asgroup, boolean hasModerator) {
        String type = !asgroup && GroupRule.isProject(group) ? "project" : "group";
        this.out.startObject(type);
        this.fields(group, allsettings, hasModerator);
        if (allsettings) {
            this.out.optionalField("message", group.getMessage(), OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (close) {
            this.out.endObject();
        }
    }

    public void fields(Group group, boolean allsettings, boolean hasModerator) {
        this.out.field("id", group.getId());
        this.out.field("name", group.getName());
        this.out.field("type", GroupRule.isProject(group) ? "project" : "group", OutputPrinter.FieldOption.JSON_ONLY);
        if (group.getTitle() != null) {
            this.out.field("title", group.getTitle());
        }
        this.out.field("description", group.getDescription());
        this.out.field("owner", group.getOwner());
        String flags = group.getFlags() != null ? group.getFlags() : "";
        String access = flags.indexOf(112) != -1 ? "public" : "member";
        boolean common = flags.indexOf(109) != -1;
        this.out.field("access", access);
        this.out.field("common", common);
        this.out.optionalField("relatedurl", group.getHomeURL());
        if (allsettings) {
            this.out.optionalField("visibility", group.getControlGroupName());
            this.out.optionalField("template", group.getOwnerDirectory());
            this.out.optionalField("detailstype", group.getDetailsForm());
            boolean editurls = flags.indexOf(117) != -1;
            String registration = "normal";
            if (flags.indexOf(114) != -1) {
                registration = "moderated";
            } else if (flags.indexOf(99) != -1) {
                registration = "confirmed";
            }
            String defaultrole = "reviewer";
            if (flags.indexOf(116) != -1) {
                defaultrole = "contributor";
            }
            Notification defaultnotify = Notification.forFlags(flags);
            String commenting = "reviewer";
            if (flags.indexOf(97) != -1) {
                commenting = "public";
            } else if (flags.indexOf(111) != -1) {
                commenting = "contributor";
            }
            String moderation = "reviewer";
            if (flags.indexOf(103) != -1) {
                moderation = "all";
            } else if (flags.indexOf(101) == -1) {
                moderation = "email";
            }
            if (!hasModerator) {
                moderation = "none";
            }
            this.out.field("editurls", editurls);
            this.out.field("commenting", commenting);
            this.out.field("moderation", moderation);
            this.out.field("registration", registration);
            this.out.field("defaultrole", defaultrole);
            this.out.field("defaultnotify", defaultnotify.toString());
            if (group.getIndexVersion() != null) {
                this.out.field("indexversion", group.getIndexVersion().intValue());
            }
        }
    }

    public void writeGroupFolder(GroupURI groupuri, boolean close, @Nullable Database db) {
        Boolean shared = null;
        if (!groupuri.isExternal() && db != null) {
            try {
                shared = GroupURIRule.isShared(db, groupuri);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load shared groups for GroupURI {}", (Object)groupuri.getId(), (Object)ex);
            }
        }
        this.writeGroupFolder(groupuri, close, shared);
    }

    public void writeGroupFolder(GroupURI guri, boolean close, @Nullable Boolean shared) {
        this.out.startObject("groupfolder");
        this.out.field("id", guri.getId());
        this.out.field("scheme", guri.getScheme());
        this.out.field("host", guri.getHost().getName());
        this.out.field("port", guri.getPort().intValue());
        this.out.field("path", guri.getPath());
        this.out.field("external", guri.isExternal());
        try {
            this.out.field("public", GroupURIRule.belongsToGroup(guri, "public"));
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to load public flag for GroupURI {}: {}", (Object)guri.getId(), (Object)ex.getMessage());
        }
        if (shared != null) {
            this.out.field("sharing", shared != false ? "shared" : "private", close ? OutputPrinter.FieldOption.DEFAULT : OutputPrinter.FieldOption.NOT_JSON);
        }
        if (close) {
            this.out.endObject();
        }
    }

    public void writeGroupFolderSharingDetails(Long guriid, UserDetails userdetails, Database db) {
        GroupURI guri;
        try {
            guri = DatabaseQuery.getGroupURIById((Database)db, (Long)guriid);
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load GroupURI with ID {}", (Object)guriid, (Object)ex);
            return;
        }
        if (guri == null) {
            LOGGER.error("GroupURI not found with ID {}", (Object)guriid);
            return;
        }
        this.writeGroupFolderSharingDetails(guri, userdetails, db);
    }

    public void writeGroupFolderSharingDetails(GroupURI guri, UserDetails userdetails, Database db) {
        URI uri;
        try {
            uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)GroupURIs.truncatePath((String)guri.getPath()));
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load corresponding URI for GroupURI with ID {}", (Object)guri.getId(), (Object)ex);
            return;
        }
        if (uri == null) {
            LOGGER.error("Corresponding URI not found for GroupURI with ID {}", (Object)guri.getId());
            return;
        }
        this.writeURISharingDetails(uri.getId(), userdetails, db);
    }

    public void writeHost(Host host) {
        this.out.startObject("host");
        this.out.field("id", host.getId());
        this.out.field("name", host.getName());
        this.out.field("external", host.isExternal());
        this.out.field("virtual", host.isVirtual());
        Iterator has = host.getHostAliases();
        if (has.hasNext()) {
            this.out.startCollection("aliases");
            while (has.hasNext()) {
                HostAlias ha = (HostAlias)has.next();
                this.out.startObject("alias");
                this.out.field("id", ha.getId());
                this.out.field("name", ha.getName());
                this.out.endObject();
            }
            this.out.endCollection();
        }
        this.out.endObject();
    }

    public void writeMember(Member member) {
        this.writeMember(member, false);
    }

    public void writeMember(Member member, boolean includeEmail) {
        this.writeMember(member, includeEmail, "member", null);
    }

    public void writeMember(Member member, boolean includeEmail, String name, @Nullable Date date) {
        this.writeMember(member, includeEmail, false, name, date, false);
    }

    public void writeMember(Member member, boolean includeEmail, boolean includeExtended, String name, @Nullable Date date, boolean admin) {
        this.out.startObject(name);
        this.out.field("id", member.getId());
        this.out.field("firstname", Objects.toString(member.getFirstName(), ""));
        this.out.field("surname", Objects.toString(member.getSurname(), ""));
        this.out.field("username", member.getUsername());
        this.out.optionalField("externalid", member.getExternalUserId());
        String flags = Objects.toString(member.getSubmitPref(), "");
        if (flags.indexOf(118) != -1) {
            this.out.field("onvacation", true);
        }
        if (flags.indexOf(116) != -1) {
            this.out.field("attachments", true);
        }
        if (includeEmail && member.getEmail() != null && MemberRule.hasEmail(member)) {
            this.out.field("email", member.getEmail());
        }
        if (includeExtended) {
            this.out.optionalField("created", member.getCreated());
            this.out.optionalField("activated", member.getActivated());
            this.out.optionalField("lastpasswordchange", member.getLastPasswordChange());
            this.out.optionalField("lastlogin", member.getLastLogin());
        }
        String status = "activated";
        if (MemberRule.isMemberDisabled(member)) {
            status = "disabled";
        } else if (flags.indexOf(112) != -1) {
            status = "set-password";
        } else if (!MemberRule.isMemberActivated(member)) {
            status = "unactivated";
        }
        this.out.field("status", status);
        if (AccountLockout.isLoginLocked(member.getUsername()) || AccountLockout.isLoginLocked(member.getEmail())) {
            this.out.field("locked", true);
        }
        if (admin) {
            this.out.field("admin", true);
        }
        this.out.optionalField("date", date);
        this.out.field("fullname", MemberRule.getFullName(member), OutputPrinter.FieldOption.XML_ELEMENT);
        this.out.endObject();
    }

    public void writeMembership(Membership membership, @Nullable MemberDetailsConfig config, @Nullable MemberDetailsConfig.Visibility visibility, @Nullable Database db) {
        this.writeMembership(membership, MembershipFormatOption.GROUP_AND_MEMBER, config, visibility, db);
    }

    public void writeMembership(Membership membership, MembershipFormatOption option, @Nullable MemberDetailsConfig config, @Nullable MemberDetailsConfig.Visibility visibility, @Nullable Database db) {
        this.writeMembership(membership, option.includeMembers, option.includegroups, false, config, visibility, db);
    }

    public void writeMembership(Membership membership, boolean includeMembers, boolean includeGroups, boolean groupAllSettings, @Nullable MemberDetailsConfig config, @Nullable MemberDetailsConfig.Visibility visibility, @Nullable Database db) {
        String subgroups;
        this.out.startObject("membership");
        Long id = membership.getMemberForGroupID();
        if (id != null) {
            this.out.field("id", id);
        }
        this.out.field("email-listed", membership.getListed());
        this.out.field("notification", membership.getNotification().toString());
        this.out.field("status", membership.getStatus().toString());
        Role r = membership.getRole();
        if (r != null) {
            this.out.field("role", r.attribute());
        }
        if (membership.isDeleted()) {
            this.out.field("deleted", true);
        }
        if ((subgroups = membership.getSubgroupsAsString()) != null) {
            this.out.field("subgroups", subgroups);
            Object override = "";
            if (!membership.isInheritListed()) {
                override = (String)override + "listed,";
            }
            if (!membership.isInheritNotification()) {
                override = (String)override + "notification,";
            }
            if (!membership.isInheritRole()) {
                override = (String)override + "role,";
            }
            if (!((String)override).isEmpty()) {
                this.out.field("override", ((String)override).substring(0, ((String)override).length() - 1));
            }
        }
        this.out.optionalField("created", membership.getCreated());
        if (includeMembers) {
            this.writeMember(membership.getMember(), membership.getListed() || visibility != MemberDetailsConfig.Visibility.GROUP);
        }
        if (includeGroups) {
            Group group = membership.getGroup();
            this.writeGroup(group, true, groupAllSettings, false, db);
        }
        if (config != null && db != null) {
            MemberGroupDetails details = null;
            if (config.isShared()) {
                try {
                    details = DatabaseQuery.getMemberGroupDetailsByMemberIdOwnerForm((Database)db, (Long)membership.getMember().getId(), (String)membership.getGroup().getOwner(), (String)membership.getGroup().getDetailsForm());
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to load shared details for membership: {}", (Object)membership.getMemberForGroupID());
                }
            } else {
                details = membership.getMemberGroupDetails();
            }
            this.writeMembershipDetails(config, details, visibility);
        }
        this.out.endObject();
    }

    public void writeMembershipDetails(@Nullable MemberDetailsConfig config, @Nullable MemberGroupDetails details, @Nullable MemberDetailsConfig.Visibility visibility) {
        this.out.startCollection("details");
        if (config != null) {
            for (int i = 1; i <= 15; ++i) {
                MemberDetailsConfig.FieldConfig field;
                if (!config.isVisibleTo(i, visibility) || (field = config.getFieldConfig(i)) == null) continue;
                String value = null;
                this.out.startObject("field");
                this.out.field("position", field.position());
                this.out.field("name", field.name());
                this.out.field("editable", field.isEditable());
                this.out.optionalField("title", field.getTitle());
                this.out.optionalField("type", field.getType());
                if (details != null) {
                    value = details.getField(i);
                    this.out.optionalField("value", value, OutputPrinter.FieldOption.XML_TEXT);
                }
                this.out.endObject();
                this.out.optionalField(field.name(), value, OutputPrinter.FieldOption.CSV_ONLY);
            }
        }
        this.out.endCollection();
    }

    public void writePersistentToken(PersistentToken token) {
        this.writePersistentToken(token, true);
    }

    public void writePersistentToken(PersistentToken token, boolean includeToken) {
        Member member;
        this.out.startObject("persistent-token");
        if (token.getId() != null) {
            this.out.field("id", token.getId());
        }
        this.out.field("scope", token.getScope());
        this.out.field("lifetime", token.maxAge(TimeUnit.SECONDS));
        this.out.optionalField("issued", token.getIssuedAt());
        this.out.optionalField("expires", token.getExpires());
        this.out.field("expired", token.hasExpired());
        if (includeToken) {
            this.out.optionalField("token", token.getActualToken());
        }
        this.out.optionalField("data", token.getData());
        Client client = token.getClient();
        if (client != null) {
            this.writeClient(client);
        }
        if ((member = token.getMember()) != null) {
            this.writeMember(member);
        }
        this.out.endObject();
    }

    public void writeSubgroup(GroupForGroup group) {
        String listed = Objects.toString(group.getListed(), "inherit");
        this.out.startObject("subgroup");
        this.out.field("id", group.getId());
        this.out.field("listed", listed);
        if (group.getRoleFlags() != null) {
            SubGroupRole role = SubGroupRole.forGroupForGroupFlags(group.getRoleFlags());
            if (role != null) {
                this.out.field("role", role.attribute());
            }
        } else {
            this.out.field("role", "inherit");
        }
        if (group.getNotification() != null) {
            this.out.field("notification", group.getNotification().toLowerCase());
        } else {
            this.out.field("notification", "inherit");
        }
        this.writeGroup(group.getMemberGroup());
        this.out.endObject();
    }

    public void writeSupergroup(GroupForGroup group) {
        String listed = Objects.toString(group.getListed(), "inherit");
        this.out.startObject("supergroup");
        this.out.field("id", group.getId());
        this.out.field("listed", listed);
        if (group.getRoleFlags() != null) {
            SubGroupRole role = SubGroupRole.forGroupForGroupFlags(group.getRoleFlags());
            if (role != null) {
                this.out.field("role", role.attribute());
            }
        } else {
            this.out.field("role", "inherit");
        }
        if (group.getNotification() != null) {
            this.out.field("notification", group.getNotification().toLowerCase());
        } else {
            this.out.field("notification", "inherit");
        }
        this.writeGroup(group.getGroup());
        this.out.endObject();
    }

    public void writeURI(URI uri) {
        this.writeURI(uri, true, null);
    }

    public void writeURI(URI uri, boolean close) {
        this.writeURI(uri, close, null);
    }

    public void writeURI(URI uri, boolean close, @Nullable Database db) {
        this.out.startObject("uri");
        this.out.field("id", uri.getId());
        this.out.field("scheme", uri.getScheme());
        this.out.field("host", uri.getHost().getName());
        this.out.field("port", uri.getPort().intValue());
        this.out.field("path", URIRule.getURIPathForOutput(uri));
        this.out.field("decodedpath", URIRule.getURIDecodedPathForOutput(uri));
        boolean external = URIs.isExternal((URI)uri);
        this.out.field("external", external);
        if (!external && "folder".equals(uri.getType()) && db != null) {
            try {
                int groupCount = DatabaseQuery.getNumberGroupsByURIId((Database)db, (Long)uri.getId());
                this.out.field("sharing", groupCount > 1 ? "shared" : "private");
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load shared groups for folder {}", (Object)uri.getId(), (Object)ex);
            }
        }
        this.out.optionalField("docid", uri.getDocID());
        this.out.field("mediatype", uri.getType());
        String type = UniversalPrinter.toType(uri);
        if (type != null) {
            this.out.field(external ? "urltype" : "documenttype", type);
        }
        this.out.optionalField("created", uri.getDateCreated());
        this.out.optionalField("modified", uri.getLastModified());
        this.out.optionalField("title", uri.getUserTitle());
        long size = UniversalPrinter.toSize(uri);
        if (size > 0L) {
            this.out.field("size", size);
        }
        this.out.field("displaytitle", uri.getDisplayTitle(), OutputPrinter.FieldOption.XML_ELEMENT);
        this.out.optionalField("description", uri.getDescription(), OutputPrinter.FieldOption.XML_ELEMENT);
        String[] labels = UniversalPrinter.cleanLabels(uri.getLabels());
        if (labels.length > 0) {
            this.out.field("labels", labels, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (close) {
            this.out.endObject();
        }
    }

    private static @Nullable String toType(URI uri) {
        String[] beh;
        String behavior = uri.getBehavior();
        if (behavior != null && (beh = behavior.split("-")).length >= 2) {
            return beh[1];
        }
        return null;
    }

    private static long toSize(URI uri) {
        Long size = uri.getSize();
        return size != null ? size : -1L;
    }

    public void writeURISharingDetails(Long uriid, UserDetails userdetails, Database db) {
        URISharing details = URIRule.getSharingDetails(uriid, userdetails, db);
        if (details != null) {
            details.print(this.out);
        }
    }

    public void writeWebhook(Webhook webhook) {
        this.out.startObject("webhook");
        if (webhook.getId() != null) {
            this.out.field("id", webhook.getId());
        }
        this.out.field("created", ISO8601.DATETIME.format(webhook.getDateCreated().getTime()));
        this.out.field("modified", ISO8601.DATETIME.format(webhook.getDateModified().getTime()));
        this.out.field("url", webhook.getURL());
        this.out.field("server", webhook.getServer());
        this.out.field("object", webhook.getObject().toString());
        this.out.field("format", webhook.getFormat().toString());
        this.out.field("insecuressl", webhook.getInsecureSSL());
        this.out.field("status", webhook.getStatus().toString());
        this.out.optionalField("name", webhook.getName());
        this.out.optionalField("projects", webhook.getProjects());
        this.out.optionalField("groups", webhook.getGroups());
        this.out.optionalField("events", webhook.getEvents());
        Client client = webhook.getClient();
        if (client != null) {
            this.writeClient(client);
        }
        this.out.endObject();
    }

    public void writeVersion(XLink version) {
        Member author;
        this.out.startObject("version");
        this.out.field("id", version.getId());
        this.out.field("name", version.getContentTitle());
        this.out.field("created", ISO8601.format((long)version.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
        Collection att = version.getAttached();
        if (!att.isEmpty()) {
            this.out.field("publicationid", ((XLinkForAttachedXLink)att.iterator().next()).getAttachedXLink().getContentTitle());
        }
        if ((author = version.getMember()) != null) {
            this.out.startObject("author");
            this.out.field("id", author.getId());
            this.out.optionalField("firstname", author.getFirstName());
            this.out.optionalField("surname", author.getSurname());
            this.out.field("fullname", MemberRule.getFullName(author), OutputPrinter.FieldOption.XML_ELEMENT);
            this.out.endObject();
        } else if (version.getAuthorName() != null) {
            this.out.startObject("author");
            this.out.field("fullname", version.getAuthorName(), OutputPrinter.FieldOption.XML_ELEMENT);
            this.out.endObject();
        }
        for (Content content : version.getContentsCol()) {
            String data = content.getData();
            if (data == null || data.isEmpty()) continue;
            this.out.field("description", data, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        this.out.field("labels", UniversalPrinter.cleanLabels(Labels.getLabels((XLink)version)), OutputPrinter.FieldOption.XML_ELEMENT);
        this.out.endObject();
    }

    public void writeWorkflow(List<XLink> xlinks, boolean comments, boolean statusChanged, @Nullable URI uri, @Nullable Long releaseid) {
        Date statusChangedDate = null;
        XLink latest = null;
        boolean found = false;
        for (int i = xlinks.size() - 1; i >= 0; --i) {
            XLink wf = xlinks.get(i);
            if (!(found || releaseid != null && wf.getId() > releaseid)) {
                latest = wf;
                found = true;
            }
            if (!found) continue;
            String status = latest.getStatus();
            if (status != null && !status.equals(wf.getStatus())) break;
            statusChangedDate = wf.getDate();
        }
        this.out.startObject("workflow");
        if (latest != null) {
            Member assigned;
            this.out.field("id", XLinks.getThreadRoot((XLink)latest).getId());
            this.out.field("status", latest.getStatus());
            this.out.optionalField("priority", latest.getPriority());
            this.out.optionalField("due", latest.getDueDate());
            if (statusChanged) {
                this.out.optionalField("statuschanged", statusChangedDate);
            }
            if ((assigned = latest.getAssignedTo()) != null) {
                this.writeMember(assigned, false, "assignedto", latest.getAssignedDate());
            }
        }
        if (uri != null) {
            this.writeURI(uri);
        }
        if (comments) {
            this.out.startCollection("comments", OutputPrinter.CollectionOption.JSON_ONLY);
            for (XLink xlink : xlinks) {
                this.writeComment(xlink);
            }
            this.out.endCollection();
        }
        this.out.endObject();
    }

    public void writeMemberData(XLink xl) {
        Date created = xl.getDate();
        Date modified = xl.getModifiedDate() != null ? xl.getModifiedDate() : xl.getDate();
        this.out.startObject("memberdata");
        this.out.field("id", xl.getId());
        this.out.field("name", xl.getType());
        this.out.optionalField("title", xl.getContentTitle());
        this.out.optionalField("created", created);
        this.out.optionalField("modified", modified);
        Iterator contents = xl.getContents();
        if (contents.hasNext()) {
            Content content = (Content)contents.next();
            String mediatype = content.getType();
            byte[] bytes = content.getData() != null ? content.getData().getBytes(StandardCharsets.UTF_8) : content.getBinaryData();
            int length = bytes != null ? bytes.length : -1;
            this.out.field("mediatype", mediatype);
            this.out.field("length", length);
        }
        this.out.field("public", xl.getType().startsWith("public-"));
        if (xl.getMember() != null) {
            this.out.field("memberid", xl.getMember().getId());
        }
        this.out.endObject();
    }

    public void writeAuthenticator(Authenticator authenticator) {
        this.out.startObject("authenticator");
        this.out.field("id", authenticator.getId());
        this.out.field("member", authenticator.getMemberId());
        this.out.field("public-id", authenticator.getPublicId());
        if (!authenticator.isVerified()) {
            String data = ConfidentialData.getData(authenticator);
            this.out.field("data", data != null ? data : "");
        }
        this.out.optionalField("name", authenticator.getName());
        this.out.field("type", authenticator.getType());
        this.out.field("created", ISO8601.format((long)authenticator.getCreated().getTime(), (ISO8601)ISO8601.DATETIME));
        this.out.optionalField("last-used", authenticator.getLastUsed());
        this.out.field("verified", authenticator.isVerified());
        Map parameters = authenticator.getParametersAsMap();
        if (!parameters.isEmpty()) {
            this.out.startObject("parameters");
            for (Map.Entry entry : parameters.entrySet()) {
                if (!((String)entry.getKey()).matches("^[a-zA-Z0-9_-]+$")) continue;
                this.out.field((String)entry.getKey(), (String)entry.getValue());
            }
            this.out.endObject();
        }
        this.out.endObject();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    private static String[] cleanLabels(@Nullable String labels) {
        return labels == null || labels.isEmpty() ? new String[]{} : UniversalPrinter.cleanLabels(labels.split(","));
    }

    private static String[] cleanLabels(String @Nullable [] labels) {
        return labels == null || labels.length == 0 ? new String[]{} : UniversalPrinter.cleanLabels(Arrays.asList(labels));
    }

    private static String[] cleanLabels(@Nullable List<String> labels) {
        return labels == null ? new String[]{} : labels.stream().filter(l -> !l.isEmpty()).collect(Collectors.toList()).toArray(new String[0]);
    }

    public static interface FileFields {
        public void print(OutputPrinter var1, File var2, String var3);
    }

    public static enum MembershipFormatOption {
        GROUP_AND_MEMBER(true, true),
        MEMBER_ONLY(true, false),
        GROUP_ONLY(false, true);

        final boolean includeMembers;
        final boolean includegroups;

        private MembershipFormatOption(boolean includeMembers, boolean includegroups) {
            this.includeMembers = includeMembers;
            this.includegroups = includegroups;
        }
    }
}

