/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Random;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccountLockout {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountLockout.class);
    private static final SafeCacheWrapper<String, LockoutRecord> CACHE_LOGIN;
    private static final SafeCacheWrapper<String, LockoutRecord> CACHE_RESET_PWD;
    private static final SafeCacheWrapper<String, LockoutRecord> CACHE_AUTHENTICATOR;
    private static int minBadLogins;
    private static int maxBadLogins;
    private static int minAccountLockout;
    private static int maxAccountLockout;
    private static final int DEFAULT_MIN_BAD_LOGINS = 5;
    private static final int DEFAULT_MAX_BAD_LOGINS = 10;
    private static final int DEFAULT_MIN_ACCOUNT_LOCKOUT = 30;
    private static final int DEFAULT_MAX_ACCOUNT_LOCKOUT = 60;
    private static final int ONE_MINUTE_IN_SECONDS = 60;
    private static final Random RANDOM;

    private AccountLockout() {
    }

    public static void retrieveSettings() {
        minBadLogins = GlobalSettings.getInt((String)"minBadLogins", (int)5);
        maxBadLogins = GlobalSettings.getInt((String)"maxBadLogins", (int)10);
        minAccountLockout = GlobalSettings.getInt((String)"minAccountLockout", (int)30);
        maxAccountLockout = GlobalSettings.getInt((String)"maxAccountLockout", (int)60);
    }

    public static void unlockLogin(@Nullable String username) {
        if (username == null || username.isEmpty()) {
            return;
        }
        CACHE_LOGIN.remove(username);
    }

    public static void unlockResetPassword(@Nullable String email) {
        if (email == null || email.isEmpty()) {
            return;
        }
        CACHE_RESET_PWD.remove(email);
    }

    public static void unlockAuthenticator(@Nullable String authenticator) {
        if (authenticator == null || authenticator.isEmpty()) {
            return;
        }
        CACHE_AUTHENTICATOR.remove(authenticator);
    }

    public static boolean isLoginLocked(@Nullable String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        LockoutRecord lockout = CACHE_LOGIN.get(username);
        if (lockout == null) {
            return false;
        }
        return lockout.isLocked();
    }

    public static boolean isAuthenticatorLocked(@Nullable String authenticator) {
        if (authenticator == null || authenticator.isEmpty()) {
            return false;
        }
        LockoutRecord lockout = CACHE_AUTHENTICATOR.get(authenticator);
        if (lockout == null) {
            return false;
        }
        return lockout.isLocked();
    }

    public static boolean isResetPasswordLocked(@Nullable String email) {
        if (email == null || email.isEmpty()) {
            return false;
        }
        LockoutRecord lockout = CACHE_RESET_PWD.get(email);
        if (lockout == null) {
            return false;
        }
        return lockout.isLocked();
    }

    public static void badLogin(@Nullable String username) {
        LockoutRecord lockout;
        if (username == null || username.isEmpty()) {
            return;
        }
        Element elem = CACHE_LOGIN.getElement(username);
        if (elem == null) {
            lockout = new LockoutRecord(AccountLockout.generateMaxAllowedAttempts());
            elem = new Element((Serializable)((Object)username), (Serializable)lockout);
            elem.setTimeToLive(AccountLockout.generateLockingPeriodSeconds());
            CACHE_LOGIN.putElement(elem);
        } else {
            lockout = (LockoutRecord)elem.getObjectValue();
        }
        lockout.badAttempt(elem.getTimeToLive());
        SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Failed login attempt for username " + username);
        LOGGER.warn("Failed Login Attempt for username {}", (Object)username);
        if (lockout.isLocked()) {
            SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Locked login for username " + username);
            LOGGER.warn("Locked Login for username {}", (Object)username);
        }
    }

    public static void badResetPassword(@Nullable String email) {
        LockoutRecord lockout;
        if (email == null || email.isEmpty() || "No Email".equals(email)) {
            return;
        }
        Element elem = CACHE_RESET_PWD.getElement(email);
        if (elem == null) {
            lockout = new LockoutRecord(AccountLockout.generateMaxAllowedAttempts());
            elem = new Element((Serializable)((Object)email), (Serializable)lockout);
            elem.setTimeToLive(AccountLockout.generateLockingPeriodSeconds());
            CACHE_RESET_PWD.putElement(elem);
        } else {
            lockout = (LockoutRecord)elem.getObjectValue();
        }
        lockout.badAttempt(elem.getTimeToLive());
        LOGGER.warn("Failed Reset Password Attempt for email {}", (Object)email);
        SecurityLog.warn(SecurityLog.EventType.PASSWORD_CHANGE, "Failed Reset Password Attempt for email");
    }

    public static void badAuthenticator(@Nullable String authenticator) {
        LockoutRecord lockout;
        if (authenticator == null || authenticator.isEmpty()) {
            return;
        }
        Element elem = CACHE_AUTHENTICATOR.getElement(authenticator);
        if (elem == null) {
            lockout = new LockoutRecord(5);
            elem = new Element((Serializable)((Object)authenticator), (Serializable)lockout);
            elem.setTimeToLive(AccountLockout.generateLockingPeriodSeconds());
            CACHE_AUTHENTICATOR.putElement(elem);
        } else {
            lockout = (LockoutRecord)elem.getObjectValue();
        }
        lockout.badAttempt(elem.getTimeToLive());
        LOGGER.warn("Failed authenticator attempt for ID {}", (Object)authenticator);
    }

    public static void lockResetPassword(@Nullable String email) {
        LockoutRecord lockout;
        if (email == null || email.isEmpty() || "No Email".equals(email)) {
            return;
        }
        Element elem = CACHE_RESET_PWD.getElement(email);
        if (elem == null) {
            lockout = new LockoutRecord(AccountLockout.generateMaxAllowedAttempts());
            elem = new Element((Serializable)((Object)email), (Serializable)lockout);
            elem.setTimeToLive(AccountLockout.generateLockingPeriodSeconds());
            CACHE_RESET_PWD.putElement(elem);
        } else {
            lockout = (LockoutRecord)elem.getObjectValue();
        }
        lockout.lock(elem.getTimeToLive());
        SecurityLog.warn(SecurityLog.EventType.PASSWORD_CHANGE, "Failed Reset Password Attempt for email " + email);
        LOGGER.warn("Failed Reset Password Attempt for email {}", (Object)email);
    }

    private static int generateLockingPeriodSeconds() {
        return minAccountLockout + RANDOM.nextInt(maxAccountLockout - minAccountLockout) * 60;
    }

    private static int generateMaxAllowedAttempts() {
        return minBadLogins + RANDOM.nextInt(maxBadLogins - minBadLogins);
    }

    static {
        RANDOM = new SecureRandom();
        CACHE_LOGIN = SafeCacheWrapper.getInstance("account-lockout");
        CACHE_RESET_PWD = SafeCacheWrapper.getInstance("reset-password-lockout");
        CACHE_AUTHENTICATOR = SafeCacheWrapper.getInstance("authenticator-lockout");
        AccountLockout.retrieveSettings();
    }

    private static final class LockoutRecord
    implements Serializable {
        private static final long serialVersionUID = 6688303727136721146L;
        private long nbOfAttempts = 0L;
        private final long maxAllowedAttempts;
        private long endAccountLock = -1L;

        public LockoutRecord(int max) {
            this.maxAllowedAttempts = max;
        }

        public void badAttempt(int timeToLiveInSeconds) {
            ++this.nbOfAttempts;
            if (this.nbOfAttempts >= this.maxAllowedAttempts) {
                this.endAccountLock = System.currentTimeMillis() + (long)timeToLiveInSeconds * 1000L;
            }
        }

        public void lock(int timeToLiveInSeconds) {
            this.nbOfAttempts = this.maxAllowedAttempts;
            this.endAccountLock = System.currentTimeMillis() + (long)timeToLiveInSeconds * 1000L;
        }

        public boolean isLocked() {
            LOGGER.debug("nbOfAttempts: {}, this.maxAllowedAttempts: {}", (Object)this.nbOfAttempts, (Object)this.maxAllowedAttempts);
            LOGGER.debug("this.endAccountLock: {}", (Object)this.endAccountLock);
            if (this.endAccountLock == -1L) {
                return false;
            }
            if (System.currentTimeMillis() < this.endAccountLock) {
                return true;
            }
            this.endAccountLock = -1L;
            this.nbOfAttempts = 0L;
            return false;
        }
    }
}

