/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.db.model.Role;
import org.eclipse.jdt.annotation.Nullable;

public enum SubGroupRole {
    GUEST(Role.GUEST, "g", 0),
    REVIEWER(Role.REVIEWER, "r", 1),
    CONTRIBUTOR(Role.CONTRIBUTOR, "c", 2),
    MANAGER(Role.MANAGER, "e", 3),
    APPROVER(Role.APPROVER, "a", 4);

    private final Role role;
    private final String groupForGroupFlags;
    private final int priority;

    private SubGroupRole(Role role, String flags, int priority) {
        this.role = role;
        this.groupForGroupFlags = flags;
        this.priority = priority;
    }

    public String title() {
        return this.role.title();
    }

    public String attribute() {
        return this.role.attribute();
    }

    public Role role() {
        return this.role;
    }

    public String groupForGroupFlags() {
        return this.groupForGroupFlags;
    }

    public boolean isHigher(@Nullable SubGroupRole other) {
        return other == null || this.priority > other.priority;
    }

    public static @Nullable SubGroupRole forAttribute(String attribute) {
        if (Role.MODERATOR.attribute().equals(attribute)) {
            return MANAGER;
        }
        if (Role.MODERATOR_AND_APPROVER.attribute().equals(attribute)) {
            return APPROVER;
        }
        for (SubGroupRole r : SubGroupRole.values()) {
            if (!r.attribute().equals(attribute)) continue;
            return r;
        }
        return null;
    }

    public static @Nullable SubGroupRole forGroupForGroupFlags(String flags) {
        for (SubGroupRole r : SubGroupRole.values()) {
            if (!r.groupForGroupFlags().equals(flags)) continue;
            return r;
        }
        return null;
    }
}

