/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionException;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Groups;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PermissionCheck {
    protected @Nullable Group grp = null;
    protected @Nullable URI uri = null;
    protected @Nullable GroupURI guri = null;
    protected @Nullable String uriString = null;
    protected @Nullable Boolean isFolder = null;
    protected boolean checkAllowed = true;
    protected boolean authenticated = false;
    protected boolean access = false;
    protected @Nullable XLink xl = null;

    public final void getPermissions(Database db, Permissions perm) throws PermissionException {
        String grpName = null;
        if (this.grp != null) {
            grpName = this.grp.getName();
        }
        Long uriid = null;
        Long guriid = null;
        if (this.uri != null) {
            uriid = this.uri.getId();
            this.uriString = URIRule.getURIString(this.uri);
            this.isFolder = "folder".equals(this.uri.getType());
        } else if (this.guri != null) {
            guriid = this.guri.getId();
            this.uriString = GroupURIRule.getURIString(this.guri);
            this.uriString = GroupURIs.truncatePath((String)this.uriString);
            this.isFolder = Boolean.TRUE;
        }
        Long xlinkId = null;
        HashSet<String> xlinkGrpNames = null;
        if (this.xl != null) {
            xlinkId = this.xl.getId();
            xlinkGrpNames = new HashSet<String>(Groups.getGroupNames(XLinkRule.getGroups(this.xl)));
        }
        if (!(Objects.equals(grpName, perm.getGroupName()) && Objects.equals(uriid, perm.getUriId()) && Objects.equals(guriid, perm.getGroupUriId()) && Objects.equals(this.uriString, perm.getUriString()) && Objects.equals(this.isFolder, perm.getIsFolder()) && Objects.equals(xlinkId, perm.getXLinkId()) && Objects.equals(xlinkGrpNames, perm.getXLinkGroupNames()) && perm.getStatus() == Permissions.Status.SUCCESS && !perm.getAuthenticate())) {
            perm.reset();
            perm.setGroupName(grpName);
            perm.setUriId(uriid);
            perm.setGroupUriId(guriid);
            perm.setUriString(this.uriString);
            perm.setIsFolder(this.isFolder);
            perm.setXLinkId(xlinkId);
            perm.setXLinkGroupNames(xlinkGrpNames);
            perm.loadPermissions(db);
        }
        this.authenticated = perm.isLoggedIn();
    }

    public abstract boolean hasAccess(Database var1, Permissions var2);

    public @Nullable String getMessage() {
        return null;
    }
}

