/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.performance;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public final class PerformanceUtils {
    private static final String PERFORMANCE_ATTRIBUTE = "com.pageseeder.performance";
    private static final String START_TIME_ATTRIBUTE = "com.pageseeder.performance.starttime";
    private static final String DATA_PROCESS_NAME_ATTRIBUTE = "com.pageseeder.performance.dataprocessname";

    private PerformanceUtils() {
    }

    public static Map<String, Long> getPerformanceTimes(HttpServletRequest req) {
        PerformanceUtils.checkHasRequest(req);
        HashMap times = (HashMap)req.getAttribute(PERFORMANCE_ATTRIBUTE);
        if (times == null) {
            times = new HashMap();
            req.setAttribute(PERFORMANCE_ATTRIBUTE, times);
        }
        return times;
    }

    public static void setPerformanceTime(String id, long time, HttpServletRequest req) {
        Map<String, Long> performanceTimes = PerformanceUtils.getPerformanceTimes(req);
        if (performanceTimes.containsKey(id)) {
            int i = 2;
            while (performanceTimes.containsKey((String)id + i)) {
                ++i;
            }
            id = (String)id + i;
        }
        PerformanceUtils.getPerformanceTimes(req).put((String)id, time);
    }

    public static void setStartTime(HttpServletRequest req) {
        PerformanceUtils.checkHasRequest(req);
        req.setAttribute(START_TIME_ATTRIBUTE, (Object)System.currentTimeMillis());
    }

    public static @Nullable String getDataProcessName(HttpServletRequest req) {
        PerformanceUtils.checkHasRequest(req);
        return (String)req.getAttribute(DATA_PROCESS_NAME_ATTRIBUTE);
    }

    public static void setDataProcessPerformanceTime(HttpServletRequest req, String key, long time) {
        String dataProcessName = PerformanceUtils.getDataProcessName(req);
        if (dataProcessName == null) {
            return;
        }
        PerformanceUtils.setPerformanceTime(dataProcessName + " " + key, time, req);
    }

    private static void checkHasRequest(HttpServletRequest req) {
        Objects.requireNonNull(req, "Request object cannot be null");
    }
}

