/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.organization;

import com.pageseeder.base.organization.EmailConfig;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.organization.UIConfig;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler {
    private static final String ACCOUNT_HOME_ELEMENT = "account-home";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHandler.class);
    private final EmailConfig.Builder emailBuilder;
    private final UIConfig.Builder uiBuilder;
    private final SecurityConfig.Builder securityBuilder;
    private final XMLWriter accountHomeXML = new XMLStringWriter(XML.NamespaceAware.No, true);
    private final XMLWriter notificationXML = new XMLStringWriter(XML.NamespaceAware.No, true);
    private final Deque<String> elements = new ArrayDeque<String>();

    public ConfigHandler(EmailConfig.Builder emailBuilder, UIConfig.Builder uiBuilder, SecurityConfig.Builder securityBuilder) {
        this.emailBuilder = emailBuilder;
        this.uiBuilder = uiBuilder;
        this.securityBuilder = securityBuilder;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            String parent = this.elements.peek();
            if (ACCOUNT_HOME_ELEMENT.equals(localName) || this.elements.contains(ACCOUNT_HOME_ELEMENT)) {
                this.outputStartElement(this.accountHomeXML, localName, atts);
            } else if ("email".equals(parent)) {
                if ("dkim".equals(localName)) {
                    this.emailBuilder.setDKIMDomain(atts.getValue("domain"));
                    this.emailBuilder.setDKIMSelector(atts.getValue("selector"));
                    if (atts.getValue("disabled") != null) {
                        this.emailBuilder.setDKIMSelector(Boolean.valueOf(atts.getValue("disabled")));
                    }
                } else if ("emails".equals(localName)) {
                    this.emailBuilder.setEmailDomain(atts.getValue("domain"));
                } else {
                    if ("sender".equals(localName)) {
                        this.emailBuilder.setSenderName(atts.getValue("name"));
                        this.emailBuilder.setSenderEmail(atts.getValue("email"));
                    }
                    this.outputStartElement(this.notificationXML, localName, atts);
                }
            } else if ("style".equals(parent)) {
                this.outputStartElement(this.notificationXML, localName, atts);
            } else if ("ui".equals(parent)) {
                if ("style".equals(localName)) {
                    this.uiBuilder.setTheme(UIConfig.Theme.fromString(atts.getValue("theme")));
                } else if ("images".equals(localName)) {
                    this.uiBuilder.setLogoAndIcon(atts.getValue("logo-filename"), atts.getValue("icon-filename"));
                }
            } else if ("legal".equals(parent) && "document".equals(localName)) {
                this.uiBuilder.addLegalDocument(atts.getValue("name"), atts.getValue("title"), atts.getValue("agree-on"));
            } else if ("security".equals(parent)) {
                if ("login".equals(localName)) {
                    String projects;
                    String groups = atts.getValue("groups");
                    if (groups != null) {
                        String[] gs;
                        for (String g : gs = Strings.split((String)groups, (char)',')) {
                            this.securityBuilder.addLoginGroup(g);
                        }
                    }
                    if ((projects = atts.getValue("projects")) != null) {
                        String[] ps;
                        for (String p : ps = Strings.split((String)projects, (char)',')) {
                            this.securityBuilder.addLoginProject(p);
                        }
                    }
                } else if ("token".equals(localName)) {
                    this.securityBuilder.putTokenExpiration(SecurityConfig.TokenType.fromString(atts.getValue("type")), Duration.parse(atts.getValue("expiration")));
                }
            } else if ("members".equals(parent) && "email".equals(localName)) {
                this.securityBuilder.addEmailDomain(atts.getValue("domain"));
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to parse organization XML element start: {}", (Object)localName);
        }
        this.elements.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.elements.pop();
            String parent = this.elements.peek();
            if (ACCOUNT_HOME_ELEMENT.equals(localName) || this.elements.contains(ACCOUNT_HOME_ELEMENT)) {
                this.accountHomeXML.closeElement();
                if (ACCOUNT_HOME_ELEMENT.equals(localName)) {
                    this.uiBuilder.setAccountHome(this.accountHomeXML.toString());
                }
            }
            if ("email".equals(parent)) {
                if (!"dkim".equals(localName) && !"emails".equals(localName)) {
                    this.notificationXML.closeElement();
                }
            } else if ("style".equals(parent)) {
                this.notificationXML.closeElement();
            } else if (!"security".equals(parent) && !"members".equals(parent) && "organization-config".equals(parent) && "email".equals(localName)) {
                this.emailBuilder.setNotificationXML(this.notificationXML.toString());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to parse organization XML element end: {}", (Object)localName);
        }
    }

    private void outputStartElement(XMLWriter xml, String localName, Attributes atts) throws IOException {
        xml.openElement(localName, true);
        for (int i = 0; i < atts.getLength(); ++i) {
            xml.attribute(atts.getLocalName(i), atts.getValue(i));
        }
    }
}

