/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.model.Token;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.db.oauth.Scope;
import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AuthorizationCode
implements Token,
Serializable {
    private static final long serialVersionUID = 20160405L;
    private static final long TEN_MINUTES_IN_MILLIS = 600000L;
    private static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");
    private final String code;
    private final String clientId;
    private final String scope;
    private final String redirectURI;
    private final long memberId;
    private final OffsetDateTime issued;

    AuthorizationCode(String code, String clientId, String redirectURI, long memberId, String scope) {
        this.code = Objects.requireNonNull(code);
        this.clientId = Objects.requireNonNull(clientId);
        this.redirectURI = Objects.requireNonNull(redirectURI);
        this.memberId = memberId;
        this.issued = OffsetDateTime.now();
        this.scope = scope;
    }

    public String code() {
        return this.code;
    }

    @Override
    public String token() {
        return this.code;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public OffsetDateTime issuedAt() {
        return this.issued;
    }

    @Override
    public long maxAge(TimeUnit unit) {
        return unit.convert(600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String scope() {
        return this.scope;
    }

    public Set<Scope> getScopes() {
        return Scope.fromDelimitedString((String)this.scope);
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    @Override
    public long getMemberId() {
        return this.memberId;
    }

    public boolean match(String clientId, String redirectURI) {
        return this.clientId.equals(clientId) && this.redirectURI.equals(redirectURI);
    }

    @Override
    public boolean hasExpired() {
        return System.currentTimeMillis() - this.issued.toInstant().toEpochMilli() > 600000L;
    }

    public boolean expiresBefore(long time) {
        return this.issued.plus(600000L, ChronoUnit.MILLIS).toInstant().isBefore(Instant.ofEpochMilli(time));
    }

    @Override
    public boolean hasExpiredAt(OffsetDateTime time) {
        return this.issued.plus(600000L, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
    }

    @Override
    public OffsetDateTime expires() {
        return this.issued.plus(600000L, ChronoUnit.MILLIS);
    }

    public String toString() {
        return this.clientId + "/" + this.redirectURI + "/" + this.memberId + "/" + String.valueOf(this.issued);
    }

    @Deprecated(since="6.1000", forRemoval=true)
    public void toXML(XMLWriter xml) {
        this.print(new XMLOutputPrinter(xml));
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("authorization-code");
        out.field("code", this.code);
        out.field("client-id", this.clientId);
        out.field("member-id", this.memberId);
        out.field("scope", this.scope);
        out.field("redirect-uri", this.redirectURI);
        out.field("issued", this.issued.format(ISO8601_DATETIME));
        out.field("expires", this.issued.plus(600000L, ChronoUnit.MILLIS).format(ISO8601_DATETIME));
        out.endObject();
    }
}

