/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.model.Token;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AccessToken
implements Token,
Serializable {
    private static final long serialVersionUID = 20251023L;
    public static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");
    private final String token;
    private final OffsetDateTime issuedAt;
    private final OffsetDateTime expires;
    private final String clientId;
    private final long memberId;
    private final String scope;

    AccessToken(String token, OffsetDateTime issued, OffsetDateTime expires, String clientId, long memberId, String scope) {
        this.token = token;
        this.issuedAt = issued;
        this.expires = expires;
        this.clientId = clientId;
        this.memberId = memberId;
        this.scope = scope;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public long getMemberId() {
        return this.memberId;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public OffsetDateTime issuedAt() {
        return this.issuedAt;
    }

    @Override
    public long maxAge(TimeUnit unit) {
        long maxAgeMillis = this.expires.toInstant().toEpochMilli() - this.issuedAt.toInstant().toEpochMilli();
        return unit.convert(maxAgeMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public OffsetDateTime expires() {
        return this.expires;
    }

    @Override
    public boolean hasExpired() {
        return this.expires.isBefore(OffsetDateTime.now());
    }

    @Override
    public boolean hasExpiredAt(OffsetDateTime time) {
        return this.expires.isBefore(time);
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Deprecated(since="6.1000", forRemoval=true)
    public void toXML(XMLWriter xml) {
        this.print(new XMLOutputPrinter(xml));
    }

    @Override
    public void print(OutputPrinter out) {
        this.print(out, false);
    }

    public void print(OutputPrinter out, boolean masked) {
        out.startObject("access-token", OutputPrinter.ObjectOption.XML_EMPTY);
        int length = this.token.length();
        String tokenDisplay = masked && length > 8 ? this.token.substring(0, 4) + "****" + this.token.substring(length - 4, length) : this.token;
        out.field("token", tokenDisplay);
        out.field("client-id", this.clientId);
        out.field("member-id", Long.toString(this.memberId));
        out.field("scope", this.scope);
        out.field("lifetime", Long.toString(this.maxAge(TimeUnit.SECONDS)));
        out.field("issued", this.issuedAt.format(ISO8601_DATETIME));
        out.field("expires", this.expires.format(ISO8601_DATETIME));
        out.field("expired", Boolean.toString(this.hasExpired()));
        out.endObject();
    }
}

