/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.core;

import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.db.oauth.Scope;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public abstract class OAuthRequest {
    private final HttpServletRequest request;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HTTP.BasicCredentials credentials;

    protected OAuthRequest(HttpServletRequest request) {
        this.request = request;
        this.credentials = HTTP.getBasicCredentials((String)request.getHeader("Authorization"));
    }

    public @Nullable String getParameter(OAuthParameter parameter) {
        return this.request.getParameter(parameter.name());
    }

    public String getAuthorizationHeader() {
        return this.request.getHeader(HTTP.Header.Authorization.toString());
    }

    public @Nullable String getAuthScheme() {
        String header = this.getAuthorizationHeader();
        return HTTP.getAuthScheme((String)header);
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Set<Scope> getScopes() {
        return Scope.fromDelimitedString((String)this.getParameter(OAuthParameter.scope));
    }

    public @Nullable String getRedirectURI() {
        return this.getParameter(OAuthParameter.redirect_uri);
    }

    public @Nullable String getClientId() {
        if (this.credentials != null) {
            return this.credentials.username();
        }
        return this.getParameter(OAuthParameter.client_id);
    }

    public @Nullable String getClientSecret() {
        if (this.credentials != null) {
            return this.credentials.password();
        }
        return this.getParameter(OAuthParameter.client_secret);
    }
}

