/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.sms;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.mfa.sms.InvalidPhoneNumber;
import com.pageseeder.db.model.Authenticator;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;

public final class PhoneNumber
implements Serializable {
    private final String number;

    private PhoneNumber(String number) {
        this.number = number;
    }

    public static PhoneNumber of(@Nullable String number) throws InvalidPhoneNumber {
        try {
            if (number == null) {
                throw new InvalidPhoneNumber("null");
            }
            PhoneNumberUtil util = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber x = util.parse((CharSequence)number, Phonenumber.PhoneNumber.CountryCodeSource.UNSPECIFIED.name());
            String e164 = util.format(x, PhoneNumberUtil.PhoneNumberFormat.E164);
            return new PhoneNumber(e164);
        }
        catch (NumberParseException ex) {
            throw new InvalidPhoneNumber(ex.getMessage());
        }
    }

    public static PhoneNumber fromAuthenticator(Authenticator authenticator) throws InvalidPhoneNumber {
        return PhoneNumber.of(ConfidentialData.getData(authenticator));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber that = (PhoneNumber)o;
        return this.number.equals(that.number);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public String toString() {
        return this.number;
    }
}

