/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail.dkim;

import com.pageseeder.base.mail.dkim.DKIMSigner;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.eclipse.angus.mail.smtp.SMTPMessage;
import org.eclipse.angus.mail.util.LineOutputStream;
import org.eclipse.jdt.annotation.Nullable;

public class SMTPDKIMMessage
extends SMTPMessage {
    private final @Nullable DKIMSigner signer;
    private @Nullable String encodedBody;

    public SMTPDKIMMessage(Session session, @Nullable DKIMSigner signer) {
        super(session);
        this.signer = signer;
    }

    public SMTPDKIMMessage(MimeMessage message, @Nullable DKIMSigner signer) throws MessagingException {
        super(message);
        this.signer = signer;
    }

    public SMTPDKIMMessage(Session session, InputStream is, @Nullable DKIMSigner signer) throws MessagingException {
        super(session, is);
        this.signer = signer;
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        String signatureHeaderLine;
        if (this.signer == null) {
            super.writeTo(os, ignoreList);
            return;
        }
        ByteArrayOutputStream osBody = new ByteArrayOutputStream();
        if (!this.saved) {
            this.saveChanges();
        }
        if (this.modified) {
            OutputStream osEncoding = MimeUtility.encode((OutputStream)osBody, (String)this.getEncoding());
            this.getDataHandler().writeTo(osEncoding);
            osEncoding.flush();
        } else {
            if (this.content == null) {
                int len;
                InputStream is = this.getContentStream();
                byte[] buf = new byte[8192];
                while ((len = is.read(buf)) > 0) {
                    osBody.write(buf, 0, len);
                }
                is.close();
                buf = null;
            } else {
                osBody.write(this.content);
            }
            osBody.flush();
        }
        this.encodedBody = osBody.toString();
        try {
            signatureHeaderLine = this.signer.sign(this);
        }
        catch (Exception e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        LineOutputStream los = new LineOutputStream(os);
        los.writeln(signatureHeaderLine);
        Enumeration hdrLines = this.getNonMatchingHeaderLines(ignoreList);
        while (hdrLines.hasMoreElements()) {
            los.writeln((String)hdrLines.nextElement());
        }
        los.writeln();
        os.write(osBody.toByteArray());
        os.flush();
    }

    public @Nullable String getEncodedBody() {
        return this.encodedBody;
    }

    public void setEncodedBody(String encodedBody) {
        this.encodedBody = encodedBody;
    }

    public void setAllow8bitMIME(boolean allow) {
    }
}

