/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.EmailSender;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.model.Group;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

public final class NotificationSenderThread
extends ProcessThread {
    private @Nullable EmailSender sender = null;

    private NotificationSenderThread(String username, String name, @Nullable Group group) {
        super(username, name, group);
    }

    public void setSender(EmailSender sender) {
        this.sender = sender.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        Database db = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.fail("Fail to open database: " + ex.getMessage());
            return;
        }
        String finalMessage = "Email successfully sent";
        try {
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Sending email to " + this.sender.getRecipientTos().size() + " recipients");
            this.sender.sendImmediately(db);
            Collection<String> unsent = this.sender.getUnsentAddresses();
            if (!unsent.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Failed to send notification to ").append(unsent.size()).append(" member");
                msg.append(unsent.size() == 1 ? "" : "s").append(": ");
                boolean first = true;
                for (String email : unsent) {
                    if (!first) {
                        msg.append(", ");
                    }
                    msg.append(email);
                    first = false;
                }
                this.updateStatus(ProcessStage.Status.WARNING, msg.toString());
                finalMessage = "Email sent with warnings";
            }
        }
        catch (EmailException ex) {
            this.fail("Fail to send message: " + ex.getMessage());
        }
        finally {
            this.complete(finalMessage);
            ProcessManager.getInstance().clearIfFinished(this.getThreadID());
            db.close();
            db = null;
        }
    }

    public static NotificationSenderThread newInstance(String username, String name, @Nullable Group group) {
        return new NotificationSenderThread(username, name, group);
    }
}

