/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.logback.MailEvent;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public class MailLogger
extends XLoggerAdaptor {
    private static final MailLogger SINGLETON = new MailLogger();
    private static final int MAX_ADDRESSES = 10;
    private static final Map<String, Integer> bouncesTo = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> bouncesFrom = new ConcurrentHashMap<String, Integer>();
    private static final AtomicInteger totalBounces = new AtomicInteger(0);

    private MailLogger() {
        super("Mail");
    }

    public static MailLogger getInstance() {
        return SINGLETON;
    }

    public static void logInfo(@Nullable MailEvent event) {
        if (event == null) {
            return;
        }
        SINGLETON.info(event);
    }

    public static void logError(@Nullable MailEvent event) {
        if (event == null) {
            return;
        }
        SINGLETON.error(event);
    }

    public static void logWarn(@Nullable MailEvent event) {
        if (event == null) {
            return;
        }
        SINGLETON.warn(event);
    }

    public static void bounce(String from, String to) {
        if (Strings.isEmpty((String)from)) {
            return;
        }
        totalBounces.getAndAdd(1);
        Integer count = bouncesTo.get(to);
        if (count != null) {
            bouncesTo.put(to, count + 1);
        } else if (bouncesTo.size() <= 110) {
            bouncesTo.put(to, 1);
        }
        count = bouncesFrom.get(from);
        if (count != null) {
            bouncesFrom.put(from, count + 1);
        } else if (bouncesFrom.size() <= 110) {
            bouncesFrom.put(from, 1);
        }
    }

    public static void logBounces(XMLWriter xml) throws IOException {
        MailLogger.logBounces(bouncesTo, "to", xml);
        MailLogger.logBounces(bouncesFrom, "from", xml);
    }

    private static void logBounces(Map<String, Integer> bounces, String type, XMLWriter xml) throws IOException {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(bounces.entrySet());
        int s = list.size();
        if (s > 0) {
            xml.openElement("bounces");
            xml.attribute("type", type);
            xml.attribute("total", totalBounces.get());
            list.sort(Map.Entry.comparingByValue());
            for (int i = s - 1; i >= 0 && i >= s - 10; --i) {
                Map.Entry e = (Map.Entry)list.get(i);
                xml.openElement("bounce");
                xml.attribute("address", (String)e.getKey());
                xml.attribute("count", ((Integer)e.getValue()).intValue());
                xml.closeElement();
            }
            xml.closeElement();
        }
    }
}

