/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.GeneralEvent;
import com.pageseeder.base.logback.GeneralLogs;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.common.util.ISO8601;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GeneralLogViewer
implements XMLWritable {
    private final File directory;
    private @Nullable Date date = null;
    private int page = 1;
    private @Nullable List<GeneralEvent> events = null;
    private boolean hasMore = false;
    private static final int DEFAULT_PAGE_SIZE = 1000;

    public GeneralLogViewer() {
        this.directory = GeneralLogs.getFolder();
    }

    public GeneralLogViewer(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public @Nullable Date getDate() {
        return this.date;
    }

    public void build() throws IOException {
        XLoggerAdaptor.ensureRollover();
        List<File> logs = GeneralLogs.getFiles(this.directory, this.date);
        ArrayList<GeneralEvent> events = new ArrayList<GeneralEvent>();
        for (File log : logs) {
            this.load(log, events);
            if (events.size() != 1000) continue;
            break;
        }
        this.events = events;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("events", true);
        xml.attribute("page", this.page);
        xml.attribute("date", ISO8601.CALENDAR_DATE.format(this.date.getTime()));
        if (this.hasMore) {
            xml.attribute("more", "true");
        }
        for (GeneralEvent e : this.events) {
            e.toXML(xml);
        }
        xml.closeElement();
    }

    private void load(File log, List<GeneralEvent> events) throws IOException {
        GeneralEvent previous = null;
        int count = 0;
        int from = (this.page - 1) * 1000;
        int to = this.page * 1000 + 1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(log), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (GeneralEvent.isProbablyEvent(line)) {
                    ++count;
                }
                if (count > from && count < to) {
                    GeneralEvent e = GeneralEvent.parse(line);
                    if (e != null) {
                        previous = e;
                        events.add(e);
                    } else if (previous != null) {
                        previous.appendToThrowable(line);
                    }
                }
                if (count == to) {
                    this.hasMore = true;
                } else if (count <= to) continue;
                break;
            }
        }
    }
}

