/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.GeneralEvent;
import com.pageseeder.base.logback.GeneralLogs;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.common.util.ISO8601;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GeneralLogTracker
implements XMLWritable {
    private final File directory;
    private Date date = null;
    private Queue<GeneralEvent> events = null;
    private static final int BEFORE = 50;
    private static final int AFTER = 50;

    public GeneralLogTracker() {
        this.directory = GeneralLogs.getFolder();
    }

    public GeneralLogTracker(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void build() throws IOException {
        XLoggerAdaptor.ensureRollover();
        List<File> logs = GeneralLogs.getFiles(this.directory, this.date);
        LinkedList<GeneralEvent> events = new LinkedList<GeneralEvent>();
        for (File log : logs) {
            GeneralLogTracker.load(log, this.date, events);
            if (events.size() <= 100) continue;
            break;
        }
        this.events = events;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("events", true);
        xml.attribute("target", ISO8601.DATETIME.format(this.date.getTime()));
        for (GeneralEvent e : this.events) {
            e.toXML(xml);
        }
        xml.closeElement();
    }

    private static void load(File log, Date date, Queue<GeneralEvent> events) throws IOException {
        String target = ISO8601.DATETIME.format(date.getTime()).substring(0, 19);
        GeneralEvent previous = null;
        int queueSize = 100;
        int count = 0;
        int upto = -1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(log), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                GeneralEvent e;
                if (GeneralEvent.isProbablyEvent(line)) {
                    if (upto < 0) {
                        String datetime = line.substring(0, 19);
                        if (datetime.compareTo(target) > 0) {
                            upto = count + 50 - 1;
                        }
                    } else if (count > upto) {
                        break;
                    }
                    ++count;
                }
                if ((e = GeneralEvent.parse(line)) != null) {
                    previous = e;
                    events.add(e);
                    if (events.size() <= 100) continue;
                    events.remove();
                    continue;
                }
                if (previous == null) continue;
                previous.appendToThrowable(line);
            }
        }
    }
}

