/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.label;

public enum LabelType {
    COMMENT{

        @Override
        protected boolean forType(String type) {
            if ("Comment".equals(type)) {
                return true;
            }
            if ("Archive".equals(type)) {
                return true;
            }
            if ("File Attachment".equals(type)) {
                return true;
            }
            if (type.startsWith("pdf-")) {
                return true;
            }
            return type.startsWith("archive-");
        }
    }
    ,
    WORKFLOW{

        @Override
        protected boolean forType(String type) {
            return "Workflow".equals(type);
        }
    }
    ,
    FRAGMENT{

        @Override
        protected boolean forType(String type) {
            if ("Documentation".equals(type)) {
                return true;
            }
            if ("Documentation-Deleted".equals(type)) {
                return true;
            }
            if ("Documentation-Hidden".equals(type)) {
                return true;
            }
            if ("Documentation-Original".equals(type)) {
                return true;
            }
            return "Description".equals(type);
        }
    }
    ,
    EDIT_NOTE{

        @Override
        protected boolean forType(String type) {
            return "Documentation-Note".equals(type);
        }
    }
    ,
    VERSION{

        @Override
        protected boolean forType(String type) {
            return "Documentation-Release".equals(type) || "Documentation-Version".equals(type);
        }
    }
    ,
    CREATION{

        @Override
        protected boolean forType(String type) {
            return "File Creation".equals(type);
        }
    }
    ,
    UPLOAD{

        @Override
        protected boolean forType(String type) {
            return "File Upload".equals(type) || "File Notification".equals(type);
        }
    }
    ,
    DOCUMENT{

        @Override
        protected boolean forType(String type) {
            return "uri-properties".equals(type);
        }
    }
    ,
    URL{

        @Override
        protected boolean forType(String type) {
            return "uri-properties".equals(type);
        }
    }
    ,
    XREF{

        @Override
        protected boolean forType(String type) {
            return "XRef".equals(type) || type.startsWith("XRef-");
        }
    }
    ,
    LINK{

        @Override
        protected boolean forType(String type) {
            return false;
        }
    }
    ,
    IMAGE{

        @Override
        protected boolean forType(String type) {
            return false;
        }
    }
    ,
    CONTENT_INLINE{

        @Override
        protected boolean forType(String type) {
            return false;
        }
    }
    ,
    CONTENT_BLOCK{

        @Override
        protected boolean forType(String type) {
            return false;
        }
    }
    ,
    GENERAL{

        @Override
        protected boolean forType(String type) {
            return true;
        }
    };


    protected abstract boolean forType(String var1);

    public String key() {
        return this.name().toLowerCase().replace('_', '-');
    }
}

