/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.label;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class LabelInfo
implements XMLWritable,
UniversallyPrintable {
    private final String name;
    private final @Nullable String description;
    private final @Nullable String fragmenttypes;
    private @Nullable String color;

    public LabelInfo(String name, @Nullable String description) {
        this.name = Objects.requireNonNull(name, "A label must have a name");
        this.description = description;
        this.fragmenttypes = null;
    }

    public LabelInfo(String name, String description, @Nullable String fragmenttypes) {
        this.name = Objects.requireNonNull(name, "A label must have a name");
        this.description = description;
        this.fragmenttypes = fragmenttypes;
    }

    public void setColor(@Nullable String color) {
        this.color = color;
    }

    public @Nullable String getColor() {
        return this.color;
    }

    public String name() {
        return this.name;
    }

    public @Nullable String description() {
        return this.description;
    }

    public @Nullable String fragmenttypes() {
        return this.fragmenttypes;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelInfo)) {
            return false;
        }
        LabelInfo i = (LabelInfo)o;
        return i.name.equals(this.name);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("label");
        xml.attribute("name", this.name);
        if (this.description != null) {
            xml.attribute("description", this.description);
        }
        if (this.fragmenttypes != null) {
            xml.attribute("fragmenttypes", this.fragmenttypes);
        }
        if (this.color != null) {
            xml.attribute("color", this.color);
        }
        xml.closeElement();
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("label");
        out.field("name", this.name);
        if (this.description != null) {
            out.field("description", this.description);
        }
        if (this.fragmenttypes != null) {
            out.field("fragmenttypes", this.fragmenttypes);
        }
        if (this.color != null) {
            out.field("color", this.color);
        }
        out.endObject();
    }
}

