/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.inspect;

import com.pageseeder.base.inspect.FileInspector;
import com.pageseeder.common.util.ISO8601;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.eclipse.jdt.annotation.Nullable;

public class PDFInspector
implements FileInspector {
    private static final String META_ATTRIBUTE_PREFIX = "meta.";
    private static final Collection<String> COMMON_FIELDS = new ArrayList<String>();

    @Override
    public Map<String, String> inspect(File file) throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        try (PDDocument doc = PDDocument.load((File)file);){
            PDDocumentInformation docinfo = doc.getDocumentInformation();
            if (docinfo != null) {
                this.addAttribute(attributes, "docinfo-author", docinfo.getAuthor());
                this.addAttribute(attributes, "docinfo-creationdate", docinfo.getCreationDate());
                this.addAttribute(attributes, "docinfo-creator", docinfo.getCreator());
                this.addAttribute(attributes, "docinfo-keywords", docinfo.getKeywords());
                this.addAttribute(attributes, "docinfo-moddate", docinfo.getModificationDate());
                this.addAttribute(attributes, "docinfo-subject", docinfo.getSubject());
                this.addAttribute(attributes, "docinfo-title", docinfo.getTitle());
                for (String field : docinfo.getMetadataKeys()) {
                    if (COMMON_FIELDS.contains(field.toLowerCase())) continue;
                    this.addAttribute(attributes, "docinfo-" + field, docinfo.getCustomMetadataValue(field));
                }
            }
        }
        return attributes;
    }

    private void addAttribute(Map<String, String> attributes, @Nullable String name, @Nullable String value) {
        if (name != null && value != null && !value.trim().isEmpty()) {
            attributes.put(META_ATTRIBUTE_PREFIX + name, value.trim());
        }
    }

    private void addAttribute(Map<String, String> attributes, @Nullable String name, @Nullable Calendar value) {
        if (name != null && value != null) {
            attributes.put(META_ATTRIBUTE_PREFIX + name, ISO8601.DATETIME.format(value.getTime().getTime()));
        }
    }

    static {
        COMMON_FIELDS.add("author");
        COMMON_FIELDS.add("creationdate");
        COMMON_FIELDS.add("creator");
        COMMON_FIELDS.add("keywords");
        COMMON_FIELDS.add("moddate");
        COMMON_FIELDS.add("subject");
        COMMON_FIELDS.add("title");
    }
}

