/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.diff.DiffXMLOutput;
import com.pageseeder.base.diff.OriginTracker;
import com.pageseeder.base.diff.TrackedContent;
import com.pageseeder.base.diff.TrackedSequence;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.URICompareException;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.psml.diff.PSMLDiffer;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLCompareHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLCompareHandler.class);
    private int maxEvents;
    private static final int DEFAULT_MAX_EVENTS = 4000000;
    public static final String COMPARETO_ELEMENT = "compareto";
    public static final String COMPARE_ELEMENT = "compare";
    private final Database database;
    private final URI uri;
    private final Long groupid;
    private final DiffType runDiffX;
    private final boolean autoNumbered;
    private final String fragment;
    private @Nullable XMLWriter output = null;
    private final Map<String, Fragment> oldFragments = new HashMap<String, Fragment>();
    private final Map<String, Fragment> newFragments = new HashMap<String, Fragment>();
    private final Map<String, Section> oldSections = new HashMap<String, Section>();
    private final Deque<Section> newSections = new ArrayDeque<Section>();
    private final Map<String, String> newLocators = new HashMap<String, String>();
    private final Map<String, TrackedSequence<String>> trackedFragments = new HashMap<String, TrackedSequence<String>>();
    private @Nullable Map<String, List<XLink>> notes = null;
    private Map<String, String> originalNotes = new HashMap<String, String>();
    private int newTocs = 0;
    private boolean compareOriginal = false;
    private @Nullable XLink compareVersion = null;
    private @Nullable XLink currentVersion = null;
    private @Nullable String metadataEditid = null;
    private @Nullable String metadataModified = null;
    private @Nullable String oldScheme = null;
    private @Nullable String oldHost = null;
    private @Nullable String oldPort = null;
    private @Nullable String oldPath = null;
    private @Nullable String oldDecodedPath = null;
    private @Nullable String oldTitle = null;
    private @Nullable String oldDocID = null;
    private @Nullable String oldLabels = null;
    private @Nullable String oldDescription = null;
    private @Nullable StringBuilder text = null;
    private boolean inURI = false;
    private @Nullable String currentLocatorFragment = null;
    private @Nullable String currentContentFragment = null;
    private @Nullable Section currentSection = null;
    private @Nullable XMLWriter xml = null;
    private boolean parseOldContent;
    private XMLWriter structureXML = new XMLStringWriter(XML.NamespaceAware.No);
    private int inMediaFragment = 0;
    private int tocNumber = 0;
    private String previousSectionId = "default";

    public PSMLCompareHandler(URI u, Long gid, DiffType diffx, Database db, boolean autonumbered, String frag) {
        this.uri = u;
        this.groupid = gid;
        this.database = db;
        this.runDiffX = diffx;
        this.autoNumbered = autonumbered;
        this.fragment = frag;
        this.maxEvents = GlobalSettings.getInt((String)"diffXMaxEvents", (int)4000000);
    }

    public void parseOldContent(InputStream content, Long compareId) throws URIException {
        this.parseOldContent = true;
        if (compareId == 0L) {
            this.compareOriginal = true;
        } else if (compareId != null) {
            try {
                this.compareVersion = DatabaseQuery.getXLinkById((Database)this.database, (Long)compareId);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to parse compare version from DB", (Throwable)ex);
                throw new URIException("Failed to load compare version from DB", ex);
            }
        }
        try {
            XMLHelpers.parse(content, this);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse old content for comparison", (Throwable)ex);
            throw new URIException("Failed to parse old content for comparison", ex);
        }
    }

    public void parseNewContent(InputStream content, @Nullable Long newId, XMLWriter psml) throws URIException {
        this.parseOldContent = false;
        this.output = psml;
        this.tocNumber = 0;
        if (newId != null && newId != 0L) {
            try {
                this.currentVersion = DatabaseQuery.getXLinkById((Database)this.database, (Long)newId);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to parse current version from DB", (Throwable)ex);
                throw new URIException("Failed to load current version from DB", ex);
            }
        }
        try {
            XMLHelpers.parse(content, this);
        }
        catch (FoundationException ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("Failed to run diffX")) {
                throw new URICompareException((this.runDiffX != DiffType.SPLIT ? "Try side-by-side comparison instead: " : "") + ex.getMessage());
            }
            LOGGER.error("Failed to parse new content for comparison", (Throwable)ex);
            throw new URIException("Failed to parse new content for comparison", ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.parseOldContent) {
            this.startStructureElement(localName, attributes);
            this.startOldElement(uri, localName, qName, attributes);
        } else {
            this.startNewElement(uri, localName, qName, attributes);
        }
        if ("media-fragment".equals(localName)) {
            ++this.inMediaFragment;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("media-fragment".equals(localName)) {
            --this.inMediaFragment;
        }
        if (this.parseOldContent) {
            this.endStructureElement(localName);
            this.endOldElement(uri, localName, qName);
        } else {
            this.endNewElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(ch, start, length);
        }
        if (this.xml != null) {
            try {
                this.xml.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write text", ex);
            }
        }
    }

    public void startStructureElement(String localName, Attributes atts) throws SAXException {
        String id;
        String fragid;
        if (this.inMediaFragment != 0) {
            return;
        }
        boolean isFragment = PSMLContentUtils.isFragmentElement(localName);
        if (isFragment && (fragid = atts.getValue("id")) != null && (id = atts.getValue("id")) != null) {
            try {
                this.structureXML.openElement("fragment-ref");
                this.structureXML.attribute("id", id);
                this.structureXML.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write structure fragment " + id + ": " + ex.getMessage(), ex);
            }
        }
        if ("section".equals(localName) || "toc".equals(localName)) {
            try {
                String title;
                this.structureXML.openElement(localName + "-ref");
                String id2 = atts.getValue("id");
                if (id2 != null) {
                    this.structureXML.attribute("id", id2);
                }
                if ((title = atts.getValue("title")) != null) {
                    this.structureXML.attribute("title", title);
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open structure element " + localName + ": " + ex.getMessage(), ex);
            }
        }
        if ("title".equals(localName)) {
            this.text = new StringBuilder();
        }
    }

    public void endStructureElement(String localName) throws SAXException {
        if (this.inMediaFragment != 0) {
            return;
        }
        try {
            if ("section".equals(localName) || "toc".equals(localName)) {
                this.structureXML.closeElement();
            }
            if ("title".equals(localName)) {
                this.structureXML.element("title", this.text.toString());
                this.text = null;
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close structure element " + localName + ": " + ex.getMessage(), ex);
        }
    }

    public void startNewElement(String ns, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.inMediaFragment == 0) {
            if ("document".equals(localName)) {
                this.openElement(this.output, localName, attributes);
            } else if ("documentinfo".equals(localName)) {
                this.xml = this.output;
            } else if ("locator".equals(localName)) {
                this.currentLocatorFragment = attributes.getValue("fragment");
                Fragment f = new Fragment();
                f.modified = attributes.getValue("modified");
                this.newFragments.put(this.currentLocatorFragment, f);
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else if ("notes".equals(localName) && this.currentLocatorFragment != null) {
                this.newLocators.put(this.currentLocatorFragment, this.xml.toString());
                this.xml = null;
            } else if ("section".equals(localName)) {
                XMLStringWriter section = new XMLStringWriter(XML.NamespaceAware.No);
                this.openElement((XMLWriter)section, localName, attributes);
                this.newSections.push(new Section(attributes.getValue("id"), section.toString()));
            } else if ("title".equals(localName)) {
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else if ("toc".equals(localName)) {
                if (this.newSections.isEmpty()) {
                    ++this.newTocs;
                } else {
                    Section s = this.newSections.peek();
                    ++s.tocsAfter;
                }
            } else if (PSMLContentUtils.isFragmentElement(localName)) {
                String id = attributes.getValue("id");
                if (!this.newSections.isEmpty()) {
                    Section s = this.newSections.peek();
                    s.fragments.add(id);
                }
                this.newFragments.computeIfAbsent(id, key -> new Fragment());
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else if ("properties".equals(localName) && this.currentContentFragment == null) {
                this.currentContentFragment = "default";
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else if ("metadata".equals(localName)) {
                this.metadataEditid = attributes.getValue("editid");
                this.metadataModified = attributes.getValue("modified");
            }
        }
        if (this.xml != null) {
            this.openElement(this.xml, localName, attributes);
        }
    }

    public void endNewElement(String ns, String localName, String qName) throws SAXException {
        if (this.inMediaFragment != 0) {
            try {
                this.xml.closeElement();
                return;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write end tag for " + localName, ex);
            }
        }
        if ("documentinfo".equals(localName)) {
            try {
                this.xml.openElement(COMPARETO_ELEMENT);
                if (this.compareOriginal) {
                    this.xml.attribute("version", "original");
                    if (this.uri.getDateCreated() != null) {
                        this.xml.attribute("date", ISO8601.format((long)this.uri.getDateCreated().getTime(), (ISO8601)ISO8601.DATETIME));
                    }
                } else if (this.compareVersion != null) {
                    this.xml.attribute("version", (String)(XLinks.isVersion((XLink)this.compareVersion) && this.compareVersion.getContentTitle() != null ? this.compareVersion.getContentTitle() : "event:" + this.compareVersion.getId()));
                    this.xml.attribute("versionid", this.compareVersion.getId().toString());
                    if (this.compareVersion.getDate() != null) {
                        this.xml.attribute("date", ISO8601.format((long)this.compareVersion.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
                    }
                } else {
                    this.xml.attribute("version", "current");
                    if (this.uri.getLastModified() != null) {
                        this.xml.attribute("date", ISO8601.format((long)this.uri.getLastModified().getTime(), (ISO8601)ISO8601.DATETIME));
                    }
                }
                if (!Strings.isEmpty((String)this.oldScheme)) {
                    this.xml.attribute("scheme", this.oldScheme);
                }
                if (!Strings.isEmpty((String)this.oldHost)) {
                    this.xml.attribute("host", this.oldHost);
                }
                if (!Strings.isEmpty((String)this.oldPort)) {
                    this.xml.attribute("port", this.oldPort);
                }
                if (!Strings.isEmpty((String)this.oldPath)) {
                    this.xml.attribute("path", this.oldPath);
                }
                if (!Strings.isEmpty((String)this.oldDecodedPath)) {
                    this.xml.attribute("decodedpath", this.oldDecodedPath);
                }
                if (!Strings.isEmpty((String)this.oldDocID)) {
                    this.xml.attribute("docid", this.oldDocID);
                }
                if (!Strings.isEmpty((String)this.oldTitle)) {
                    this.xml.element("title", this.oldTitle);
                }
                if (!Strings.isEmpty((String)this.oldDescription)) {
                    this.xml.element("description", this.oldDescription);
                }
                if (!Strings.isEmpty((String)this.oldLabels)) {
                    this.xml.element("labels", this.oldLabels);
                }
                this.xml.openElement("metadata");
                Fragment metadata = this.oldFragments.get("default");
                if (metadata != null) {
                    this.xml.writeXML(metadata.content);
                }
                this.xml.closeElement();
                this.xml.openElement("structure");
                this.xml.writeXML(this.structureXML.toString());
                this.xml.closeElement();
                this.xml.closeElement();
                this.xml.closeElement();
                this.xml = null;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write compareto tag", ex);
            }
        }
        if ("locator".equals(localName) && this.currentLocatorFragment != null) {
            this.addNotes(this.currentLocatorFragment, this.xml);
            Object existing = this.newLocators.get(this.currentLocatorFragment);
            if (existing != null && !((String)existing).endsWith(">")) {
                existing = (String)existing + ">";
            }
            this.newLocators.put(this.currentLocatorFragment, (String)(existing == null ? "" : existing) + String.valueOf(this.xml));
            this.currentLocatorFragment = null;
            this.xml = null;
        } else if ("notes".equals(localName) && this.currentLocatorFragment != null) {
            this.xml = new XMLStringWriter(XML.NamespaceAware.No);
        } else if ("title".equals(localName) && !this.newSections.isEmpty()) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close title tag", ex);
            }
            Section s = this.newSections.peek();
            s.addTitle(this.xml.toString());
            this.xml = null;
        } else if (PSMLContentUtils.isFragmentElement(localName)) {
            Fragment fragment;
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close fragment tag", ex);
            }
            String currentFragment = this.fragment;
            if (!this.newSections.isEmpty()) {
                Section currentSection = this.newSections.peek();
                String string = currentFragment = currentSection.fragments.isEmpty() ? null : currentSection.fragments.peek();
            }
            if (currentFragment != null && (fragment = this.newFragments.get(currentFragment)) != null) {
                fragment.content = this.xml.toString();
            }
            this.xml = null;
        } else if ("properties".equals(localName) && "default".equals(this.currentContentFragment)) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close fragment tag", ex);
            }
            Fragment f = new Fragment();
            this.newFragments.put(this.currentContentFragment, f);
            f.content = this.xml.toString();
            this.currentContentFragment = null;
            this.xml = null;
        } else if ("metadata".equals(localName) && this.newFragments.get("default") == null) {
            Fragment f = new Fragment();
            f.content = "<properties/>";
            this.newFragments.put("default", f);
        } else {
            if (this.fragment != null && "document-fragment".equals(localName)) {
                try {
                    this.output.openElement("document-fragment");
                    String start = this.newLocators.get(this.fragment);
                    this.output.writeXML(start);
                    if (!start.endsWith(">")) {
                        this.output.writeXML(">");
                    }
                    Fragment newfrag = this.newFragments.get(this.fragment);
                    Fragment oldfrag = this.oldFragments.get(this.fragment);
                    this.addCompare(newfrag, oldfrag, this.fragment);
                    this.output.writeXML("</locator>");
                    if (!this.writeTrackedChanges(this.fragment)) {
                        this.output.writeXML(newfrag.content);
                    }
                    this.output.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to write document-fragment tag", ex);
                }
            }
            if ("document".equals(localName)) {
                this.outputDocument();
            } else if (this.xml != null) {
                try {
                    this.xml.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to close tag " + localName, ex);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void outputDocument() throws SAXException {
        try {
            void var2_7;
            this.output.openElement("fragmentinfo");
            for (Map.Entry<String, String> entry : this.newLocators.entrySet()) {
                Section s;
                String fragment = entry.getKey();
                String start = entry.getValue();
                this.output.writeXML(start);
                if (!start.endsWith(">")) {
                    this.output.writeXML(">");
                }
                Fragment newfrag = this.newFragments.get(fragment);
                Fragment oldfrag = this.oldFragments.get(fragment);
                if (newfrag.content == null && oldfrag != null && (s = oldfrag.section) != null) {
                    s.deletedFragments.add(fragment);
                }
                this.addCompare(newfrag, oldfrag, fragment);
                this.output.writeXML("</locator>");
            }
            for (Map.Entry<String, Object> entry : this.oldFragments.entrySet()) {
                String fragId = entry.getKey();
                if (this.newLocators.containsKey(fragId)) continue;
                this.output.openElement("locator");
                this.output.attribute("fragment", fragId);
                Fragment oldFrag = (Fragment)entry.getValue();
                Fragment newFrag = this.newFragments.get(fragId);
                this.addCompare(newFrag, oldFrag, fragId);
                this.output.closeElement();
                Section s = oldFrag.section;
                if (s == null || newFrag != null) continue;
                s.deletedFragments.add(fragId);
            }
            this.output.closeElement();
            this.output.openElement("metadata");
            Fragment metadata = this.newFragments.get("default");
            if (metadata != null) {
                if (this.metadataEditid != null) {
                    this.output.attribute("editid", this.metadataEditid);
                }
                if (this.metadataModified != null) {
                    this.output.attribute("modified", this.metadataModified);
                }
                if (!this.writeTrackedChanges("default")) {
                    this.output.writeXML(metadata.content);
                }
            }
            this.output.closeElement();
            this.outputDeletedSections("default");
            boolean bl = false;
            while (var2_7 < this.newTocs) {
                this.output.emptyElement("toc");
                ++this.tocNumber;
                this.outputDeletedSections("toc:" + this.tocNumber);
                ++var2_7;
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write fragmentinfo tag", ex);
        }
        Iterator<Section> new_sec_iter = this.newSections.descendingIterator();
        while (new_sec_iter.hasNext()) {
            Section section = new_sec_iter.next();
            Map<String, String> deletedlocation = this.findDeletedFragmentLocation(section);
            try {
                Section oldsection;
                this.output.writeXML(section.startTag);
                if (!section.startTag.endsWith(">")) {
                    this.output.writeXML(">");
                }
                if ((oldsection = this.oldSections.get(section.id)) != null) {
                    for (String deleted : oldsection.deletedFragments) {
                        if (deletedlocation.containsValue(deleted)) continue;
                        while (deleted != null) {
                            this.outputDeletedFragment(deleted);
                            deleted = deletedlocation.get(deleted);
                        }
                    }
                }
                for (String frag : section.fragments) {
                    Fragment f = this.newFragments.get(frag);
                    if (f != null && !this.writeTrackedChanges(frag)) {
                        this.output.writeXML(f.content);
                    }
                    String deleted = deletedlocation.get(frag);
                    while (deleted != null) {
                        this.outputDeletedFragment(deleted);
                        deleted = deletedlocation.get(deleted);
                    }
                }
                this.output.writeXML("</section>");
                this.outputDeletedSections(section.id);
                for (int i = 0; i < section.tocsAfter; ++i) {
                    this.output.emptyElement("toc");
                    ++this.tocNumber;
                    this.outputDeletedSections("toc:" + this.tocNumber);
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write fragmentinfo tag", ex);
            }
        }
        try {
            if (this.runDiffX == DiffType.COMBINED) {
                for (Section old_sec : this.oldSections.values()) {
                    if (this.newSections.contains(old_sec) || old_sec.previousSectionId == null) continue;
                    this.outputDeletedSection(old_sec);
                }
            }
            this.output.closeElement();
        }
        catch (IOException iOException) {
            throw new SAXException("Failed to close document tag", iOException);
        }
    }

    private void outputDeletedSections(String previousId) throws IOException {
        if (this.runDiffX == DiffType.COMBINED) {
            for (Section old_sec : this.oldSections.values()) {
                if (this.newSections.contains(old_sec) || !previousId.equals(old_sec.previousSectionId)) continue;
                this.outputDeletedSection(old_sec);
                old_sec.previousSectionId = null;
                this.outputDeletedSections(old_sec.id);
            }
        }
    }

    private void outputDeletedSection(Section oldSection) throws IOException {
        this.output.writeXML(oldSection.startTag.replace("<section", "<section deleted=\"true\""));
        if (!oldSection.startTag.endsWith(">")) {
            this.output.writeXML(">");
        }
        for (String frag : oldSection.fragments) {
            Fragment f = this.newFragments.get(frag);
            if (f != null && f.content != null) continue;
            this.outputDeletedFragment(frag);
        }
        this.output.writeXML("</section>");
    }

    private void outputDeletedFragment(String id) throws IOException {
        this.output.openElement("fragment");
        this.output.attribute("id", id);
        this.output.attribute("deleted", "true");
        this.output.closeElement();
    }

    private Map<String, String> findDeletedFragmentLocation(Section section) {
        HashMap<String, String> deletedlocation = new HashMap<String, String>();
        Section oldsection = this.oldSections.get(section.id);
        if (oldsection != null) {
            block0: for (String deleted : oldsection.deletedFragments) {
                ListIterator oldfrags = oldsection.fragments.listIterator(oldsection.fragments.size());
                boolean found = false;
                while (oldfrags.hasPrevious()) {
                    String oldfrag = (String)oldfrags.previous();
                    if (deleted.equals(oldfrag)) {
                        found = true;
                        continue;
                    }
                    if (!found || !oldsection.deletedFragments.contains(oldfrag) && !section.fragments.contains(oldfrag)) continue;
                    deletedlocation.put(oldfrag, deleted);
                    continue block0;
                }
            }
        }
        return deletedlocation;
    }

    public void startOldElement(String ns, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.inMediaFragment == 0) {
            if ("uri".equals(localName)) {
                this.oldTitle = attributes.getValue("title");
                this.oldDocID = attributes.getValue("docid");
                if ("true".equals(attributes.getValue("external"))) {
                    this.oldScheme = attributes.getValue("scheme");
                    this.oldHost = attributes.getValue("host");
                    this.oldPort = attributes.getValue("port");
                    this.oldPath = attributes.getValue("path");
                    this.oldDecodedPath = attributes.getValue("decodedpath");
                }
                this.inURI = true;
            } else if (this.inURI && "labels".equals(localName)) {
                this.text = new StringBuilder();
            } else if (this.inURI && "description".equals(localName)) {
                this.text = new StringBuilder();
            } else if ("locator".equals(localName)) {
                this.currentLocatorFragment = attributes.getValue("fragment");
                Fragment f = new Fragment();
                f.modified = attributes.getValue("modified");
                f.editid = attributes.getValue("editid");
                this.oldFragments.put(this.currentLocatorFragment, f);
            } else if (this.currentLocatorFragment != null && "labels".equals(localName)) {
                this.text = new StringBuilder();
            } else if ("notes".equals(localName) && this.currentLocatorFragment != null) {
                this.currentLocatorFragment = null;
            } else if ("section".equals(localName)) {
                XMLStringWriter section = new XMLStringWriter(XML.NamespaceAware.No);
                this.openElement((XMLWriter)section, localName, attributes);
                this.currentSection = new Section(attributes.getValue("id"), section.toString());
                this.oldSections.put(attributes.getValue("id"), this.currentSection);
            } else if (this.currentSection != null && "title".equals(localName)) {
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else if (PSMLContentUtils.isFragmentElement(localName)) {
                this.currentContentFragment = attributes.getValue("id");
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else if ("properties".equals(localName) && this.currentContentFragment == null) {
                this.currentContentFragment = "default";
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            }
        }
        if (this.xml != null) {
            this.openElement(this.xml, localName, attributes);
        }
    }

    public void endOldElement(String ns, String localName, String qName) throws SAXException {
        Fragment f;
        if (this.inMediaFragment != 0) {
            try {
                this.xml.closeElement();
                return;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write end tag for " + localName, ex);
            }
        }
        if (this.inURI && "labels".equals(localName) && this.text != null) {
            this.oldLabels = this.text.toString();
            this.text = null;
        } else if (this.inURI && "description".equals(localName) && this.text != null) {
            this.oldDescription = this.text.toString();
            this.text = null;
        } else if ("uri".equals(localName)) {
            this.inURI = false;
        } else if (this.currentLocatorFragment != null && "labels".equals(localName) && this.text != null) {
            String labels = this.text.toString();
            if (!labels.isEmpty() && this.oldFragments.containsKey(this.currentLocatorFragment)) {
                this.oldFragments.get((Object)this.currentLocatorFragment).labels = labels;
            }
            this.text = null;
            this.currentLocatorFragment = null;
        } else if (this.currentSection != null && "title".equals(localName)) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close title tag", ex);
            }
            this.currentSection.addTitle(this.xml.toString());
            this.xml = null;
        } else if (this.xml != null) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write end tag for " + localName, ex);
            }
        }
        if (PSMLContentUtils.isFragmentElement(localName) && this.currentContentFragment != null || "properties".equals(localName) && "default".equals(this.currentContentFragment)) {
            f = this.oldFragments.get(this.currentContentFragment);
            if (f == null) {
                f = new Fragment();
                this.oldFragments.put(this.currentContentFragment, f);
            }
            f.content = this.xml.toString();
            if (this.currentSection != null) {
                this.currentSection.fragments.push(this.currentContentFragment);
                f.section = this.currentSection;
            }
            this.currentContentFragment = null;
            this.xml = null;
        } else if ("metadata".equals(localName) && this.oldFragments.get("default") == null) {
            f = new Fragment();
            f.content = "<properties/>";
            this.oldFragments.put("default", f);
        } else if ("section".equals(localName)) {
            this.currentSection.previousSectionId = this.previousSectionId;
            this.previousSectionId = this.currentSection.id;
        } else if ("toc".equals(localName)) {
            ++this.tocNumber;
            this.previousSectionId = "toc:" + this.tocNumber;
        }
    }

    private void openElement(XMLWriter where, String localname, Attributes attributes) throws SAXException {
        try {
            where.openElement(localname);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attname = attributes.getLocalName(i);
                if (("xref".equals(localname) || "blockxref".equals(localname)) && "id".equals(attname)) continue;
                where.attribute(attname, attributes.getValue(i));
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write start tag for " + localname, ex);
        }
    }

    private void addCompare(Fragment newone, Fragment oldone, String fragment) throws SAXException {
        if (newone == null && oldone != null || newone != null && oldone == null || newone != null && oldone != null && (newone.modified != null && !newone.modified.equals(oldone.modified) || newone.modified == null && oldone.modified != null || this.autoNumbered)) {
            String oldcontent;
            String n = newone != null ? newone.content : null;
            String o = oldone != null ? oldone.content : null;
            String newcontent = n == null ? RuleUtils.generateEmptyFragment(o) : n;
            String string = oldcontent = o == null ? RuleUtils.generateEmptyFragment(n) : o;
            if (newcontent.equals(oldcontent)) {
                return;
            }
            try {
                this.output.openElement(COMPARE_ELEMENT);
                if (oldone != null) {
                    if (oldone.editid != null) {
                        this.output.attribute("editid", oldone.editid);
                    }
                    if (oldone.labels != null && !oldone.labels.isEmpty()) {
                        this.output.element("labels", oldone.labels);
                    }
                    if (oldone.content != null && !oldone.content.isEmpty()) {
                        this.output.openElement("content");
                        this.output.writeXML(oldone.content);
                        this.output.closeElement();
                    } else {
                        this.output.openElement("content");
                        this.output.openElement("fragment");
                        this.output.attribute("id", fragment);
                        this.output.closeElement();
                        this.output.closeElement();
                    }
                } else {
                    this.output.openElement("content");
                    this.output.openElement("fragment");
                    this.output.attribute("id", fragment);
                    this.output.closeElement();
                    this.output.closeElement();
                }
                if (this.runDiffX == DiffType.COMBINED) {
                    StringWriter diffout = new StringWriter();
                    PSMLDiffer differ = new PSMLDiffer(this.maxEvents);
                    differ.diff((Reader)new StringReader(newcontent), (Reader)new StringReader(oldcontent), (Writer)diffout);
                    String diffx = diffout.toString();
                    this.output.openElement("diff");
                    this.output.writeXML(diffx);
                    this.output.closeElement();
                } else if (this.runDiffX == DiffType.SPLIT) {
                    OriginTracker tracker = new OriginTracker();
                    ArrayList changes = new ArrayList();
                    changes.add(PSMLCompareHandler.toTrackedContent(oldcontent));
                    changes.add(PSMLCompareHandler.toTrackedContent(newcontent));
                    StringWriter psml = new StringWriter();
                    DiffXMLOutput resultsOutput = new DiffXMLOutput(psml);
                    resultsOutput.setMode(Operator.DEL);
                    resultsOutput.write(tracker.trackReverse(changes));
                    this.output.openElement("diff");
                    this.output.writeXML(psml.toString());
                    this.output.closeElement();
                    this.trackedFragments.put(fragment, tracker.track(changes, false));
                }
                this.output.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write compare tag for fragment " + fragment, ex);
            }
            catch (DiffException ex) {
                throw new SAXException("Failed to run diffX for fragment " + fragment + ": " + ex.getMessage(), (Exception)((Object)ex));
            }
        }
    }

    boolean writeTrackedChanges(String fragment) throws SAXException {
        TrackedSequence<String> tracked = this.trackedFragments.get(fragment);
        if (tracked == null) {
            return false;
        }
        StringWriter psml = new StringWriter();
        DiffXMLOutput<String> resultsOutput = new DiffXMLOutput<String>(psml);
        resultsOutput.setMode(Operator.INS);
        try {
            resultsOutput.write(tracked);
            this.output.writeXML(psml.toString());
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write tracked changes for fragment " + fragment, ex);
        }
        catch (DiffException ex) {
            throw new SAXException("Failed to run forward diffX for fragment " + fragment, (Exception)((Object)ex));
        }
        return true;
    }

    private void addNotes(String fragment, XMLWriter where) throws SAXException {
        if (this.notes == null) {
            try {
                Date end;
                Date start = this.compareOriginal || this.compareVersion == null ? null : this.compareVersion.getDate();
                Date date = end = this.currentVersion == null ? null : this.currentVersion.getDate();
                if (!this.compareOriginal && (start == null && end != null || start != null && end != null && end.before(start))) {
                    Date temp = start;
                    start = end;
                    end = temp;
                }
                this.notes = DatabaseQuery.getXLinksByURIGroupNotesCreationBeforeAfter((Database)this.database, (URI)this.uri, (Long)this.groupid, (Date)start, (Date)end);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load notes from DB", (Throwable)ex);
                throw new SAXException("Failed to load notes from DB", (Exception)((Object)ex));
            }
        }
        List<XLink> mynotes = this.notes.get(fragment);
        String originals = this.originalNotes.get(fragment);
        if (mynotes != null || originals != null) {
            try {
                where.openElement("notes");
                if (originals != null) {
                    where.writeXML(originals);
                }
                if (mynotes != null) {
                    for (XLink note : mynotes) {
                        PSMLContentBuilder.note(note, where);
                    }
                }
                where.closeElement();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write notes element for {}", (Object)fragment, (Object)ex);
                throw new SAXException("Failed to write notes element for " + fragment, ex);
            }
        }
    }

    public static TrackedContent<String> toTrackedContent(String content) {
        return new TrackedContent<String>(content, "");
    }

    private static final class Section {
        private final String id;
        private String startTag;
        private Stack<String> fragments = new Stack();
        private List<String> deletedFragments = new ArrayList<String>();
        private int tocsAfter = 0;
        private @Nullable String previousSectionId = null;

        public Section(String id, String tag) {
            this.id = id;
            this.startTag = tag;
        }

        public void addTitle(String xml) {
            if (!this.startTag.endsWith(">")) {
                this.startTag = this.startTag + ">";
            }
            this.startTag = this.startTag + xml;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return this.getClass().getName().equals(o.getClass().getName());
            }
            return this.id != null && this.id.equals(((Section)o).id);
        }
    }

    private static final class Fragment {
        private @Nullable String modified = null;
        private @Nullable String editid = null;
        private @Nullable String labels = null;
        private @Nullable String content = null;
        private @Nullable Section section = null;

        private Fragment() {
        }
    }

    public static enum DiffType {
        NONE,
        COMBINED,
        SPLIT;

    }
}

