/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentMetadata;
import com.pageseeder.base.document.PSMLCompareHandler;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentResolver;
import com.pageseeder.base.document.PSMLTransclusionResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.document.URIParamException;
import com.pageseeder.base.publication.ContentAdjustor;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.rule.ExternalURIFetcher;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Groups;
import com.pageseeder.db.util.URIs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.psml.toc.XRefLoopException;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DocumentContentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentContentResolver.class);
    public static final String PSML_MEDIA_TYPE = "application/vnd.pageseeder.psml+xml";
    private static final String CURRENT_VERSION = "version=\"current\"";
    private static final String DATE_START = "date=\"";
    private static final String MODIFIED_START = "modified=\"";
    private static final String DISPLAYTITLE_START = "<displaytitle>";
    private static final String VERSIONS_START = "<versions>";
    private static final String VERSIONS_END = "</versions>";
    private final Long _uriid;
    private @Nullable String _groupName;
    private @Nullable Long groupid;
    private @Nullable Long releaseId;
    private @Nullable String releaseVersion;
    private Long compareURIId;
    private String compareGroupName;
    private @Nullable Long compareId;
    private @Nullable String compareVersion;
    private PSMLCompareHandler.DiffType runCompareDiffX = PSMLCompareHandler.DiffType.NONE;
    private @Nullable Publication publication = null;
    private int position = 0;
    private @Nullable Map<String, String> publicatonMetadata = null;
    private @Nullable Publication comparePublication = null;
    private int comparePosition = 0;
    private boolean reloadPublication = false;
    private @Nullable Long draftMemberId = null;
    private @Nullable String fragment = null;
    private @Nullable DocumentMetadata metadata;
    private @Nullable URIFetcher fetcher;
    private boolean fetcherPrimed = false;
    private @Nullable UserDetails userDetails = null;
    private @Nullable Boolean hasTransclusions = null;
    private boolean fragmentinfo = false;
    private boolean reversexrefs = true;
    private boolean psmlformat = false;
    private Cache xmlCache;

    public DocumentContentResolver(Long uid, @Nullable String groupname) {
        this._uriid = uid;
        this._groupName = groupname;
        this.compareURIId = uid;
        this.compareGroupName = groupname;
        CacheManager manager = CacheManager.getInstance();
        this.xmlCache = manager.getCache("xml-documents");
    }

    public DocumentContentResolver(Long uid, String groupname, Long groupid) {
        this._uriid = uid;
        this._groupName = groupname;
        this.groupid = groupid;
        this.compareURIId = uid;
        this.compareGroupName = groupname;
        CacheManager manager = CacheManager.getInstance();
        this.xmlCache = manager.getCache("xml-documents");
    }

    public static void clearCacheAllDocuments() {
        CacheManager manager = CacheManager.getInstance();
        LOGGER.debug("Clear XMLDocument Cache ALL");
        manager.getCache("xml-documents").removeAll();
    }

    public final void clearCacheDocument(Database db) throws URIException {
        URI uri;
        try {
            uri = DatabaseQuery.getURIById((Database)db, (Long)this._uriid);
            Group group = this.loadGroup(db, uri);
            this.groupid = group.getId();
        }
        catch (QueryFailedException ex) {
            throw new URIException(ex);
        }
        if (this.releaseId == null && this.releaseVersion != null) {
            try {
                this.releaseId = XLinkRule.getValidRelease(db, uri, null, this.releaseVersion, this.publication);
            }
            catch (QueryFailedException ex) {
                throw new URIException("Failed to find version " + this.releaseVersion, ex);
            }
        }
        String key = this.getCacheKey();
        LOGGER.debug("Clear XMLDocument Cache with key={}", (Object)key);
        this.xmlCache.remove((Serializable)((Object)key));
    }

    public final void clearCacheDocument(@Nullable Long releaseid) {
        if (this.groupid == null) {
            throw new IllegalStateException("groupid must be set");
        }
        this.releaseId = releaseid;
        String key = this.getCacheKey();
        LOGGER.debug("Clear XMLDocument Cache with key={}", (Object)key);
        this.xmlCache.remove((Serializable)((Object)key));
    }

    public final void includeDraftContent(Long id) {
        this.draftMemberId = id;
    }

    public final void setPublication(@Nullable Publication pub, int pos, @Nullable Map<String, String> metadata, boolean reload) {
        this.publication = pub;
        this.position = pos;
        this.publicatonMetadata = metadata;
        this.reloadPublication = reload;
    }

    public final void setComparePublication(Publication pub, int pos) {
        this.comparePublication = pub;
        this.comparePosition = pos;
    }

    public final void setFragment(String frag) {
        this.fragment = frag;
    }

    public final void setReleaseId(@Nullable Long releaseid) {
        this.releaseId = releaseid;
    }

    public final void setReleaseVersion(@Nullable String version) {
        this.releaseVersion = version;
    }

    public final void setCompareId(Long compareid, PSMLCompareHandler.DiffType runDiffX) {
        this.compareId = compareid;
        this.runCompareDiffX = runDiffX;
    }

    public final void setCompareVersion(String version) {
        this.compareVersion = version;
    }

    public final void setCompareDocument(Long uriid, String groupname) {
        this.compareURIId = uriid;
        this.compareGroupName = groupname;
    }

    public final void setTransclude(UserDetails userdetails) {
        this.userDetails = userdetails;
    }

    public final void setFragmentInfo(boolean fragmentInfo) {
        this.fragmentinfo = fragmentInfo;
    }

    public final void setReverseXRefs(boolean xrefs) {
        this.reversexrefs = xrefs;
    }

    public final void setPSMLFormat(boolean psmlformat) {
        this.psmlformat = psmlformat;
    }

    public void setFetcher(URIFetcher fetcher) {
        this.fetcher = fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream getContent(Database db) throws URIException {
        boolean psml;
        Group group;
        URI compareuri;
        URI uri;
        block57: {
            URI u;
            XLink xl;
            block56: {
                this.hasTransclusions = false;
                uri = this.loadMetadata(db);
                try {
                    compareuri = uri.getId().equals(this.compareURIId) ? uri : DatabaseQuery.getURIById((Database)db, (Long)this.compareURIId);
                    group = this.loadGroup(db, uri);
                    this.groupid = group.getId();
                }
                catch (QueryFailedException ex) {
                    throw new URIException(ex);
                }
                if (compareuri == null) {
                    throw new URIParamException("Not a valid compare uriid " + this.compareURIId);
                }
                if (this.comparePublication == null) {
                    this.comparePublication = this.publication;
                }
                if (this.releaseId != null) {
                    try {
                        if (this.releaseId != 0L) {
                            xl = DatabaseQuery.getXLinkById((Database)db, (Long)this.releaseId);
                            if (xl == null) {
                                throw new URIParamException("Not a valid version id " + this.releaseId);
                            }
                            u = URIRule.getURIByXLink(xl);
                            if (!(u != null && u.equals((Object)uri) || "File Upload".equals(xl.getContentTitle()))) {
                                throw new URIParamException("The uriid " + this._uriid + " is not related to version id " + this.releaseId);
                            }
                        }
                        break block56;
                    }
                    catch (QueryFailedException ex) {
                        throw new URIException("Failed to find version or version id " + this.releaseId, ex);
                    }
                }
                if (this.releaseVersion != null) {
                    try {
                        this.releaseId = XLinkRule.getValidRelease(db, uri, null, this.releaseVersion, this.publication);
                    }
                    catch (QueryFailedException ex) {
                        throw new URIException("Failed to find version " + this.releaseVersion, ex);
                    }
                }
            }
            if (this.compareId != null && this.compareId != -1L) {
                try {
                    if (this.compareId != 0L) {
                        xl = DatabaseQuery.getXLinkById((Database)db, (Long)this.compareId);
                        if (xl == null) {
                            throw new URIParamException("Not a valid compare id " + this.compareId);
                        }
                        u = URIRule.getURIByXLink(xl);
                        if (!(u != null && u.equals((Object)compareuri) || "File Upload".equals(xl.getContentTitle()))) {
                            throw new URIParamException("The compare uriid " + this.compareURIId + " is not related to compare id " + this.compareId);
                        }
                    }
                    break block57;
                }
                catch (QueryFailedException ex) {
                    throw new URIException("Failed to find compare or compare id " + this.compareId, ex);
                }
            }
            if ("current".equals(this.compareVersion)) {
                this.compareId = -1L;
            } else if (this.compareVersion != null) {
                try {
                    this.compareId = XLinkRule.getValidRelease(db, uri, null, this.compareVersion, this.comparePublication);
                }
                catch (QueryFailedException ex) {
                    throw new URIException("Failed to find compare version " + this.compareVersion, ex);
                }
            }
        }
        String mime_type = this.metadata.getMimeType();
        boolean bl = psml = PSML_MEDIA_TYPE.equals(mime_type) || this.psmlformat;
        if (psml) {
            PSMLTransclusionResolver tresolver;
            InputStream is;
            block58: {
                is = null;
                String cache_key = this.getCacheKey();
                boolean cache_format = false;
                try {
                    cache_format = this.isCacheFormat(mime_type) && this.compareId == null && (this.releaseId == null || XLinkRule.getValidRelease(db, uri, this.releaseId, null, this.publication) != -1L);
                }
                catch (QueryFailedException ex) {
                    throw new URIException("Failed to find version id " + this.releaseId, ex);
                }
                if (cache_format) {
                    this.xmlCache.acquireWriteLockOnKey((Object)cache_key);
                }
                try {
                    XMLDocument doc;
                    block60: {
                        doc = null;
                        if (cache_format) {
                            doc = this.getCachedContent(cache_key);
                        }
                        Date last_mod_date = uri.getLastModified();
                        if (doc != null && this.compareId == null && (this.releaseId != null || last_mod_date == null || last_mod_date.equals(doc.lastModified))) {
                            is = new ByteArrayInputStream(doc.xmlContent);
                            this.metadata.setLastModified(last_mod_date);
                            this.metadata.setSize(doc.xmlContent.length);
                            break block58;
                        }
                        this.loadFetcher(db, uri);
                        if (last_mod_date != null) {
                            this.metadata.setLastModified(last_mod_date);
                        } else {
                            this.metadata.setLastModified(new Date(this.fetcher.getLastModified()));
                        }
                        this.metadata.setSize(this.fetcher.getContentLength());
                        if (this.compareId != null) {
                            is = this.comparePSMLContent(db, uri, group, compareuri);
                        } else {
                            LOGGER.debug("Resolving PSML content for uriid={}, fragment={}, releaseId={}", new Object[]{this._uriid, this.fragment, this.releaseId});
                            PSMLContentResolver resolver = new PSMLContentResolver(db, uri, this.fetcher, this._groupName);
                            resolver.setFragment(this.fragment, this.draftMemberId, this.fragmentinfo, this.reversexrefs);
                            resolver.setReleaseId(this.releaseId);
                            is = resolver.getContent();
                        }
                        if (!cache_format) break block58;
                        try {
                            try {
                                doc = new XMLDocument(last_mod_date, IOUtils.toByteArray((InputStream)is));
                            }
                            finally {
                                is.close();
                            }
                            this.putCachedContent(this.getCacheKey(), doc);
                            if (!psml || this.releaseId != null || last_mod_date == null) break block60;
                            for (XLink xl : DatabaseQuery.getReleaseXLinksByDateAllGroups((Database)db, (URI)uri, (Date)last_mod_date)) {
                                if (!Groups.getGroupNames(XLinkRule.getGroups(xl)).contains(this._groupName)) continue;
                                String content = DocumentContentResolver.modifyVersion(doc.xmlContent, xl);
                                if (content != null) {
                                    this.putCachedContent(this.getCacheKey(xl.getId()), new XMLDocument(last_mod_date, content.getBytes(StandardCharsets.UTF_8)));
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (DatabaseException | IOException ex) {
                            throw new URIException(ex);
                        }
                    }
                    is = new ByteArrayInputStream(doc.xmlContent);
                }
                finally {
                    if (cache_format) {
                        this.xmlCache.releaseWriteLockOnKey((Object)cache_key);
                    }
                }
            }
            String outs = null;
            if (this.userDetails != null && this.compareId == null && (tresolver = new PSMLTransclusionResolver()) != null) {
                try {
                    outs = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to read content when loading transclusions for {}", (Object)uri.getPath(), (Object)ex);
                }
                this.hasTransclusions = tresolver.hasTransclusions(outs);
                if (outs != null && this.hasTransclusions.booleanValue()) {
                    try {
                        StringWriter tout = new StringWriter();
                        tresolver.resolveTransclusions(new StringReader(outs), tout, db, this.userDetails, this.releaseVersion, this.publication);
                        outs = tout.toString();
                    }
                    catch (IOException ex) {
                        LOGGER.error("Failed to load transclusions for {}", (Object)uri.getPath(), (Object)ex);
                    }
                }
            }
            if (this.publication != null && this.position != -1 && this.compareId == null) {
                boolean transclude = outs != null;
                try {
                    if (outs != null) return DocumentContentResolver.adjustContent(db, this.publication, this.position, uri, group, outs, transclude, this.releaseVersion, this.reloadPublication, this.fragment, false, this.userDetails, this.publicatonMetadata);
                    outs = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    return DocumentContentResolver.adjustContent(db, this.publication, this.position, uri, group, outs, transclude, this.releaseVersion, this.reloadPublication, this.fragment, false, this.userDetails, this.publicatonMetadata);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to adjust content for {}", (Object)uri.getPath(), (Object)ex);
                }
            }
            if (outs == null) return is;
            return new ByteArrayInputStream(outs.getBytes(StandardCharsets.UTF_8));
        }
        this.loadFetcher(db, uri);
        this.metadata.setLastModified(new Date(this.fetcher.getLastModified()));
        this.metadata.setSize(this.fetcher.getContentLength());
        try {
            return this.fetcher.getContent();
        }
        catch (IOException ex) {
            throw new URIException(ex);
        }
    }

    public final @Nullable URIFetcherStatus getStatus() {
        return this.fetcher != null ? this.fetcher.getStatus() : null;
    }

    private Group loadGroup(Database db, URI uri) throws QueryFailedException, URIException {
        Group group = null;
        if (URIs.isExternal((URI)uri)) {
            if (this._groupName != null) {
                group = DatabaseQuery.getGroupByName((Database)db, (String)this._groupName);
            }
            Group pgroup = DatabaseQuery.getGroupByName((Database)db, (String)"public");
            if (this._groupName == null || DatabaseQuery.getNumberXRefsByURIGroup((Database)db, (Long)uri.getId(), (Group)group, (Group)pgroup) == 0) {
                this._groupName = "public";
                return pgroup;
            }
        } else if (URIRule.isDefaultGroup(uri, this._groupName)) {
            group = DatabaseQuery.getGroupByName((Database)db, (String)this._groupName);
        } else {
            group = URIRule.getDefaultGroupForURI(uri);
            if (group == null) {
                throw new URIException("Unable to find default group for URI ID: " + this._uriid);
            }
            this._groupName = group.getName();
        }
        if (group == null) {
            throw new URIException("Unable to find group: " + this._groupName);
        }
        return group;
    }

    public static InputStream adjustContent(Database db, Publication pub, int pos, URI uri, Group group, String content, boolean transclude, String version, boolean reload, @Nullable String fragment, boolean diff, @Nullable UserDetails userdetails, @Nullable Map<String, String> metadata) throws URIException {
        PublicationManager manager = PublicationManager.singleton();
        try {
            Group pubgroup = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
            if (pubgroup == null) {
                throw new QueryFailedException("Group not found for ID: " + pub.getDefaultGroupId());
            }
            PublicationConfig pubconf = manager.getPublicationConfig(pubgroup, pub.getType());
            NumberedTOC toc = null;
            try {
                if (pub.getXLinkId() == -1L) {
                    DocumentTree doctree = fragment != null || diff ? manager.parseDocument(db, uri.getId(), group, true, version, pub) : manager.parseDocument(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), uri.getId(), true);
                    PublicationTree pubtree = new PublicationTree(doctree.normalize(pubconf.getTocTitleCollapse()));
                    FragmentNumbering numbering = new FragmentNumbering(pubtree, pubconf);
                    toc = new NumberedTOC(pubtree, numbering, pub.getDefaultGroupId(), pub.getType(), false, pub.getRootModified(), false);
                } else {
                    toc = version != null && !"".equals(version) && !"current".equals(version) ? manager.getNumberedTOC(db, pub, version, uri) : manager.getNumberedTOC(db, pub, reload);
                }
            }
            catch (XRefLoopException ex) {
                LOGGER.warn("Failed loading TOC to adjust content for publication " + pub.getId(), (Throwable)ex);
            }
            catch (SAXException ex) {
                LOGGER.error("Failed loading TOC to adjust content for publication " + pub.getId(), (Throwable)ex);
            }
            StringWriter out = new StringWriter();
            ContentAdjustor adjustor = new ContentAdjustor(out, toc, pubconf, uri.getId(), pub.getId(), pos, transclude, diff, userdetails, db);
            adjustor.setPublicationMetadata(metadata);
            XMLHelpers.parse(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), adjustor);
            return new ByteArrayInputStream(out.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to adjust content for publication " + pub.getId(), (Throwable)ex);
            return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (DatabaseException ex) {
            throw new URIException("Failed to adjust content for publication " + pub.getId(), ex);
        }
    }

    private static String modifyVersion(byte[] psml, XLink version) throws IOException {
        StringBuilder content = new StringBuilder(new String(psml, StandardCharsets.UTF_8));
        int curversion = content.indexOf(CURRENT_VERSION);
        if (curversion == -1) {
            return null;
        }
        int verstart = content.indexOf(VERSIONS_START);
        if (verstart == -1) {
            return null;
        }
        int verend = content.indexOf(VERSIONS_END);
        if (verend == -1) {
            return null;
        }
        XMLStringWriter verelement = new XMLStringWriter(XML.NamespaceAware.No);
        PSMLContentBuilder.version(version, (XMLWriter)verelement);
        content.replace(verstart + VERSIONS_START.length(), verend, verelement.toString());
        String verattrs = "version=\"" + XML.escapeAttr((String)version.getContentTitle()) + "\"";
        content.replace(curversion, curversion + CURRENT_VERSION.length(), verattrs);
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyStatusInCache(String status, Date modified, Date lastmodified) throws URIException {
        if (this.groupid == null) {
            throw new URIException("Group ID is not set");
        }
        if (this.releaseId != null) {
            return;
        }
        String cache_key = this.getCacheKey();
        this.xmlCache.acquireWriteLockOnKey((Object)cache_key);
        try {
            XMLDocument doc = this.getCachedContent(cache_key);
            if (doc != null && modified != null && modified.equals(doc.lastModified)) {
                String content = DocumentContentResolver.modifyStatus(doc.xmlContent, status, lastmodified);
                if (content == null) {
                    return;
                }
                doc = new XMLDocument(lastmodified, content.getBytes(StandardCharsets.UTF_8));
                this.putCachedContent(this.getCacheKey(), doc);
                LOGGER.debug("Modfied status of document with key={}", (Object)cache_key);
            }
        }
        finally {
            this.xmlCache.releaseWriteLockOnKey((Object)cache_key);
        }
    }

    protected static String modifyStatus(byte[] psml, String status, Date lastmodified) {
        StringBuilder content = new StringBuilder(new String(psml, StandardCharsets.UTF_8));
        int datestart = content.indexOf(DATE_START);
        if (datestart == -1) {
            return null;
        }
        int curversion = content.indexOf(CURRENT_VERSION);
        if (curversion == -1 || datestart > curversion) {
            return null;
        }
        int modstart = content.indexOf(MODIFIED_START, curversion);
        if (modstart == -1) {
            return null;
        }
        int modend = content.indexOf("\"", modstart + MODIFIED_START.length() + 1);
        if (modend == -1) {
            return null;
        }
        int dispstart = content.indexOf(DISPLAYTITLE_START);
        if (dispstart == -1 || modstart > dispstart || modend > dispstart) {
            return null;
        }
        String lastmod = ISO8601.format((long)lastmodified.getTime(), (ISO8601)ISO8601.DATETIME);
        String modifiedattr = MODIFIED_START + lastmod;
        content.replace(modstart, modend, modifiedattr);
        String statusattrs = DATE_START + lastmod + "\" ";
        if (status != null) {
            statusattrs = statusattrs + "status=\"" + XML.escapeAttr((String)status) + "\" ";
        }
        content.replace(datestart, curversion, statusattrs);
        return content.toString();
    }

    private InputStream comparePSMLContent(Database db, URI uri, Group group, URI compareuri) throws URIException {
        DocumentContentResolver oldResolver = new DocumentContentResolver(this.compareURIId, this.compareGroupName);
        oldResolver.setReleaseId(this.compareId == -1L ? null : this.compareId);
        if (this.fragment != null) {
            oldResolver.setFragment(this.fragment);
            oldResolver.setFragmentInfo(true);
        }
        oldResolver.setPSMLFormat(true);
        InputStream oldContent = oldResolver.getContent(db);
        if (oldContent == null) {
            return null;
        }
        if (this.publication != null) {
            try {
                oldContent = DocumentContentResolver.adjustContent(db, this.comparePublication, this.comparePosition != 0 ? this.comparePosition : this.position, compareuri, group, IOUtils.toString((InputStream)oldContent, (Charset)StandardCharsets.UTF_8), false, this.compareVersion, this.reloadPublication, this.fragment, false, this.userDetails, null);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to adjust content for URIID {} compareID {}", new Object[]{this.compareURIId, this.compareId, ex});
            }
        }
        PSMLCompareHandler handler = new PSMLCompareHandler(uri, this.groupid, this.runCompareDiffX, db, this.publication != null && this.position != -1, this.fragment);
        handler.parseOldContent(oldContent, this.compareId);
        DocumentContentResolver newResolver = new DocumentContentResolver(uri.getId(), this._groupName);
        newResolver.setReleaseId(this.releaseId);
        if (this.fragment != null) {
            newResolver.setFragment(this.fragment);
            newResolver.setFragmentInfo(true);
        }
        newResolver.setFragmentInfo(true);
        newResolver.setPSMLFormat(true);
        InputStream newContent = newResolver.getContent(db);
        if (this.publication != null) {
            try {
                newContent = DocumentContentResolver.adjustContent(db, this.publication, this.position, uri, group, IOUtils.toString((InputStream)newContent, (Charset)StandardCharsets.UTF_8), false, this.releaseVersion, this.reloadPublication, this.fragment, false, this.userDetails, null);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to adjust content for URIID {} releaseID {}", new Object[]{uri.getId(), this.releaseId, ex});
            }
        }
        XMLStringWriter psml = new XMLStringWriter(XML.NamespaceAware.No);
        handler.parseNewContent(newContent, this.releaseId, (XMLWriter)psml);
        return new ByteArrayInputStream(psml.toString().getBytes(StandardCharsets.UTF_8));
    }

    public boolean hasTransclusions() {
        if (this.hasTransclusions == null) {
            throw new IllegalStateException("getContent() must be called first");
        }
        return this.hasTransclusions;
    }

    private boolean isCacheFormat(String mimetype) {
        return this.fragment == null && (PSML_MEDIA_TYPE.equals(mimetype) || this.psmlformat);
    }

    private void putCachedContent(String key, XMLDocument doc) {
        LOGGER.debug("Put XMLDocument cache with key={}", (Object)key);
        this.xmlCache.put(new Element((Serializable)((Object)key), (Serializable)doc));
    }

    private XMLDocument getCachedContent(String key) {
        LOGGER.debug("Get XMLDocument cache with key={}", (Object)key);
        Element el = this.xmlCache.get((Serializable)((Object)key));
        if (el == null) {
            return null;
        }
        return (XMLDocument)el.getObjectValue();
    }

    private String getCacheKey() {
        String key = this.groupid + "-" + this._uriid + "-";
        if (this.releaseId != null) {
            key = key + this.releaseId;
        }
        return key;
    }

    private String getCacheKeyForGroup(Long grpid) {
        String key = grpid + "-" + String.valueOf(this._uriid) + "-";
        if (this.releaseId != null) {
            key = key + this.releaseId;
        }
        return key;
    }

    private String getCacheKey(Long releaseid) {
        String key = this.groupid + "-" + String.valueOf(this._uriid) + "-";
        if (releaseid != null) {
            key = key + releaseid;
        }
        return key;
    }

    private URI loadMetadata(Database db) throws URIException {
        URI uri;
        LOGGER.debug("Loading MIME type for uriid={}", (Object)this._uriid);
        try {
            uri = DatabaseQuery.getURIById((Database)db, (Long)this._uriid);
        }
        catch (QueryFailedException ex) {
            throw new URIException("Unable to load URI " + this._uriid, ex);
        }
        if (uri == null) {
            throw new URIException("URI not found for uriid=" + this._uriid);
        }
        if (this.metadata == null) {
            this.metadata = new DocumentMetadata();
        }
        this.metadata.setMimeType(uri.getType());
        if (this.metadata.getMimeType() == null || "unverified".equals(this.metadata.getMimeType())) {
            this.loadFetcher(db, uri);
        }
        return uri;
    }

    private void loadFetcher(Database db, URI uri) throws URIException {
        if (this.fetcher == null) {
            LOGGER.debug("Loading fetcher for uriid={}", (Object)uri.getId());
            this.fetcher = URIs.isExternal((URI)uri) ? new ExternalURIFetcher(URIRule.getURIString(uri), null) : new InternalURIFetcher(uri, null);
        }
        if (this.fetcherPrimed) {
            return;
        }
        this.fetcherPrimed = true;
        if (this.fetcher.getStatus() != URIFetcherStatus.SUCCESS) {
            throw new URIException("URIFetcher Status: " + String.valueOf((Object)this.fetcher.getStatus()) + " Message: " + this.fetcher.getStatusMessage());
        }
        this.metadata.setMimeType(this.fetcher.getContentType());
        this.metadata.setDescription(uri.getDescription());
        if (!URIs.isExternal((URI)uri) && this.metadata.getMimeType() != null && !this.metadata.getMimeType().equals(uri.getType())) {
            uri.setType(this.metadata.getMimeType());
        }
    }

    private static final class XMLDocument
    implements Serializable {
        private static final long serialVersionUID = 8704232243442685176L;
        private final @Nullable Date lastModified;
        private final byte[] xmlContent;

        private XMLDocument(Date lastmodified, byte[] xml) {
            this.lastModified = lastmodified == null ? null : new Date(lastmodified.getTime());
            this.xmlContent = xml;
        }
    }
}

