/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.changes;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesListener;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;

public final class ChangesManager {
    private static final ChangesManager SINGLETON = new ChangesManager();
    private static final Collection<ChangesListener> LISTENERS = new ArrayList<ChangesListener>();

    public static ChangesManager getInstance() {
        return SINGLETON;
    }

    public static void registerListener(ChangesListener listener) {
        LISTENERS.add(listener);
    }

    public static void deregisterListener(ChangesListener listener) {
        LISTENERS.remove(listener);
    }

    public void startBatch(Database db, ChangesBatch batch) {
        for (ChangesListener listener : LISTENERS) {
            listener.startBatch(db, batch);
        }
    }

    public void completeBatch(Database db, ChangesBatch batch) {
        for (ChangesListener listener : LISTENERS) {
            listener.completeBatch(db, batch);
        }
    }

    public void createMembership(Database db, @Nullable ChangesBatch batch, MemberForGroup membership) {
        for (ChangesListener listener : LISTENERS) {
            listener.createMembership(db, batch, membership);
        }
    }

    public void createMembership(Database db, MemberForGroup membership) {
        this.createMembership(db, null, membership);
    }

    public void modifyMembership(Database db, @Nullable ChangesBatch batch, MemberForGroup membership) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyMembership(db, batch, membership);
        }
    }

    public void modifyMembership(Database db, MemberForGroup membership) {
        this.modifyMembership(db, null, membership);
    }

    public void deleteMembership(Database db, @Nullable ChangesBatch batch, Long membershipId, Group group) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteMembership(db, batch, membershipId, group);
        }
    }

    public void deleteMembership(Database db, Long membershipId, Group group) {
        this.deleteMembership(db, null, membershipId, group);
    }

    public void createMember(Database db, @Nullable ChangesBatch batch, Member member) {
        for (ChangesListener listener : LISTENERS) {
            listener.createMember(db, batch, member);
        }
    }

    public void createMember(Database db, Member member) {
        this.createMember(db, null, member);
    }

    public void modifyMember(Database db, @Nullable ChangesBatch batch, Member member) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyMember(db, batch, member);
        }
    }

    public void modifyMember(Database db, Member member) {
        this.modifyMember(db, null, member);
    }

    public void deleteMember(Database db, @Nullable ChangesBatch batch, Long memberId, String username, String email) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteMember(db, batch, memberId, username, email);
        }
    }

    public void deleteMember(Database db, Long memberId, String username, String email) {
        this.deleteMember(db, null, memberId, username, email);
    }

    public void deleteGroup(Database db, @Nullable ChangesBatch batch, Long groupId, String name) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteGroup(db, batch, groupId, name);
        }
    }

    public void deleteGroup(Database db, Long groupId, String name) {
        this.deleteGroup(db, null, groupId, name);
    }

    public void renameGroup(Database db, @Nullable ChangesBatch batch, Group group, String name) {
        for (ChangesListener listener : LISTENERS) {
            listener.renameGroup(db, batch, group, name);
        }
    }

    public void renameGroup(Database db, Group group, String name) {
        this.renameGroup(db, null, group, name);
    }

    public void archiveGroup(Database db, @Nullable ChangesBatch batch, Group group, String name) {
        for (ChangesListener listener : LISTENERS) {
            listener.archiveGroup(db, batch, group, name);
        }
    }

    public void archiveGroup(Database db, Group group, String name) {
        this.archiveGroup(db, null, group, name);
    }

    public void createGroup(Database db, @Nullable ChangesBatch batch, Group group) {
        for (ChangesListener listener : LISTENERS) {
            listener.createGroup(db, batch, group);
        }
    }

    public void createGroup(Database db, Group group) {
        this.createGroup(db, null, group);
    }

    public void modifyGroup(Database db, @Nullable ChangesBatch batch, Group group) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyGroup(db, batch, group);
        }
    }

    public void modifyGroup(Database db, Group group) {
        this.modifyGroup(db, null, group);
    }

    public void modifyGroupProperties(Database db, @Nullable ChangesBatch batch, Group group) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyGroupProperties(db, batch, group);
        }
    }

    public void modifyGroupProperties(Database db, Group group) {
        this.modifyGroupProperties(db, null, group);
    }

    public void createProject(Database db, @Nullable ChangesBatch batch, Group project) {
        for (ChangesListener listener : LISTENERS) {
            listener.createProject(db, batch, project);
        }
    }

    public void createProject(Database db, Group project) {
        this.createProject(db, null, project);
    }

    public void renameProject(Database db, @Nullable ChangesBatch batch, Group project, String name) {
        for (ChangesListener listener : LISTENERS) {
            listener.renameProject(db, batch, project, name);
        }
    }

    public void renameProject(Database db, Group project, String name) {
        this.renameProject(db, null, project, name);
    }

    public void archiveProject(Database db, @Nullable ChangesBatch batch, Group project, String name) {
        for (ChangesListener listener : LISTENERS) {
            listener.archiveProject(db, batch, project, name);
        }
    }

    public void archiveProject(Database db, Group project, String name) {
        this.archiveProject(db, null, project, name);
    }

    public void deleteProject(Database db, @Nullable ChangesBatch batch, Long projectId, String name) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteProject(db, batch, projectId, name);
        }
    }

    public void deleteProject(Database db, Long projectId, String name) {
        this.deleteProject(db, null, projectId, name);
    }

    public void modifyProject(Database db, @Nullable ChangesBatch batch, Group project) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyProject(db, batch, project);
        }
    }

    public void modifyProject(Database db, Group project) {
        this.modifyProject(db, null, project);
    }

    public void createVersion(Database db, @Nullable ChangesBatch batch, URI uri, XLink version, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.createVersion(db, batch, uri, version, groups);
        }
    }

    public void createVersion(Database db, URI uri, XLink version, Collection<Group> groups) {
        this.createVersion(db, null, uri, version, groups);
    }

    public void archiveVersion(Database db, @Nullable ChangesBatch batch, URI uri, XLink version, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.archiveVersion(db, batch, uri, version, groups);
        }
    }

    public void archiveVersion(Database db, URI uri, XLink version, Collection<Group> groups) {
        this.archiveVersion(db, null, uri, version, groups);
    }

    public void createWorkflow(Database db, @Nullable ChangesBatch batch, XLink workflow, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.createWorkflow(db, batch, workflow, groups);
        }
    }

    public void createWorkflow(Database db, XLink workflow, Collection<Group> groups) {
        this.createWorkflow(db, null, workflow, groups);
    }

    public void deleteWorkflow(Database db, @Nullable ChangesBatch batch, Long contentId, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteWorkflow(db, batch, contentId, groups);
        }
    }

    public void deleteWorkflow(Database db, Long contentId, Collection<Group> groups) {
        this.deleteWorkflow(db, null, contentId, groups);
    }

    public void taskUpdated(Database db, @Nullable ChangesBatch batch, XLink task, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.taskUpdated(db, batch, task, groups);
        }
    }

    public void taskUpdated(Database db, @Nullable ChangesBatch batch, Long rootXlinkId, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.taskUpdated(db, batch, rootXlinkId, groups);
        }
    }

    public void createComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.createComment(db, batch, comment, groups);
        }
    }

    public void createComment(Database db, XLink comment, Collection<Group> groups) {
        this.createComment(db, null, comment, groups);
    }

    public void archiveComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.archiveComment(db, batch, comment, groups);
        }
    }

    public void archiveComment(Database db, XLink comment, Collection<Group> groups) {
        this.archiveComment(db, null, comment, groups);
    }

    public void unarchiveComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.unarchiveComment(db, batch, comment, groups);
        }
    }

    public void unarchiveComment(Database db, XLink comment, Collection<Group> groups) {
        this.unarchiveComment(db, null, comment, groups);
    }

    public void deleteComment(Database db, @Nullable ChangesBatch batch, Long commentId, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteComment(db, batch, commentId, groups);
        }
    }

    public void deleteComment(Database db, Long commentId, Collection<Group> groups) {
        this.deleteComment(db, null, commentId, groups);
    }

    public void modifyComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyComment(db, batch, comment, groups);
        }
    }

    public void modifyComment(Database db, XLink comment, Collection<Group> groups) {
        this.modifyComment(db, null, comment, groups);
    }

    public void createURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.createURI(db, batch, uri, groups);
        }
    }

    public void createURI(Database db, URI uri, Collection<Group> groups) {
        this.createURI(db, null, uri, groups);
    }

    public void archiveURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.archiveURI(db, batch, uri, groups);
        }
    }

    public void archiveURI(Database db, URI uri, Collection<Group> groups) {
        this.archiveURI(db, null, uri, groups);
    }

    public void modifyURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyURI(db, batch, uri, groups);
        }
    }

    public void modifyURI(Database db, URI uri, Collection<Group> groups) {
        this.modifyURI(db, null, uri, groups);
    }

    public void modifyURI(Database db, @Nullable ChangesBatch batch, URI uri, Group group) {
        this.modifyURI(db, batch, uri, Collections.singleton(group));
    }

    public void modifyURI(Database db, @Nullable ChangesBatch batch, URI uri) throws QueryFailedException {
        this.modifyURI(db, batch, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
    }

    public void deleteURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        if (URIRule.isFolder(uri)) {
            this.deleteFolder(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), groups);
        } else if (URIs.isExternal((URI)uri)) {
            this.deleteURL(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), groups);
        } else {
            this.deleteDocument(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), groups);
        }
    }

    public void deleteDocument(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteDocument(db, batch, uriid, docid, path, groups);
        }
    }

    public void deleteDocument(Database db, Long uriid, String docid, String path, Collection<Group> groups) {
        this.deleteDocument(db, null, uriid, docid, path, groups);
    }

    public void deleteFolder(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteFolder(db, batch, uriid, docid, path, groups);
        }
    }

    public void deleteFolder(Database db, Long uriid, String docid, String path, Collection<Group> groups) {
        this.deleteFolder(db, null, uriid, docid, path, groups);
    }

    public void deleteURL(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteURL(db, batch, uriid, docid, path, groups);
        }
    }

    public void deleteURL(Database db, Long uriid, String docid, String path, Collection<Group> groups) {
        this.deleteURL(db, null, uriid, docid, path, groups);
    }

    public void createPublication(Database db, ChangesBatch batch, Publication pub, Collection<URI> added) {
        for (ChangesListener listener : LISTENERS) {
            listener.createPublication(db, batch, pub, added);
        }
    }

    public void modifyPublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> added, Collection<URI> modified, Collection<URI> removed, Collection<Long> deletedUriids) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyPublication(db, batch, pub, added, modified, removed, deletedUriids);
        }
    }

    public void deletePublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> removed) {
        for (ChangesListener listener : LISTENERS) {
            listener.deletePublication(db, batch, pub, removed);
        }
    }

    public void createGroupfolder(Database db, @Nullable ChangesBatch batch, GroupURI groupFolder, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.createGroupfolder(db, batch, groupFolder, groups);
        }
    }

    public void createGroupfolder(Database db, GroupURI groupFolder, Group group) {
        this.createGroupfolder(db, null, groupFolder, Collections.singleton(group));
    }

    public void createGroupfolder(Database db, GroupURI groupFolder, Collection<Group> groups) {
        this.createGroupfolder(db, null, groupFolder, groups);
    }

    public void modifyGroupfolder(Database db, @Nullable ChangesBatch batch, GroupURI groupFolder, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.modifyGroupfolder(db, batch, groupFolder, groups);
        }
    }

    public void modifyGroupfolder(Database db, GroupURI groupFolder, Collection<Group> groups) {
        this.modifyGroupfolder(db, null, groupFolder, groups);
    }

    public void deleteGroupfolder(Database db, @Nullable ChangesBatch batch, Long guriid, String path, Collection<Group> groups) {
        for (ChangesListener listener : LISTENERS) {
            listener.deleteGroupfolder(db, batch, guriid, path, groups);
        }
    }

    public void deleteGroupfolder(Database db, Long guriid, String path, Collection<Group> groups) {
        this.deleteGroupfolder(db, null, guriid, path, groups);
    }
}

