/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.schematron.OutputOptions;
import org.pageseeder.schematron.svrl.SVRL;
import org.pageseeder.schematron.xml.XMLStreamWriterWrapper;

public class SVRLStreamWriter
extends XMLStreamWriterWrapper {
    private static final QName TEXT = new QName("http://purl.oclc.org/dsdl/svrl", "text");
    private static final QName OUTPUT = new QName("http://purl.oclc.org/dsdl/svrl", "schematron-output");
    private static final QName METADATA = new QName("http://purl.oclc.org/dsdl/svrl", "metadata");
    private final Deque<QName> elements = new ArrayDeque<QName>();
    private final OutputOptions options;
    private int assertsCount = 0;
    private int reportsCount = 0;
    private Set<String> globalNamespaces = new HashSet<String>();
    private Set<String> metadataNamespaces = new HashSet<String>();

    public SVRLStreamWriter(Writer out) throws XMLStreamException {
        this(out, OutputOptions.defaults());
    }

    public SVRLStreamWriter(Writer out, OutputOptions options) throws XMLStreamException {
        super(SVRLStreamWriter.newXMLStreamWriter(out));
        this.options = options;
    }

    private static XMLStreamWriter newXMLStreamWriter(Writer out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        return factory.createXMLStreamWriter(out);
    }

    public OutputOptions getOptions() {
        return this.options;
    }

    public int getAssertsCount() {
        return this.assertsCount;
    }

    public int getReportsCount() {
        return this.reportsCount;
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if ("location".equals(localName) && this.options.usePrefixInLocation()) {
            NamespaceContext context = this.getNamespaceContext();
            super.writeAttribute(localName, SVRL.toLocationPrefix(value, context));
        } else {
            super.writeAttribute(localName, value);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.elements.push(new QName(localName));
        this.indentIfRequired();
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.elements.push(new QName(namespaceURI, localName));
        this.indentIfRequired();
        if (this.isSvrlElement(namespaceURI) && "failed-assert".equals(localName)) {
            ++this.assertsCount;
        }
        if (this.isSvrlElement(namespaceURI) && "successful-report".equals(localName)) {
            ++this.reportsCount;
        }
        if (this.isEmptySvrlElement(namespaceURI, localName)) {
            super.writeEmptyElement(localName, namespaceURI);
        } else {
            super.writeStartElement(localName, namespaceURI);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.elements.push(new QName(namespaceURI, localName, prefix));
        this.indentIfRequired();
        if (this.isSvrlElement(namespaceURI) && "failed-assert".equals(localName)) {
            ++this.assertsCount;
        }
        if (this.isSvrlElement(namespaceURI) && "successful-report".equals(localName)) {
            ++this.reportsCount;
        }
        if (this.isEmptySvrlElement(namespaceURI, localName)) {
            super.writeEmptyElement(prefix, localName, namespaceURI);
        } else {
            super.writeStartElement(prefix, localName, namespaceURI);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.indentIfRequired();
        super.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.indentIfRequired();
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.indentIfRequired();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        QName name = this.elements.pop();
        if (!this.isEmptySvrlElement(name.getNamespaceURI(), name.getLocalPart())) {
            if (this.options.isIndent() && this.isSvrlElement(name.getNamespaceURI()) && !this.elements.contains(TEXT) && !TEXT.equals(name)) {
                super.writeCharacters("\n");
                for (int i = 0; i < this.elements.size(); ++i) {
                    super.writeCharacters("  ");
                }
            }
            super.writeEndElement();
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        super.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        super.writeCharacters(text, start, len);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (this.options.isOmitXmlDeclaration()) {
            return;
        }
        super.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        if (this.options.isOmitXmlDeclaration()) {
            return;
        }
        super.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.options.isOmitXmlDeclaration()) {
            return;
        }
        super.writeStartDocument(encoding, version);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (namespaceURI.startsWith("https://doi.org/10.5281/zenodo.1495494")) {
            return;
        }
        boolean declare = true;
        if (OUTPUT.equals(this.elements.peek())) {
            this.globalNamespaces.add(namespaceURI);
            declare = !"http://purl.oclc.org/dsdl/schematron".equals(namespaceURI) && !"http://www.w3.org/2001/XMLSchema".equals(namespaceURI);
        } else if (METADATA.equals(this.elements.peek())) {
            this.metadataNamespaces.add(namespaceURI);
            declare = !this.globalNamespaces.contains(namespaceURI);
        } else if (this.elements.contains(METADATA)) {
            declare = !this.metadataNamespaces.contains(namespaceURI) && !this.globalNamespaces.contains(namespaceURI);
        } else {
            boolean bl = declare = !this.globalNamespaces.contains(namespaceURI);
        }
        if (declare) {
            this.writer.writeNamespace(prefix, namespaceURI);
        }
    }

    private boolean isSvrlElement(String namespaceURI) {
        return "http://purl.oclc.org/dsdl/svrl".equals(namespaceURI);
    }

    private boolean isEmptySvrlElement(String namespaceURI, String localName) {
        return this.isSvrlElement(namespaceURI) && ("ns-prefix-in-attribute-values".equals(localName) || "active-pattern".equals(localName) || "fired-rule".equals(localName));
    }

    private void indentIfRequired() throws XMLStreamException {
        if (this.options.isIndent() && this.elements.size() > 1 && (!this.elements.contains(TEXT) || TEXT.equals(this.elements.peek()))) {
            super.writeCharacters("\n");
            for (int i = 0; i < this.elements.size() - 1; ++i) {
                super.writeCharacters("  ");
            }
        }
    }
}

