/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.pageseeder.schematron.svrl.ActivePattern;
import org.pageseeder.schematron.svrl.AssertOrReport;
import org.pageseeder.schematron.svrl.DiagnosticReference;
import org.pageseeder.schematron.svrl.FiredRule;
import org.pageseeder.schematron.svrl.HumanText;
import org.pageseeder.schematron.svrl.Namespace;
import org.pageseeder.schematron.svrl.PropertyReference;
import org.pageseeder.schematron.svrl.SchematronOutput;

final class SVRLEventHandler {
    private static final QName TEXT = new QName("http://purl.oclc.org/dsdl/svrl", "text");
    private SchematronOutput schematronOutput;
    private ActivePattern currentActivePattern;
    private FiredRule currentFiredRule;
    private AssertOrReport currentAssertOrReport;
    private DiagnosticReference currentDiagnosticReference;
    private PropertyReference currentPropertyReference;
    private HumanText currentHumanText;
    private final Set<String> namespaces = new HashSet<String>();

    SVRLEventHandler() {
    }

    public SchematronOutput parse(XMLEventReader eventReader) throws XMLStreamException {
        this.namespaces.add("http://purl.oclc.org/dsdl/svrl");
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            this.handle(event);
        }
        this.schematronOutput.addNsDeclaration(new Namespace("svrl", "http://purl.oclc.org/dsdl/svrl"));
        return this.schematronOutput;
    }

    private void handle(XMLEvent event) {
        QName name;
        EndElement endElement;
        QName name2;
        if (event.getEventType() == 1) {
            StartElement startElement = event.asStartElement();
            QName name3 = startElement.getName();
            if ("http://purl.oclc.org/dsdl/svrl".equals(name3.getNamespaceURI())) {
                switch (name3.getLocalPart()) {
                    case "schematron-output": {
                        this.handleSchematronOutput(startElement);
                        break;
                    }
                    case "ns-prefix-in-attribute-values": {
                        this.handleNsPrefixInAttributeValues(startElement);
                        break;
                    }
                    case "active-pattern": {
                        this.handleActivePattern(startElement);
                        break;
                    }
                    case "fired-rule": {
                        this.handleFiredRule(startElement);
                        break;
                    }
                    case "failed-assert": 
                    case "successful-report": {
                        this.handleAssertOrReport(startElement);
                        break;
                    }
                    case "diagnostic-reference": {
                        this.handleDiagnosticReference(startElement);
                        break;
                    }
                    case "property-reference": {
                        this.handlePropertyReference(startElement);
                        break;
                    }
                    case "text": {
                        this.handleHumanText(startElement);
                        break;
                    }
                }
            }
        } else if (event.getEventType() == 2 && "http://purl.oclc.org/dsdl/svrl".equals((name2 = (endElement = event.asEndElement()).getName()).getNamespaceURI())) {
            switch (name2.getLocalPart()) {
                case "failed-assert": 
                case "successful-report": {
                    this.currentAssertOrReport = null;
                    break;
                }
                case "diagnostic-reference": {
                    this.currentDiagnosticReference = null;
                    break;
                }
                case "property-reference": {
                    this.currentPropertyReference = null;
                    break;
                }
                case "text": {
                    if (this.currentDiagnosticReference != null) {
                        this.currentDiagnosticReference.setText(this.currentHumanText);
                    } else if (this.currentPropertyReference != null) {
                        this.currentPropertyReference.setText(this.currentHumanText);
                    } else if (this.currentAssertOrReport != null) {
                        this.currentAssertOrReport.setText(this.currentHumanText);
                    } else {
                        this.schematronOutput.addText(this.currentHumanText);
                    }
                    this.currentHumanText = null;
                    break;
                }
            }
        }
        if (this.currentHumanText != null && !TEXT.equals(name = SVRLEventHandler.getName(event))) {
            this.currentHumanText.addContent(event);
            if (event.isStartElement()) {
                this.checkNamespaces(event.asStartElement());
            }
        }
    }

    private void handleSchematronOutput(StartElement startElement) {
        this.schematronOutput = new SchematronOutput();
        String title = SVRLEventHandler.getAttributeValue(startElement, "title");
        String phase = SVRLEventHandler.getAttributeValue(startElement, "phase");
        String schemaVersion = SVRLEventHandler.getAttributeValue(startElement, "schemaVersion");
        if (title != null) {
            this.schematronOutput.setTitle(title);
        }
        if (phase != null) {
            this.schematronOutput.setPhase(phase);
        }
        if (schemaVersion != null) {
            this.schematronOutput.setSchemaVersion(schemaVersion);
        }
    }

    private void handleActivePattern(StartElement startElement) {
        ActivePattern activePattern = new ActivePattern();
        String id = SVRLEventHandler.getAttributeValue(startElement, "id");
        String name = SVRLEventHandler.getAttributeValue(startElement, "name");
        String documents = SVRLEventHandler.getAttributeValue(startElement, "documents");
        String role = SVRLEventHandler.getAttributeValue(startElement, "role");
        if (id != null) {
            activePattern.setId(id);
        }
        if (name != null) {
            activePattern.setName(name);
        }
        if (documents != null) {
            activePattern.setDocuments(documents);
        }
        if (role != null) {
            activePattern.setDocuments(role);
        }
        this.schematronOutput.addActivePattern(activePattern);
        this.currentActivePattern = activePattern;
    }

    private void handleAssertOrReport(StartElement startElement) {
        AssertOrReport assertOrReport = new AssertOrReport();
        assertOrReport.setFailedAssert("failed-assert".equals(startElement.getName().getLocalPart()));
        String id = SVRLEventHandler.getAttributeValue(startElement, "id");
        String location = SVRLEventHandler.getAttributeValue(startElement, "location");
        String test = SVRLEventHandler.getAttributeValue(startElement, "test");
        String role = SVRLEventHandler.getAttributeValue(startElement, "role");
        String flag = SVRLEventHandler.getAttributeValue(startElement, "flag");
        if (id != null) {
            assertOrReport.setId(id);
        }
        if (location != null) {
            assertOrReport.setLocation(location);
        }
        if (test != null) {
            assertOrReport.setTest(test);
        }
        if (role != null) {
            assertOrReport.setRole(role);
        }
        if (flag != null) {
            assertOrReport.setFlag(flag);
        }
        if (this.currentActivePattern == null) {
            this.currentActivePattern = new ActivePattern();
            this.schematronOutput.addActivePattern(this.currentActivePattern);
            this.schematronOutput.setCompact(true);
        }
        if (this.currentFiredRule == null) {
            this.currentFiredRule = new FiredRule();
            this.currentActivePattern.addFiredRule(this.currentFiredRule);
        }
        this.currentFiredRule.addAssertOrReport(assertOrReport);
        this.currentAssertOrReport = assertOrReport;
    }

    private void handleDiagnosticReference(StartElement startElement) {
        DiagnosticReference diagnosticReference = new DiagnosticReference();
        String diagnostic = SVRLEventHandler.getAttributeValue(startElement, "diagnostic");
        if (diagnostic != null) {
            diagnosticReference.setDiagnostic(diagnostic);
        }
        this.currentAssertOrReport.addDiagnosticReference(diagnosticReference);
        this.currentDiagnosticReference = diagnosticReference;
    }

    private void handleFiredRule(StartElement startElement) {
        FiredRule firedRule = new FiredRule();
        String id = SVRLEventHandler.getAttributeValue(startElement, "id");
        String name = SVRLEventHandler.getAttributeValue(startElement, "name");
        String context = SVRLEventHandler.getAttributeValue(startElement, "context");
        String role = SVRLEventHandler.getAttributeValue(startElement, "role");
        String flag = SVRLEventHandler.getAttributeValue(startElement, "flag");
        if (id != null) {
            firedRule.setId(id);
        }
        if (name != null) {
            firedRule.setName(name);
        }
        if (context != null) {
            firedRule.setContext(context);
        }
        if (role != null) {
            firedRule.setRole(role);
        }
        if (flag != null) {
            firedRule.setFlag(flag);
        }
        this.currentActivePattern.addFiredRule(firedRule);
        this.currentFiredRule = firedRule;
    }

    private void handlePropertyReference(StartElement startElement) {
        PropertyReference propertyReference = new PropertyReference();
        String property = SVRLEventHandler.getAttributeValue(startElement, "property");
        String role = SVRLEventHandler.getAttributeValue(startElement, "role");
        String scheme = SVRLEventHandler.getAttributeValue(startElement, "scheme");
        if (property != null) {
            propertyReference.setProperty(property);
        }
        if (role != null) {
            propertyReference.setRole(role);
        }
        if (scheme != null) {
            propertyReference.setScheme(scheme);
        }
        this.currentAssertOrReport.addPropertyReference(propertyReference);
        this.currentPropertyReference = propertyReference;
    }

    private void handleNsPrefixInAttributeValues(StartElement startElement) {
        String prefix = SVRLEventHandler.getAttributeValue(startElement, "prefix");
        String uri = SVRLEventHandler.getAttributeValue(startElement, "uri");
        Namespace ns = new Namespace(prefix, uri);
        this.schematronOutput.addNsPrefixInAttributeValues(ns);
    }

    private void handleHumanText(StartElement startElement) {
        HumanText humanText = new HumanText();
        String space = SVRLEventHandler.getAttributeValue(startElement, "xml:space");
        String lang = SVRLEventHandler.getAttributeValue(startElement, "xml:lang");
        String see = SVRLEventHandler.getAttributeValue(startElement, "see");
        String icon = SVRLEventHandler.getAttributeValue(startElement, "icon");
        String fpi = SVRLEventHandler.getAttributeValue(startElement, "fpi");
        if (space != null) {
            humanText.setSpace(space);
        }
        if (lang != null) {
            humanText.setLang(lang);
        }
        if (see != null) {
            humanText.setLang(see);
        }
        if (icon != null) {
            humanText.setIcon(icon);
        }
        if (fpi != null) {
            humanText.setFpi(fpi);
        }
        this.currentHumanText = humanText;
    }

    private void checkNamespaces(StartElement startElement) {
        if (this.hasValue(startElement.getName().getNamespaceURI()) && !this.namespaces.contains(startElement.getName().getNamespaceURI())) {
            this.namespaces.add(startElement.getName().getNamespaceURI());
            this.schematronOutput.addNsDeclaration(new Namespace(startElement.getName()));
        }
        Iterator<Attribute> i = startElement.getAttributes();
        while (i.hasNext()) {
            Attribute att = i.next();
            if (!this.hasValue(att.getName().getNamespaceURI()) || this.namespaces.contains(att.getName().getNamespaceURI())) continue;
            this.namespaces.add(att.getName().getNamespaceURI());
            this.schematronOutput.addNsDeclaration(new Namespace(att.getName()));
        }
    }

    boolean hasValue(String s) {
        return s != null && s.length() > 0;
    }

    private static String getAttributeValue(StartElement startElement, String name) {
        Attribute att = startElement.getAttributeByName(new QName(name));
        return att != null ? att.getValue() : null;
    }

    private static QName getName(XMLEvent event) {
        if (event.isStartElement()) {
            return event.asStartElement().getName();
        }
        if (event.isEndElement()) {
            return event.asEndElement().getName();
        }
        return null;
    }
}

