/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Objects;
import org.pageseeder.schematron.svrl.SVRLData;

public final class SVRLDataFile
implements SVRLData {
    private final File _svrl;
    private final Charset _charset;

    public SVRLDataFile(File svrl, Charset charset) {
        this._svrl = Objects.requireNonNull(svrl);
        this._charset = Objects.requireNonNull(charset);
    }

    @Override
    public String asString() {
        return new String(this.asByteArray(), this._charset);
    }

    @Override
    public byte[] asByteArray() {
        try {
            return Files.readAllBytes(this._svrl.toPath());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(this._svrl), this._charset);
    }
}

