/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.pageseeder.schematron.xml.XMLStreamable;

public class HumanText
implements XMLStreamable {
    private String space;
    private String lang;
    private String see;
    private String icon;
    private String fpi;
    private final List<XMLEvent> richText = new ArrayList<XMLEvent>();

    public String getSpace() {
        return this.space;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSee() {
        return this.see;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getFpi() {
        return this.fpi;
    }

    public String toPlainText() {
        StringBuilder out = new StringBuilder();
        for (XMLEvent event : this.richText) {
            if (!event.isCharacters()) continue;
            out.append(event.asCharacters().getData());
        }
        return out.toString();
    }

    void setSpace(String space) {
        this.space = space;
    }

    void setLang(String lang) {
        this.lang = lang;
    }

    void setSee(String see) {
        this.see = see;
    }

    void setIcon(String icon) {
        this.icon = icon;
    }

    void setFpi(String fpi) {
        this.fpi = fpi;
    }

    void addContent(XMLEvent event) {
        this.richText.add(event);
    }

    @Override
    public void toXMLStream(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("svrl", "text", "http://purl.oclc.org/dsdl/svrl");
        if (this.space != null) {
            xml.writeAttribute("xml:space", this.space);
        }
        if (this.lang != null) {
            xml.writeAttribute("xml:lang", this.lang);
        }
        if (this.see != null) {
            xml.writeAttribute("see", this.see);
        }
        if (this.icon != null) {
            xml.writeAttribute("icon", this.icon);
        }
        if (this.fpi != null) {
            xml.writeAttribute("fpi", this.fpi);
        }
        List<XMLEvent> text = this.richText;
        int textSize = text.size();
        for (int i = 0; i < textSize; ++i) {
            XMLEvent event = text.get(i);
            if (event.isStartElement()) {
                if (i < textSize - 1 && text.get(i + 1).isEndElement()) {
                    this.writeEmptyElement(xml, event.asStartElement());
                    ++i;
                    continue;
                }
                this.writeStartElement(xml, event.asStartElement());
                continue;
            }
            if (event.isCharacters()) {
                xml.writeCharacters(event.asCharacters().getData());
                continue;
            }
            if (!event.isEndElement()) continue;
            xml.writeEndElement();
        }
        xml.writeEndElement();
    }

    private void writeEmptyElement(XMLStreamWriter xml, StartElement start) throws XMLStreamException {
        QName name = start.getName();
        if (name.getPrefix() != null) {
            xml.writeEmptyElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        } else if (name.getNamespaceURI() != null) {
            xml.writeEmptyElement(name.getNamespaceURI(), name.getLocalPart());
        } else {
            xml.writeEmptyElement(name.getLocalPart());
        }
        Iterator<Attribute> it = start.getAttributes();
        while (it.hasNext()) {
            this.writeAttribute(xml, it.next());
        }
    }

    private void writeStartElement(XMLStreamWriter xml, StartElement start) throws XMLStreamException {
        QName name = start.getName();
        if (name.getPrefix() != null) {
            xml.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        } else if (name.getNamespaceURI() != null) {
            xml.writeStartElement(name.getNamespaceURI(), name.getLocalPart());
        } else {
            xml.writeStartElement(name.getLocalPart());
        }
        Iterator<Attribute> it = start.getAttributes();
        while (it.hasNext()) {
            this.writeAttribute(xml, it.next());
        }
    }

    private void writeAttribute(XMLStreamWriter xml, Attribute attribute) throws XMLStreamException {
        QName name = attribute.getName();
        if (name.getPrefix() != null) {
            xml.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), attribute.getValue());
        } else if (name.getNamespaceURI() != null) {
            xml.writeAttribute(name.getNamespaceURI(), name.getLocalPart(), attribute.getValue());
        } else {
            xml.writeAttribute(name.getLocalPart(), attribute.getValue());
        }
    }
}

