/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.xref;

import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.url.URLCreator;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.xref.XRefException;
import com.pageseeder.xref.XRefHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class XRefMediator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XRefMediator.class);
    private final Group group;
    private final URI uri;
    private final Member author;
    private final Database database;
    private final Date creationDate;
    private final List<XRef> xrefsList = new ArrayList<XRef>();
    private boolean createEdit = true;
    private boolean failOnFirstError = false;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private int nbOfXrefsCreated = 0;
    private boolean includeUnresolvedXRefs = true;
    private String fragmentNewContent = null;
    private boolean buildStructure = false;
    private String structureXML = null;

    public XRefMediator(Group grp, URI u, Member authorXl, Date creationdate, Database db) {
        this.group = grp;
        this.author = authorXl;
        this.database = db;
        this.uri = u;
        this.creationDate = creationdate == null ? new Date() : creationdate;
    }

    public void setFailOnFirstError(boolean failOnFirstErr) {
        this.failOnFirstError = failOnFirstErr;
    }

    public void setBuildStructure(boolean build) {
        this.buildStructure = build;
    }

    public void setCreateEdit(boolean createedit) {
        this.createEdit = createedit;
    }

    public void setIncludeUnresolvedXRefs(boolean includeUnresolved) {
        this.includeUnresolvedXRefs = includeUnresolved;
    }

    public List<XRef> getXrefsList() {
        return this.xrefsList;
    }

    public String getNewFragmentContent() {
        return this.fragmentNewContent;
    }

    public String getStructureXML() {
        return this.structureXML;
    }

    public void mediateFragment(InputStream content, Locator loc) throws XRefException {
        this.loadXRefsFromContent(content, loc.getFragment());
        this.markXRefs(this.group, loc);
        this.parseAndCreateXRefs(this.group);
        this.xrefsList.clear();
        if (!this.errors.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Errors found while parsing XRefs:");
            for (String err : this.errors) {
                LOGGER.debug(err);
            }
        }
    }

    public void mediateNewDocument(InputStream content) throws XRefException {
        this.loadXRefsFromContent(content, null);
        for (Locator loc : this.uri.getLocatorsCol()) {
            this.markXRefs(this.group, loc);
        }
        this.parseAndCreateXRefs(this.group);
        this.xrefsList.clear();
        if (!this.errors.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Errors found while parsing XRefs:");
            for (String err : this.errors) {
                LOGGER.debug(err);
            }
        }
    }

    public List<String> getErrorsAndWarnings() {
        ArrayList<String> eaw = new ArrayList<String>(this.errors);
        eaw.addAll(this.warnings);
        return eaw;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public int getNbOfXrefsCreated() {
        return this.nbOfXrefsCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadXRefsFromContent(InputStream content, String frag) throws XRefException {
        XRefHandler xrefHandler = new XRefHandler(this.uri, this.buildStructure);
        xrefHandler.setIncludeUnresolvedXRefs(this.includeUnresolvedXRefs);
        if (frag != null) {
            xrefHandler.setOnlyFragment(frag);
        }
        try {
            xrefHandler.parse(content);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse the XML contents", (Throwable)e);
            if (this.failOnFirstError) {
                throw new XRefException("Failed to load XRef: " + e.getMessage(), null);
            }
            this.errors.add("Failed to load XRef: " + e.getMessage());
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.error("Failed to parse the XML contents", (Throwable)e);
            if (this.failOnFirstError) {
                throw new XRefException("Failed to parse the XML: " + e.getMessage(), null);
            }
            this.errors.add("Failed to load XRef: " + e.getMessage());
        }
        finally {
            try {
                content.close();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close the XML contents stream", (Throwable)ex);
            }
        }
        if (xrefHandler.getErrors() != null) {
            this.errors.addAll(xrefHandler.getErrors());
        }
        if (!this.errors.isEmpty() && this.failOnFirstError) {
            throw new XRefException("Could not load Cross references", this.errors);
        }
        if (this.buildStructure) {
            this.structureXML = xrefHandler.getStructureXML();
        }
        UserDetails userdetails = new UserDetailsManager().get(this.database, this.author.getId(), false);
        boolean urlsOwner = PermissionManager.check((Long)this.author.getId(), (UserDetails)userdetails, (Database)this.database, (Permissions)new Permissions(), (PermissionCheck)new EditAllURLsCheck());
        String basePath = this.uri.getPath();
        basePath = basePath.substring(0, basePath.lastIndexOf(47));
        Iterator<String> fragments = xrefHandler.getFragments();
        while (fragments.hasNext()) {
            String fragment = fragments.next();
            boolean xrefWasUpdated = false;
            Iterator<XRef> xrefs = xrefHandler.getXRefs(fragment);
            boolean hasXRefs = xrefs.hasNext();
            while (xrefs.hasNext()) {
                XRef xr = xrefs.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found following xref in fragment {}:\n{}", (Object)fragment, (Object)xr.toString());
                }
                this.xrefsList.add(xr);
                xr.retrieveTarget(this.database, this.uri.getScheme(), this.uri.getHost().getName(), this.uri.getPort(), basePath, (URLCreator)new com.pageseeder.url.URLCreator(this.author, urlsOwner));
                String message = xr.getWarning();
                if (message != null) {
                    if (xr.getTargetURI() == null) {
                        String href = (xr.getTargetHref() == null ? "" : xr.getTargetHref().toLowerCase()) + (String)(xr.getTargetFragment() == null || "default".equals(xr.getTargetFragment()) ? "" : "#" + xr.getTargetFragment());
                        if (!xr.isLink() || !href.startsWith("mailto:") && !href.startsWith("#")) {
                            this.errors.add(message);
                        }
                        this.xrefsList.remove(xr);
                    } else {
                        this.warnings.add(message);
                    }
                }
                if (!xr.wasModified()) continue;
                xrefWasUpdated = true;
            }
            String string = this.fragmentNewContent = hasXRefs ? xrefHandler.getContents(fragment).toString() : null;
            if (!this.createEdit || !xrefWasUpdated && (!"default".equals(fragment) || frag != null)) continue;
            String newContents = this.fragmentNewContent == null ? xrefHandler.getContents(fragment).toString() : this.fragmentNewContent;
            LOGGER.debug("Edit needs to be created for fragment {} with content: {}", (Object)fragment, (Object)newContents);
            try {
                XLinkRule.createEditXLink((URI)this.uri, (String)fragment, (String)"Document XRef Change", (String)"Documentation", null, (boolean)false, (Group)this.group, null, null, (String)newContents, (String)"application/vnd.pageseeder.psml+xml", (Member)this.author, null, null, null, (Date)this.creationDate, (Database)this.database);
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to create Edit: {}", (Object)e.getMessage());
                if (this.failOnFirstError) {
                    throw new XRefException("Failed to create Edit: " + e.getMessage(), null);
                }
                this.errors.add(e.getMessage());
            }
        }
    }

    private void markXRefs(Group xgroup, Locator loc) {
        if (loc == null) {
            return;
        }
        Predicate pred = Predicates.predicateXLinkForLocatorRoleContains((Database)this.database, (String[])new String[]{"xref-source"});
        pred.addPredicate(Predicates.predicateXLinkForLocatorByGroupStatusContentRoleLike((Database)this.database, (Long)xgroup.getId(), (String)"Documentation-Old", (boolean)false, (String[])new String[]{"XRef%"}));
        Iterator xlfs = loc.getXLinksForLocator((Object)pred);
        while (xlfs.hasNext()) {
            LocatorForXLink lfx = (LocatorForXLink)xlfs.next();
            XRef xRef = new XRef(lfx.getXLink());
            xRef.setAdd(true);
            int xlinkfoundindex = this.xrefsList.indexOf(xRef);
            if (xlinkfoundindex != -1) {
                XRef xl_embed = this.xrefsList.get(xlinkfoundindex);
                xl_embed.setAdd(false);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("XRef exists in content and database: {}", (Object)xRef.toString());
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("XRef exists in database but not content: {}", (Object)xRef.toString());
            }
            xRef.setDel(true);
            xRef.setAdd(false);
            this.xrefsList.add(xRef);
        }
    }

    private void parseAndCreateXRefs(Group xgroup) throws XRefException {
        Date changedDate = new Date(this.creationDate.getTime());
        for (XRef tempXRef : this.xrefsList) {
            if (tempXRef.getAdd()) {
                try {
                    Long uid = tempXRef.getUriid();
                    URI target_uri = uid == null ? null : DatabaseQuery.getURIById((Database)this.database, (Long)uid);
                    if (target_uri == null) continue;
                    String contentrole = tempXRef.getDisplay() != null && !"".equals(tempXRef.getDisplay()) ? "XRef-" + tempXRef.getDisplay() : "XRef";
                    XLink xl = XLinkRule.createXRefXLink((Group)xgroup, (String)contentrole, (String)tempXRef.getTitle(), (Member)this.author, (String[])tempXRef.getLabels(), (String)tempXRef.getType(), (boolean)tempXRef.getReverseLink(), (String)tempXRef.getReverseTitle(), (String)tempXRef.getReverseType(), (URI)this.uri, (String)tempXRef.getSourceFragment(), (URI)target_uri, (String)tempXRef.getTargetFragment(), (Date)this.creationDate, (Database)this.database);
                    ++this.nbOfXrefsCreated;
                    if (tempXRef.getLevel() != null) {
                        ObjectProperties.setXLinkProperty((XLink)xl, (String)"level", Collections.singletonList(tempXRef.getLevel()));
                    }
                    if (tempXRef.getConfig() != null) {
                        ObjectProperties.setXLinkProperty((XLink)xl, (String)"config", Collections.singletonList(tempXRef.getConfig()));
                    }
                    if (tempXRef.getReverseLink() && tempXRef.getTargetURI() != null) {
                        tempXRef.getTargetURI().setLastModified(changedDate);
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("New XRef has been added: XLinkId={}\n{}", (Object)xl.getId(), (Object)tempXRef.toString());
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to create XRef: {}", (Object)e.getMessage());
                    if (this.failOnFirstError) {
                        throw new XRefException("Failed to create Cross-Reference: " + e.getMessage(), null);
                    }
                    this.errors.add(e.getMessage());
                }
                continue;
            }
            if (!tempXRef.getDel()) continue;
            XLink temp_xl = tempXRef.getXLink();
            temp_xl.setStatus("Documentation-Old");
            temp_xl.setStatusChangedDate(changedDate);
            if (tempXRef.getReverseLink() && tempXRef.getTargetURI() != null) {
                tempXRef.getTargetURI().setLastModified(changedDate);
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Removed XRef: XLinkId={}\n{}", (Object)temp_xl.getId(), (Object)tempXRef.toString());
        }
    }
}

