/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.util.Collection;

@Requires(group=true, database=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListGroupVersions
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group group = req.getGroup();
        assert (group != null);
        Collection versions = DatabaseQuery.getUniqueReleaseTitlesByGroup((Database)req.getDatabase(), (Group)group);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("versions");
        out.startCollection("versions", OutputPrinter.CollectionOption.JSON_ONLY);
        for (String version : versions) {
            out.startObject("version");
            out.field("name", version);
            out.endObject();
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

