/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.version;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class CreateVersionThread
extends ProcessThread {
    private static final int MAX_VERSION_NOTIFICATION_PSML = 20;
    private final Version version;
    private int total = 0;
    private int current = 0;
    private final @Nullable Long uriid;
    private final List<Long> uriids = new ArrayList<Long>();

    public CreateVersionThread(String username, Group group, @Nullable URI uri, Version v) {
        super(username, "Creating version for " + (String)(uri == null ? "batch" : "folder " + uri.getDisplayTitle()), group);
        this.uriid = uri == null ? null : uri.getId();
        this.version = v;
    }

    public void addURI(Long id) {
        this.uriids.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.fail("Failed to open database: " + ex.getMessage());
            this.complete("");
            return;
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing documents to process");
        Transaction tr = new Transaction(db);
        boolean withWarnings = false;
        int nbcreated = 0;
        try {
            String batchName;
            Collection<URI> uris;
            Group wgroup;
            Member author;
            tr.begin();
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            Member member = author = this.version.authorid == null ? null : DatabaseQuery.getMemberById((Database)db, (Long)this.version.authorid);
            if (author == null) {
                this.fail("Version has no valid author.");
                return;
            }
            Group group2 = wgroup = this.version.groupid == null ? null : DatabaseQuery.getGroupById((Database)db, (Long)this.version.groupid);
            if (wgroup == null) {
                this.fail("Version has no valid group.");
                return;
            }
            if (this.uriid != null) {
                URI folder = DatabaseQuery.getURIById((Database)db, (Long)this.uriid);
                if (folder == null || !"folder".equals(folder.getType())) {
                    this.fail("URI " + this.uriid + " is not a valid folder URI.");
                    return;
                }
                uris = DatabaseQuery.getURIsBySchemeHostPortSubpath((Database)db, (String)folder.getScheme(), (String)folder.getHost().getName(), (Integer)folder.getPort(), (String)(folder.getPath() + "/"), (boolean)false);
                batchName = "Bulk version on folder " + folder.getDecodedPath();
            } else if (!this.uriids.isEmpty()) {
                uris = new ArrayList();
                for (Long id : this.uriids) {
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)id);
                    if (!"folder".equals(uri.getType())) {
                        uris.add(uri);
                        continue;
                    }
                    this.updateStatus(ProcessStage.Status.WARNING, "Ignoring URI " + id + " as it is a folder");
                }
                batchName = "Bulk version on batch with " + this.uriids.size() + " documents";
            } else {
                this.fail("No objects to create version!");
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + uris.size() + " documents.");
            XLink pubXLink = null;
            if (this.version.publicationid != null && !uris.isEmpty()) {
                Publication publication = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)this.version.publicationid, (Host)((URI)uris.iterator().next()).getHost());
                pubXLink = publication == null ? null : DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId());
            }
            int maxPSML = GlobalSettings.getInt((String)"maxVersionNotifications", (int)20);
            if (uris.size() > maxPSML && this.version.notify != Notify.SILENT) {
                this.version.notify = Notify.SILENT;
                this.updateStatus(ProcessStage.Status.WARNING, "The notify parameter will be ignored as there were more than " + maxPSML + " versions to create.");
                withWarnings = true;
            }
            this.total = uris.size() * 2;
            this.current = 0;
            HashMap<Long, Long> created = new HashMap<Long, Long>();
            for (URI psml : uris) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Creating version for URI " + psml.getDecodedPath());
                XLink xl = null;
                try {
                    xl = XLinkRule.createVersionXLink((Database)db, (URI)psml, (String)this.version.version, (XLink)pubXLink, (Member)author, (Date)this.version.createdate, (String[])this.version.labels, (String)this.version.content, (Group)wgroup, (Notify)this.version.notify, null);
                }
                catch (EmailException ex) {
                    this.updateStatus(ProcessStage.Status.WARNING, "The version has been added, however it could not be emailed to other group members. Error: " + ex.getMessage());
                    withWarnings = true;
                }
                catch (FoundationException ex) {
                    this.updateStatus(ProcessStage.Status.ERROR, RuleUtils.defaultValue((String)ex.getMessage(), (String)"Failed to create version"));
                    withWarnings = true;
                }
                if (xl != null) {
                    created.put(psml.getId(), xl.getId());
                } else {
                    withWarnings = true;
                    this.updateStatus(ProcessStage.Status.ERROR, "Failed to create version");
                }
                if (this.wasCancelled()) {
                    tr.abort();
                    return;
                }
                if (this.current++ % 1000 != 0) continue;
                tr.commitAndStart();
            }
            nbcreated = created.size();
            if (this.wasCancelled()) {
                tr.abort();
                return;
            }
            tr.commitAndStart();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Adding documents to index queue.");
            ChangesManager changes = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch(batchName);
            changes.startBatch(db, batch);
            for (Map.Entry xlinkByUriid : created.entrySet()) {
                URI psml = DatabaseQuery.getURIById((Database)db, (Long)((Long)xlinkByUriid.getKey()));
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)((Long)xlinkByUriid.getValue()));
                Collection gps = GroupRule.getEditGroups((Database)db, (Group)group, (URI)psml);
                changes.createVersion(db, batch, psml, xl, gps);
                ++this.current;
            }
            changes.completeBatch(db, batch);
            tr.commit();
            this.current = this.total;
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            tr.abort();
        }
        catch (DatabaseException e) {
            this.fail("Failed to communicate with database: " + e.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            db = null;
            Object msg = nbcreated == 0 ? "No versions were created" : (nbcreated == 1 ? "1 version was successfully created" : nbcreated + " versions were successfully created - they will be available after indexing is completed");
            if (withWarnings) {
                this.fail((String)msg + " and there were some warnings and/or errors, see process logs for more details.");
            }
            this.complete((String)msg + ".");
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.total);
        out.field("current", (long)this.current);
        out.endObject();
    }

    public static final class Version {
        private final String version;
        private final @Nullable Long authorid;
        private Date createdate;
        private String[] labels;
        private final boolean isReviewer;
        private final @Nullable Long groupid;
        private final String content;
        private Notify notify;
        private final @Nullable String publicationid;

        public Version(String v, Member a, Date cd, boolean isr, Group grp, String c, String[] l, Notify n, String p) {
            this.authorid = a.getId();
            this.createdate = cd;
            this.notify = n;
            this.isReviewer = isr;
            this.content = c;
            this.groupid = grp.getId();
            this.labels = l;
            this.version = v;
            this.publicationid = p;
        }
    }
}

