/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.validation;

import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.FastKey;
import com.pageseeder.common.util.KeyQuad;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class Validators {
    private Validators() {
    }

    public static @Nullable File findSchema(Group group, URI uri, String filename) {
        String owner = group.getOwnerDirectory();
        String ext = PSML.getFileExtension(uri);
        String type = URIRule.getStyleConfig((URI)uri);
        if ("psml".equals(ext) && Strings.isEmpty((String)type)) {
            type = "default";
        }
        return Validators.findSchema(new SchemaID(owner, ext, type, filename));
    }

    public static @Nullable File findSchema(Group group, String extension, String type, String filename) {
        String owner = group.getOwnerDirectory();
        return Validators.findSchema(new SchemaID(owner, extension, type, filename));
    }

    public static @Nullable File findDefaultSchema(Group group, URI uri) {
        File webapp = new File(Settings.getContextPath());
        File template = new File(webapp, "WEB-INF/config/template");
        String owner = group.getOwnerDirectory();
        String config = URIRule.getStyleConfig((URI)uri);
        String ext = PSML.getFileExtension(uri);
        boolean external = URIs.isExternal((URI)uri);
        List<File> dirs = Validators.listSchemaDirs(template, owner, ext, config, external, false);
        for (File dir : dirs) {
            File defaultSchema = new File(dir, "default.sch");
            if (!defaultSchema.exists()) continue;
            return defaultSchema;
        }
        return null;
    }

    public static List<File> listSchemaDir(@Nullable URI uri, String owner, boolean def) {
        File webapp = new File(Settings.getContextPath());
        File template = new File(webapp, "WEB-INF/config/template");
        String type = URIRule.getStyleConfig((URI)uri);
        String ext = null;
        if (uri != null && !"folder".equals(uri.getType())) {
            ext = PSML.getFileExtension(uri);
        }
        boolean external = URIs.isExternal((URI)uri);
        return Validators.listSchemaDirs(template, owner, ext, type, external, def);
    }

    public static @Nullable File findSchema(SchemaID key) {
        String extension = RuleUtils.replaceNonFolderChars((String)key.extension());
        Template template = new Template(extension.isEmpty() ? GlobalSettings.getGlobalTemplate((String)"default") : key.ownerDir());
        TemplateFiles resources = new TemplateFiles(template);
        String name = RuleUtils.replaceNonFilenameChars((String)key.name());
        File found = null;
        if ("psml".equals(extension)) {
            String psmlDocumentType = RuleUtils.replaceNonFolderChars((String)key.type());
            if (psmlDocumentType != null && (found = resources.findFile("/psml/" + psmlDocumentType + "/" + name)) != null) {
                return found;
            }
            found = resources.findFile("/document/psml/" + name);
        } else if ("".equals(extension)) {
            String urlType = RuleUtils.replaceNonFolderChars((String)key.type());
            if (urlType != null && (found = resources.findFile("/url/" + urlType + "/" + name)) != null) {
                return found;
            }
            found = resources.findFile("/url/default/" + name);
        } else {
            found = resources.findFile("/document/" + extension + "/" + name);
        }
        if (found == null) {
            found = resources.findFile("/document/default/" + name);
        }
        return found;
    }

    private static List<File> listSchemaDirs(File template, String owner, @Nullable String extension, @Nullable String type, boolean external, boolean def) {
        String folder;
        boolean hasExtension;
        File deftemplate = new File(template.getParentFile().getParentFile(), "template");
        extension = RuleUtils.replaceNonFolderChars((String)extension);
        if (type == null && "psml".equals(extension)) {
            type = "default";
        }
        type = RuleUtils.replaceNonFolderChars((String)type);
        ArrayList<File> directories = new ArrayList<File>();
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        boolean hasType = !Strings.isEmpty((String)type);
        boolean bl = hasExtension = !Strings.isEmpty((String)extension);
        if (external) {
            if (hasType) {
                String folder2 = Validators.toURLFolder(type);
                if (globalTemplate != null) {
                    directories.add(new File(template, globalTemplate + folder2));
                }
                if (def) {
                    directories.add(new File(deftemplate, "default" + folder2));
                }
            }
            String defaultFolder = Validators.toURLFolder("default");
            if (globalTemplate != null) {
                directories.add(new File(template, globalTemplate + defaultFolder));
            }
            if (def) {
                directories.add(new File(deftemplate, "default" + defaultFolder));
            }
            return directories;
        }
        if (hasType) {
            folder = Validators.toPSMLFolder(type);
            if (owner != null) {
                directories.add(new File(template, owner + folder));
            }
            if (globalTemplate != null) {
                directories.add(new File(template, globalTemplate + folder));
            }
            if (def) {
                directories.add(new File(deftemplate, "default" + folder));
            }
        }
        if (hasExtension) {
            folder = Validators.toDocumentFolder(extension);
            if (owner != null) {
                directories.add(new File(template, owner + folder));
            }
            if (globalTemplate != null) {
                directories.add(new File(template, globalTemplate + folder));
            }
            if (def) {
                directories.add(new File(deftemplate, "default" + folder));
            }
            String defaultFolder = Validators.toDocumentFolder("default");
            if (owner != null) {
                directories.add(new File(template, owner + defaultFolder));
            }
            if (globalTemplate != null) {
                directories.add(new File(template, globalTemplate + defaultFolder));
            }
            if (def) {
                directories.add(new File(deftemplate, "default" + defaultFolder));
            }
        }
        if (!hasType && !hasExtension) {
            folder = "/psml";
            if (owner != null) {
                directories.addAll(Validators.listAllDirs(new File(template, owner + folder)));
            }
            if (globalTemplate != null) {
                directories.addAll(Validators.listAllDirs(new File(template, globalTemplate + folder)));
            }
            if (def) {
                directories.addAll(Validators.listAllDirs(new File(deftemplate, "default" + folder)));
            }
            folder = "/document";
            if (owner != null) {
                directories.addAll(Validators.listAllDirs(new File(template, owner + folder)));
            }
            if (globalTemplate != null) {
                directories.addAll(Validators.listAllDirs(new File(template, globalTemplate + folder)));
            }
            if (def) {
                directories.addAll(Validators.listAllDirs(new File(deftemplate, "default" + folder)));
            }
            folder = "/url";
            if (globalTemplate != null) {
                directories.addAll(Validators.listAllDirs(new File(template, globalTemplate + folder)));
            }
            if (def) {
                directories.addAll(Validators.listAllDirs(new File(deftemplate, "default" + folder)));
            }
        }
        return directories;
    }

    private static List<File> listAllDirs(File base) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (base.exists() && base.isDirectory()) {
            File[] files;
            for (File file : files = base.listFiles()) {
                if (!file.isDirectory()) continue;
                dirs.add(file);
            }
        }
        return dirs;
    }

    private static String toPSMLFolder(String type) {
        return "/psml/" + type;
    }

    private static String toURLFolder(String type) {
        return "/url/" + type;
    }

    private static String toDocumentFolder(String extension) {
        return "/document/" + extension;
    }

    public static final class SchemaID
    implements FastKey {
        private final KeyQuad<String, String, String, String> quad;

        public SchemaID(String ownerDir, String extension, String type, String filename) {
            this.quad = new KeyQuad((Object)ownerDir, (Object)extension, (Object)type, (Object)filename);
        }

        public String ownerDir() {
            return (String)this.quad.first();
        }

        public String extension() {
            return (String)this.quad.second();
        }

        public String type() {
            return (String)this.quad.third();
        }

        public String name() {
            return (String)this.quad.fourth();
        }

        public int hashCode() {
            return this.quad.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaID)) {
                return false;
            }
            if (o.hashCode() != this.hashCode()) {
                return false;
            }
            return this.quad.equals(((SchemaID)o).quad);
        }
    }
}

