/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.utils.DynamicStrings;
import com.pageseeder.utils.FilenameTransform;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLFileCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLFileCreator.class);
    private static final Pattern AUTO_INCREMENT = Pattern.compile(".*?\\{.{0,50}?([NPQKYMDW].{0,50}?)\\}.*?");
    private String folderContext = null;
    private String folderPath = null;
    private String folderPathTransform = "charfolding,lowercase,underscore,trim";
    private boolean filenameSpecified = false;
    private String filenameValue = "{$ui.title}";
    private String filenameTransform = "charfolding,lowercase,underscore,trim";
    private boolean filenameEditable = true;
    private String documentTitle = null;
    private String documentDocid = null;
    private String publicationId = null;
    private String publicationType = null;
    private String documentDescription = null;
    private String parentFolderScheme = null;
    private String parentFolderHostName = null;
    private Long parentFolderHostId = null;
    private Integer parentFolderPort = null;
    private String parentFolderPath = null;
    private static final int MAX_COUNTER_INFINITE_LOOP = 20;

    private PSMLFileCreator() {
    }

    public String getDocumentID() {
        return this.documentDocid;
    }

    public String getPublicationId() {
        return this.publicationId;
    }

    public String getPublicationType() {
        return this.publicationType;
    }

    public String getDocumentDescription() {
        return this.documentDescription;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public String getFolderContext() {
        return this.folderContext;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public static PSMLFileCreator buildDefaultCreator() {
        return new PSMLFileCreator();
    }

    public boolean isFilenameSpecified() {
        return this.filenameSpecified;
    }

    public boolean isFilenameEditable() {
        return this.filenameEditable;
    }

    public String getFilenameTransform() {
        return this.filenameTransform;
    }

    public String getFilenameValue() {
        return this.filenameValue;
    }

    public boolean hasAutoIncrementNumbering() {
        Object fp;
        Object object = fp = this.folderPath != null ? this.folderPath : "";
        if (this.filenameValue != null) {
            fp = (String)fp + "/" + this.filenameValue;
        }
        return AUTO_INCREMENT.matcher((CharSequence)fp).matches();
    }

    public boolean hasAutoIncrementDocID() {
        if (this.documentDocid == null) {
            return false;
        }
        return AUTO_INCREMENT.matcher(this.documentDocid).matches();
    }

    public boolean hasAutoIncrementPublicationID() {
        if (this.publicationId == null) {
            return false;
        }
        return AUTO_INCREMENT.matcher(this.publicationId).matches();
    }

    public int computeAutoNumbering(URI target, String format, Map<String, String> parameters, Date date, Database db) throws ParseException, DatabaseException {
        boolean existingURI;
        this.parentFolderHostName = target.getHost().getName();
        this.parentFolderHostId = target.getHost().getId();
        this.parentFolderPath = target.getPath();
        this.parentFolderPort = target.getPort();
        this.parentFolderScheme = target.getScheme();
        int nb = PSMLFileCreator.getAutonumbering(target, format, db);
        if (nb > 0 && !(existingURI = this.hasURI(nb + 1, format, parameters, date, db))) {
            return nb + 1;
        }
        nb = DatabaseQuery.getURICountBySchemeHostPortPathLike((Database)db, (String)this.parentFolderScheme, (String)this.parentFolderHostName, (Integer)this.parentFolderPort, (String)(this.parentFolderPath + "/%"), (String)("psml-" + format + "-"));
        return this.findRange(nb, format, parameters, date, db);
    }

    private int findRange(int start, String format, Map<String, String> parameters, Date date, Database db) throws ParseException, DatabaseException {
        int counter = 0;
        int nb = start;
        int lastFailed = start;
        while (true) {
            boolean existingURI;
            if (!(existingURI = this.hasURI(nb = (int)((double)nb + Math.pow(2.0, counter)), format, parameters, date, db))) {
                if (counter == 0) {
                    return nb;
                }
                return this.binarySearch(lastFailed + 1, nb, format, parameters, date, db);
            }
            if (counter == 20) {
                LOGGER.error("Infinite loop when computing auto numbering for {} in {}!", (Object)format, (Object)this.parentFolderPath);
                throw new IllegalStateException("Infinite loop when computing auto numbering for " + format + " in " + this.parentFolderPath + "!");
            }
            lastFailed = nb;
            ++counter;
        }
    }

    private int binarySearch(int start, int end, String format, Map<String, String> parameters, Date date, Database db) throws ParseException, DatabaseException {
        if (start == end) {
            return start;
        }
        if (start + 1 == end) {
            return !this.hasURI(start, format, parameters, date, db) ? start : end;
        }
        int middle = (start + end) / 2;
        boolean existingURI = this.hasURI(middle, format, parameters, date, db);
        if (!existingURI) {
            return this.binarySearch(start, middle, format, parameters, date, db);
        }
        return this.binarySearch(middle + 1, end, format, parameters, date, db);
    }

    private boolean hasURI(int nb, String format, Map<String, String> parameters, Date date, Database db) throws ParseException, DatabaseException {
        if (this.hasAutoIncrementNumbering()) {
            String docid;
            URI turi;
            String fullpath;
            int count;
            Object folderpath = this.folderPath;
            if (folderpath != null && !((String)folderpath).isEmpty()) {
                if (((String)folderpath).charAt(((String)folderpath).length() - 1) != '/') {
                    folderpath = (String)folderpath + "/";
                }
                if (((String)folderpath).charAt(0) != '/') {
                    folderpath = "/" + (String)folderpath;
                }
                folderpath = DynamicStrings.toSQLLike((String)folderpath, nb, this.folderPathTransform, true);
            } else {
                folderpath = "/";
            }
            Object filename = "%";
            if (this.filenameValue != null) {
                filename = DynamicStrings.toSQLLike(this.filenameValue, nb, this.filenameTransform, false);
            }
            if ((count = DatabaseQuery.getURICountBySchemeHostPortPathLike((Database)db, (String)this.parentFolderScheme, (String)this.parentFolderHostName, (Integer)this.parentFolderPort, (String)(fullpath = this.parentFolderPath + (String)folderpath + (String)(filename = (String)filename + ".psml")), (String)("psml-" + format + "-"))) == 0 && this.documentDocid != null && (turi = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)this.parentFolderHostName, (String)(docid = DynamicStrings.process(this.documentDocid, parameters, nb, date)))) != null) {
                count = 1;
            }
            if (count > 0) {
                return true;
            }
        }
        if (this.hasAutoIncrementDocID()) {
            String docid = DynamicStrings.process(this.documentDocid, parameters, nb, date);
            URI uri = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)this.parentFolderHostName, (String)docid);
            return uri != null;
        }
        if (this.hasAutoIncrementPublicationID()) {
            String pubid = DynamicStrings.process(this.publicationId, parameters, nb, date);
            Publication pub = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)pubid, (Long)this.parentFolderHostId);
            return pub != null;
        }
        return false;
    }

    public File computeDestinationFile(int nb, String dadPath, String userFilename, Map<String, String> parameters, Date today) throws ParseException {
        Object filename;
        Object folderpath = this.folderPath;
        if (folderpath != null && !((String)folderpath).isEmpty()) {
            if (((String)folderpath).charAt(((String)folderpath).length() - 1) != '/') {
                folderpath = (String)folderpath + "/";
            }
            folderpath = DynamicStrings.process((String)folderpath, parameters, nb, today);
            folderpath = FilenameTransform.transformPath((String)folderpath, this.folderPathTransform == null ? "" : this.folderPathTransform);
        } else {
            folderpath = "";
        }
        if (this.filenameSpecified || !this.filenameEditable) {
            filename = DynamicStrings.process(this.filenameValue, parameters, nb, today);
            filename = FilenameTransform.transform((String)filename, this.filenameTransform == null ? "" : this.filenameTransform);
        } else {
            filename = userFilename;
            filename = RuleUtils.replaceNonFilenameChars((String)filename);
        }
        if (!((String)filename).endsWith(".psml")) {
            filename = (String)filename + ".psml";
        }
        return new File(dadPath, RuleUtils.replaceNonFolderCharsKeepSlashes((String)folderpath) + (String)filename);
    }

    public static int getAutonumbering(URI uri, String format, Database db) {
        if (uri == null || format == null) {
            return -1;
        }
        List values = URIRule.getURIPropertyValues((URI)uri, (Database)db, (String)("ps-counter-" + format));
        if (values == null || values.isEmpty()) {
            return -1;
        }
        return Integer.parseInt((String)values.iterator().next());
    }

    public static void setAutonumbering(URI uri, String format, int number, Member author, Database db) throws DatabaseException {
        if (uri == null || format == null) {
            return;
        }
        XLink xl = URIRule.getURIXLink((URI)uri, null, (Database)db);
        if (xl == null) {
            URIRule.addURIHistoryXLink((URI)uri, (Member)author, (Date)uri.getDateCreated(), null, null, (Database)db);
        }
        URIRule.setURIProperty((URI)uri, (Database)db, (String)("ps-counter-" + format), Collections.singletonList(String.valueOf(number)));
    }

    public @Nullable String retrieveFolderContext(String parentPath, String groupname) {
        if (Strings.isEmpty((String)this.folderContext)) {
            return parentPath;
        }
        if (this.folderContext.indexOf(42) == -1) {
            if (this.folderContext.charAt(0) == '/') {
                return GlobalSettings.getSitePrefix() + "/" + groupname.replace('-', '/') + this.folderContext;
            }
            int position = parentPath.indexOf(this.folderContext);
            if (position == -1) {
                return null;
            }
            return parentPath.substring(0, position + this.folderContext.length());
        }
        if (this.folderContext.charAt(0) == '/') {
            String[] destinationElements;
            String context = GlobalSettings.getSitePrefix() + "/" + groupname.replace('-', '/') + this.folderContext;
            String[] contextElements = context.split("/");
            if (contextElements.length > (destinationElements = parentPath.split("/")).length) {
                return null;
            }
            Object finalpath = "";
            for (int i = 0; i < destinationElements.length; ++i) {
                if (i >= contextElements.length) {
                    return finalpath;
                }
                if (!destinationElements[i].equals(contextElements[i]) && !"*".equals(contextElements[i])) {
                    return null;
                }
                if (i <= 0) continue;
                finalpath = (String)finalpath + "/" + destinationElements[i];
            }
            return finalpath;
        }
        String[] contextElements = this.folderContext.split("/");
        String[] destinationElements = parentPath.split("/");
        int matchingIndex = -1;
        int contextIndex = -1;
        for (int destinationIndex = destinationElements.length - 1; destinationIndex >= 0; --destinationIndex) {
            if (contextIndex >= 0 && !destinationElements[destinationIndex].equals(contextElements[contextIndex]) && !"*".equals(contextElements[contextIndex])) {
                contextIndex = -1;
            }
            if (contextIndex < 0 && (destinationElements[destinationIndex].equals(contextElements[contextElements.length - 1]) || "*".equals(contextElements[contextElements.length - 1]))) {
                contextIndex = contextElements.length - 1;
            }
            if (contextIndex == 0) {
                matchingIndex = destinationIndex + contextElements.length - 1;
                break;
            }
            if (contextIndex < 0) continue;
            --contextIndex;
        }
        if (matchingIndex == -1) {
            return null;
        }
        Object matchingPath = "";
        for (int i = 1; i <= matchingIndex; ++i) {
            matchingPath = (String)matchingPath + "/" + destinationElements[i];
        }
        return matchingPath;
    }

    public static PSMLFileCreator buildCreator(String documentConfig) throws FoundationException {
        if (Strings.isEmpty((String)documentConfig)) {
            return PSMLFileCreator.buildDefaultCreator();
        }
        DocumentConfigParser parser = new DocumentConfigParser();
        XMLHelpers.parse((InputStream)new ByteArrayInputStream(documentConfig.getBytes(StandardCharsets.UTF_8)), (ContentHandler)parser);
        return parser.getCreator();
    }

    private static class DocumentConfigParser
    extends DefaultHandler {
        private boolean inCreation = false;
        private PSMLFileCreator creator = null;

        private DocumentConfigParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("creation".equals(localName)) {
                this.inCreation = true;
                this.creator = new PSMLFileCreator();
            } else if (this.inCreation && this.creator != null) {
                if ("folder".equals(localName)) {
                    this.creator.folderContext = attributes.getValue("context");
                    this.creator.folderPath = attributes.getValue("path");
                    String t = attributes.getValue("transform");
                    if (t != null) {
                        this.creator.folderPathTransform = t;
                    }
                } else if ("document".equals(localName)) {
                    this.creator.documentDocid = attributes.getValue("docid");
                    this.creator.documentTitle = attributes.getValue("title");
                    this.creator.documentDescription = attributes.getValue("description");
                    this.creator.publicationId = attributes.getValue("publicationid");
                    this.creator.publicationType = attributes.getValue("publicationtype");
                } else if ("filename".equals(localName)) {
                    String e;
                    String v;
                    String t = attributes.getValue("transform");
                    if (t != null) {
                        this.creator.filenameTransform = t;
                    }
                    boolean bl = this.creator.filenameSpecified = (v = attributes.getValue("value")) != null;
                    if (v != null) {
                        this.creator.filenameValue = v;
                    }
                    if ((e = attributes.getValue("editable")) != null) {
                        this.creator.filenameEditable = "true".equals(e);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("creation".equals(localName)) {
                this.inCreation = false;
            }
        }

        public PSMLFileCreator getCreator() {
            return this.creator;
        }
    }
}

