/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.utils;

import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.util.Strings;

public enum FilenameTransform {
    CHARFOLDING{

        @Override
        public String transform(String in) {
            return Strings.removeDiacritics((String)in);
        }
    }
    ,
    LOWERCASE{

        @Override
        public String transform(String in) {
            if (in == null) {
                return null;
            }
            return in.toLowerCase();
        }
    }
    ,
    UPPERCASE{

        @Override
        public String transform(String in) {
            if (in == null) {
                return null;
            }
            return in.toUpperCase();
        }
    }
    ,
    UNDERSCORE{

        @Override
        public String transform(String in) {
            return RuleUtils.toValidFilename((String)in.replace(' ', '_'), (char)'_');
        }
    }
    ,
    HYPHEN{

        @Override
        public String transform(String in) {
            return RuleUtils.toValidFilename((String)in.replace(' ', '-'), (char)'-');
        }
    }
    ,
    TRIM{

        @Override
        public String transform(String in) {
            char last;
            char first;
            if (in == null || in.isEmpty()) {
                return in;
            }
            StringBuilder out = new StringBuilder(in);
            while (out.length() > 0 && ((first = out.charAt(0)) == '-' || first == '_' || first == ' ')) {
                out.delete(0, 1);
            }
            while (out.length() > 0 && ((last = out.charAt(out.length() - 1)) == '-' || last == '_' || last == ' ')) {
                out.setLength(out.length() - 1);
            }
            return out.toString();
        }
    };


    public abstract String transform(String var1);

    public static String transform(String in, String transforms) {
        String[] transform = Strings.split((String)transforms.toUpperCase(), (char)',');
        String out = in;
        for (String t : transform) {
            FilenameTransform ft;
            if (t.isEmpty() || (ft = FilenameTransform.valueOf(t)) == null) continue;
            out = ft.transform(out);
        }
        out = RuleUtils.toValidFilename((String)out, (char)'_');
        return out;
    }

    public static String transformPath(String path, String transforms) {
        StringBuilder transformed = new StringBuilder();
        String[] elements = path.split("((?<=/)|(?=/))");
        boolean ignoreNextIfSlash = false;
        for (String element : elements) {
            if ("/".equals(element)) {
                if (!ignoreNextIfSlash) {
                    transformed.append('/');
                }
                ignoreNextIfSlash = true;
                continue;
            }
            transformed.append(FilenameTransform.transform(element, transforms));
            ignoreNextIfSlash = false;
        }
        return transformed.toString();
    }
}

