/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.url;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.inspect.PSMLFileInspector;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.url.URLFiles;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.developer.PSMLMetadataHandler;
import com.pageseeder.load.edits.Fragment;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.url.URLMetadata;
import com.pageseeder.url.URLMetadataExtractor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.Processor;
import org.pageseeder.psml.template.TemplateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class URLResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLResolver.class);
    private static final String METADATA_FRAGMENT = "default";
    private final boolean overwriteProperties;
    private final boolean fallbackOnExternal;
    private final List<String> propertiesToUpdate = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public URLResolver() {
        this(false, false, null);
    }

    public URLResolver(boolean overwriteProps, boolean fallbackOnExternal, @Nullable List<String> propsToUpdate) {
        this.overwriteProperties = overwriteProps;
        this.fallbackOnExternal = fallbackOnExternal;
        if (propsToUpdate != null) {
            this.propertiesToUpdate.addAll(propsToUpdate);
        }
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void clearWarnings() {
        this.warnings.clear();
    }

    public boolean resolve(URI uri, Member author, Database db) throws FoundationException {
        return this.resolve(uri, null, author, db);
    }

    public boolean resolve(URI uri, @Nullable URLMetadata external, Member author, Database db) throws FoundationException {
        URLMetadata externalData = external;
        ByteArrayOutputStream metadata = new ByteArrayOutputStream();
        try (ByteArrayOutputStream byteArrayOutputStream = metadata;){
            externalData = this.generateURLMetadata(uri, external, metadata);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] processedTemplate = metadata.toByteArray();
        boolean uriPropertiesUpdated = this.overwriteProperties && this.editURIProperties(uri, author, processedTemplate, externalData, db);
        boolean metadataUpdated = false;
        if (processedTemplate.length > 0) {
            String newContent;
            String psml = new String(processedTemplate, StandardCharsets.UTF_8);
            int start = psml.indexOf("<metadata>");
            int end = psml.indexOf("</metadata>", start);
            if (start != -1 && end != -1 && !(newContent = psml.substring(start, end + 11).trim()).isEmpty()) {
                metadataUpdated = this.editMetadata(uri, author, newContent, db);
            }
        }
        if (metadataUpdated || uriPropertiesUpdated) {
            uri.setLastModified(new Date());
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable URLMetadata generateURLMetadata(URI uri, @Nullable URLMetadata external, OutputStream metadata) throws FoundationException {
        boolean bl;
        Reader in;
        String urltype = URIRule.getStyleConfig((URI)uri);
        File urlTemplate = URLFiles.findURLTemplate((String)urltype);
        if (urlTemplate == null) {
            return external;
        }
        HashMap<Object, String> params = new HashMap<Object, String>();
        long now = System.currentTimeMillis();
        params.put("ps.currentdate", ISO8601.format((long)now, (ISO8601)ISO8601.CALENDAR_DATE));
        params.put("ps.currentdatetime", ISO8601.format((long)now, (ISO8601)ISO8601.DATETIME));
        params.put("ps.currenttime", ISO8601.format((long)now, (ISO8601)ISO8601.TIME));
        URLMetadata externalData = external;
        if (externalData != null) {
            try {
                in = new FileReader(urlTemplate);
            }
            catch (FileNotFoundException ex) {
                LOGGER.error("Failed to load URL template file for {} (type {}): {}", new Object[]{uri.getId(), urltype, ex.getLocalizedMessage(), ex});
                throw new FoundationException("Failed to load URL template for URL " + uri.getId());
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Files.copy((File)urlTemplate, (OutputStream)stream);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to read URL template file for {} (type {}): {}", new Object[]{uri.getId(), urltype, ex.getLocalizedMessage(), ex});
            throw new FoundationException("Failed to read URL template for URL " + uri.getId());
        }
        String urlTemplateContent = new String(stream.toByteArray(), StandardCharsets.UTF_8);
        boolean bl2 = bl = urlTemplateContent.contains("name=\"meta.") || urlTemplateContent.contains("{$meta.");
        if (bl) {
            externalData = URLMetadataExtractor.extractNoHostCheck(URIs.getURIString((URI)uri));
        }
        in = new StringReader(urlTemplateContent);
        if (externalData != null) {
            Map<String, String> data = externalData.getData();
            for (Map.Entry entry : data.entrySet()) {
                params.put("meta." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        Processor processor = new Processor(StandardCharsets.UTF_8);
        processor.setFailOnError(true);
        try (PrintWriter output = new PrintWriter(new OutputStreamWriter(metadata, StandardCharsets.UTF_8));){
            processor.process(new InputSource(in), output, params);
        }
        catch (IOException | TemplateException ex) {
            try {
                LOGGER.error("Failed to create metadata URL for {} (type {}): {}", new Object[]{uri.getId(), urltype, ex.getLocalizedMessage(), ex});
                throw new FoundationException("Failed to create metadata for URL " + uri.getId());
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    LOGGER.warn("Failed to close stream for URL template for {} (type {}): {}", new Object[]{uri.getId(), urltype, ex2.getLocalizedMessage(), ex2});
                }
                throw throwable;
            }
        }
        try {
            in.close();
            return externalData;
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to close stream for URL template for {} (type {}): {}", new Object[]{uri.getId(), urltype, ex.getLocalizedMessage(), ex});
            return externalData;
        }
    }

    private boolean editMetadata(URI uri, Member author, String newContent, Database db) throws FoundationException {
        boolean updated;
        FragmentEditor editor;
        String n;
        PSMLMetadataHandler newContentHandler;
        PSMLMetadataHandler existingContentHandler;
        try {
            existingContentHandler = new PSMLMetadataHandler();
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), null);
            resolver.setFragment(METADATA_FRAGMENT);
            resolver.setFragmentInfo(true);
            resolver.setPSMLFormat(true);
            existingContentHandler.parse(resolver.getContent(db));
        }
        catch (URIException | IOException | SAXException ex) {
            throw new FoundationException("Failed to read the existing metadata for URL " + uri.getId());
        }
        Map<String, String> existingProperties = existingContentHandler.getProperties();
        for (String propName : this.propertiesToUpdate) {
            existingProperties.remove(propName);
        }
        try {
            newContentHandler = new PSMLMetadataHandler();
            newContentHandler.setExistingProperties(existingProperties);
            newContentHandler.parse(new ByteArrayInputStream(newContent.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | SAXException ex) {
            throw new FoundationException("Failed to read the existing metadata for URL " + uri.getId());
        }
        Fragment newOne = newContentHandler.getFragment();
        Fragment oldOne = existingContentHandler.getFragment();
        String o = oldOne == null || oldOne.isDeleted() || oldOne.getComparisonContents() == null ? null : oldOne.getComparisonContents().toString().trim();
        String string = n = newOne == null || newOne.isDeleted() || newOne.getComparisonContents() == null ? null : newOne.getComparisonContents().toString().trim();
        if (n == null && o == null) {
            return false;
        }
        if (n != null && o != null && n.length() == o.length() && o.equals(n)) {
            try {
                XLink lastEdit = DatabaseQuery.getXLinkByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter((Database)db, (URI)uri, (Group)GroupRule.getPublicGroup((Database)db), (String)METADATA_FRAGMENT, (boolean)true, (boolean)false, (boolean)true, null, null, null);
                if (lastEdit != null) {
                    lastEdit.setModifiedDate(new Date());
                }
            }
            catch (DatabaseException ex) {
                throw new FoundationException("Failed to load last edit of metadata fragment for URL " + uri.getId() + ": " + ex.getLocalizedMessage());
            }
            return false;
        }
        if (newOne == null) {
            LOGGER.warn("Failed to create URL metadata for URL {}", (Object)uri.getId());
            this.warnings.add("Failed to create URL metadata for URL");
            return false;
        }
        try {
            editor = new FragmentEditor(uri, METADATA_FRAGMENT, author, GroupRule.getPublicGroup((Database)db));
            editor.edit(db, newOne.getContents().toString(), "application/vnd.pageseeder.psml+xml", "properties-fragment", null, false);
            XLink edit = editor.getCreatedEdit();
            if (edit != null) {
                edit.setModifiedDate(new Date());
            }
        }
        catch (DatabaseException | IOException ex) {
            throw new FoundationException("Failed to edit metadata fragment for URL " + uri.getId() + ": " + ex.getLocalizedMessage());
        }
        FragmentEditor.Status status = editor.getStatus();
        boolean bl = updated = status == FragmentEditor.Status.OK;
        if (!updated && status != FragmentEditor.Status.NOT_MODIFIED) {
            this.warnings.add("Failed to edit metadata fragment for URL " + uri.getId() + ", status was " + status.name());
        }
        return updated;
    }

    private boolean editURIProperties(URI uri, Member author, byte[] processedTemplate, @Nullable URLMetadata external, Database db) throws FoundationException {
        String newDescription;
        String newTitle;
        Map attributes;
        if (processedTemplate.length == 0) {
            attributes = Collections.emptyMap();
        } else {
            try (ByteArrayInputStream in = new ByteArrayInputStream(processedTemplate);){
                attributes = PSMLFileInspector.inspect((InputStream)in);
            }
            catch (IOException ex) {
                throw new FoundationException("Failed to load new metadata for URI " + uri.getId(), (Throwable)ex);
            }
        }
        URLMetadata externalData = external;
        boolean changedURIMetadata = false;
        String labels = (String)attributes.get("labels");
        if (labels != null) {
            String[] newLabels;
            String[] existingLabels = Labels.getLabels((URI)uri);
            String[] stringArray = newLabels = labels.isEmpty() ? null : Labels.toArray((String)labels);
            if (newLabels != null && existingLabels == null || newLabels == null && existingLabels != null || newLabels.length != existingLabels.length || Labels.labelsAreDifferent((String[])existingLabels, (String[])newLabels)) {
                Labels.setLabels((URI)uri, (String[])newLabels);
                changedURIMetadata = true;
            }
        }
        if ((newTitle = (String)attributes.get("title")) == null && this.fallbackOnExternal) {
            if (externalData == null) {
                externalData = URLMetadataExtractor.extract(URIs.getURIString((URI)uri), db);
            }
            newTitle = externalData.getTitle();
        }
        if (newTitle != null) {
            boolean newTitleSpecified;
            if (newTitle.length() > 250) {
                newTitle = newTitle.substring(0, 250);
            }
            boolean oldTitleSpecified = !Strings.isEmpty((String)uri.getUserTitle());
            boolean bl = newTitleSpecified = !Strings.isEmpty((String)newTitle);
            if (newTitleSpecified && !oldTitleSpecified || !newTitleSpecified && oldTitleSpecified || newTitleSpecified && !newTitle.equals(uri.getUserTitle())) {
                uri.setUserTitle(newTitle);
                changedURIMetadata = true;
            }
        }
        if ((newDescription = (String)attributes.get("description")) == null && this.fallbackOnExternal) {
            if (externalData == null) {
                externalData = URLMetadataExtractor.extractNoHostCheck(URIs.getURIString((URI)uri));
            }
            newDescription = externalData.getDescription();
        }
        if (newDescription != null) {
            boolean newDescriptionSpecified;
            boolean oldDescriptionSpecified = !Strings.isEmpty((String)uri.getDescription());
            boolean bl = newDescriptionSpecified = !Strings.isEmpty((String)newDescription);
            if (newDescriptionSpecified && !oldDescriptionSpecified || !newDescriptionSpecified && oldDescriptionSpecified || newDescriptionSpecified && !newDescription.equals(uri.getDescription())) {
                uri.setDescription(newDescription);
                changedURIMetadata = true;
            }
        }
        if (changedURIMetadata) {
            try {
                URIRule.addURIHistoryXLink((URI)uri, (Member)author, (Date)uri.getDateCreated(), null, null, (Database)db);
            }
            catch (DatabaseException ex) {
                throw new FoundationException("Failed to add an history event: " + ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return changedURIMetadata;
    }
}

