/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.MultipleCheck;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.ValidateThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true, parameters={"schema", "publicationid"})
@PublicAPI
public final class ValidatePublication
implements Generator,
MultipleCheck {
    public List<PermissionCheck> getPermissionChecks(GeneratorRequest req) {
        Group group = req.getGroup();
        ArrayList<PermissionCheck> checks = new ArrayList<PermissionCheck>();
        checks.add((PermissionCheck)new ViewMemberCheck(req.getMember()));
        checks.add((PermissionCheck)new EditURICheck(group));
        if (req.getParameter((Parameter)StandardParameters.shared, false)) {
            checks.add((PermissionCheck)new EditGroupCheck(group));
        }
        return checks;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Database db = req.getDatabase();
        Member member = req.getMember();
        Group group = req.getGroup();
        assert (group != null && member != null);
        if (GroupRule.isProject((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, group.getName() + " is a project");
            return;
        }
        String schematron = req.getParameter((Parameter)StandardParameters.schema);
        assert (schematron != null);
        boolean shared = req.getParameter((Parameter)StandardParameters.shared, false);
        if (!schematron.endsWith(".sch")) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Schema must end with .sch");
            return;
        }
        String pubid = req.getParameter((Parameter)StandardParameters.publicationid);
        assert (pubid != null);
        Publication pub = Publications.getPublicationByPublicationIDGroup((Database)db, (String)pubid, (Group)group);
        if (pub == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Publication not found with ID: " + pubid);
        }
        XLink pubXlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        ValidateThread thread = ValidateThread.newInstance(member.getUsername(), group, schematron);
        thread.setFailuresOnly(req.getParameter((Parameter)StandardParameters.failuresonly, false));
        thread.setReportAttribute("publicationid", pubid);
        thread.setReportAttribute("publication-title", pub.getTitle());
        thread.setReportAttribute("member-name", MemberRule.getFullName((Member)member));
        if (shared) {
            thread.setOutputFilename(RuleUtils.replaceNonFilenameChars((String)("publication_" + pubid + "_" + schematron.substring(0, schematron.length() - 4) + ".xml")));
        }
        try {
            Collection uris = DatabaseQuery.getURIsForPublication((Database)db, (XLink)pubXlink);
            boolean foundOne = false;
            for (URI uri : uris) {
                if (!URIRule.belongsToGroup((Database)db, (Long)uri.getId(), (String)group.getName())) continue;
                thread.addURIToValidate(uri.getId());
                foundOne = true;
            }
            if (!foundOne) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.NO_URIS_TO_PROCESS, "No documents to validate!");
                return;
            }
        }
        catch (QueryFailedException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load documents in publication: " + ex.getMessage());
            return;
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("publication-validation");
        thread.toXML(xml);
        xml.closeElement();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

