/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.Comments;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import com.pageseeder.uri.MoveURIThread;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, group=true, uri=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class SaveURIProperties
implements Generator,
SingleCheck {
    @ContentPermission(value=EditURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws QueryFailedException {
        String publicationid;
        URI uri = req.getURI();
        if (URIs.isExternal((URI)uri)) {
            return new ForbiddenCheck();
        }
        if (URIRule.isFolder((URI)uri)) {
            String name = req.getParameter((Parameter)StandardParameters.name);
            if (!uri.getPath().endsWith("/" + name)) {
                Collection guris = DatabaseQuery.getGroupURIsBySchemeHostPortSuperSubpathCol((Database)req.getDatabase(), (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)uri.getPath(), (boolean)true, (boolean)true);
                for (GroupURI gu : guris) {
                    if (!GroupURIRule.isShared((Database)req.getDatabase(), (GroupURI)gu)) continue;
                    return new ConfigureProjectCheck(URIRule.getDefaultGroupForURI((URI)uri));
                }
            }
        }
        if ((publicationid = req.getParameter((Parameter)StandardParameters.publicationid)) != null) {
            try {
                UserDetails details;
                Publication existing = DatabaseQuery.getPublicationByPublicationIDHost((Database)req.getDatabase(), (String)publicationid, (Host)uri.getHost());
                if (existing != null && (details = new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false)) != null && !MemberRule.isContributorForURIIdFlag((Database)req.getDatabase(), (Map)details.flags(), (Long)existing.getRootURIId(), (String)"c")) {
                    return new ForbiddenCheck();
                }
            }
            catch (DatabaseException ex) {
                LoggerFactory.getLogger(SaveURIProperties.class).error("Failed to load publication to compute permissions", (Throwable)ex);
            }
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup(), uri));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Collection publicationURIs;
        Publication publication;
        Publication publicationDeleted;
        boolean publicationCreated;
        boolean publicationUpdated;
        boolean titleUpdated;
        boolean metadataUpdated;
        boolean somethingUpdated;
        String name;
        URI uri;
        Database db;
        block53: {
            String current;
            Logger logger = req.getLogger((Object)this);
            db = req.getDatabase();
            uri = req.getURI();
            String labels = req.getParameter((Parameter)StandardParameters.labels);
            String documentid = req.getParameter((Parameter)StandardParameters.documentid);
            String usertitle = req.getParameter((Parameter)StandardParameters.title);
            String description = req.getParameter((Parameter)StandardParameters.description);
            String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
            String publicationtype = req.getParameter((Parameter)StandardParameters.publicationtype);
            name = req.getParameter((Parameter)StandardParameters.name);
            if (!URIUtils.checkLabels(res, labels)) {
                return;
            }
            if (publicationid != null && !publicationid.isEmpty() && !Publications.isValidPublicationID((String)publicationid)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_PUBLICATION_ID);
                return;
            }
            if (publicationtype != null && !publicationtype.isEmpty() && !Publications.isValidPublicationType((String)publicationtype)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_PUBLICATION_TYPE);
                return;
            }
            somethingUpdated = false;
            metadataUpdated = false;
            titleUpdated = false;
            if (labels != null) {
                String[] newLabels = Labels.toArray((String)labels);
                String[] current2 = Labels.getLabels((URI)uri);
                if (Labels.labelsAreDifferent((String[])current2, (String[])newLabels)) {
                    logger.debug("Changed labels of from {} to {}", (Object)current2, (Object)newLabels);
                    Labels.setLabels((URI)uri, (String[])newLabels);
                    somethingUpdated = true;
                    metadataUpdated = true;
                }
            }
            if (!(documentid == null || documentid.equals(current = uri.getDocID()) || current == null && documentid != null && documentid.isEmpty())) {
                URI turi = null;
                try {
                    if (!documentid.isEmpty()) {
                        turi = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)uri.getHost().getName(), (String)documentid);
                    }
                    if (turi != null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.DOCUMENT_ID_EXISTING, "Document ID '" + documentid + "' is already in use.");
                    } else {
                        String docid;
                        String string = docid = !documentid.isEmpty() ? documentid : null;
                        if (!URIRule.isValidDocumentID((String)docid)) {
                            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DOCUMENT_ID, "Document ID '" + documentid + "' contains invalid characters.");
                        } else {
                            uri.setDocID(docid);
                            logger.debug("Changed Document ID of from {} to {}", (Object)current, (Object)documentid);
                            somethingUpdated = true;
                            metadataUpdated = true;
                        }
                    }
                }
                catch (QueryFailedException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to retrieve other URI with this document ID: " + ex.getMessage());
                    return;
                }
            }
            if (!(usertitle == null || usertitle.equals(current = uri.getUserTitle()) || current == null && usertitle != null && usertitle.isEmpty())) {
                uri.setUserTitle(usertitle.length() == 0 ? null : usertitle);
                logger.debug("Changed Document Title of from {} to {}", (Object)current, (Object)usertitle);
                somethingUpdated = true;
                metadataUpdated = true;
                titleUpdated = true;
            }
            if (!(description == null || description.equals(current = uri.getDescription()) || current == null && description != null && description.isEmpty())) {
                logger.debug("Changed Description of from {} to {}", (Object)current, (Object)description);
                uri.setDescription(description.length() == 0 ? null : description);
                somethingUpdated = true;
                metadataUpdated = true;
            }
            publicationUpdated = false;
            publicationCreated = false;
            publicationDeleted = null;
            publication = null;
            publicationURIs = new ArrayList();
            if (!(publicationid == null && publicationtype == null || uri.getPath().contains("/archive/"))) {
                try {
                    publication = DatabaseQuery.getPublicationByRootURI((Database)db, (URI)uri, (boolean)true);
                    if (publicationid != null && publicationid.isEmpty()) {
                        if (publication != null) {
                            publicationURIs = Publications.delete((Database)db, (Publication)publication);
                            publicationUpdated = true;
                            publicationDeleted = publication;
                        }
                        break block53;
                    }
                    if (publication != null) {
                        String newtype;
                        String newid;
                        String string = newid = publicationid == null ? publication.getId() : publicationid;
                        String string2 = publicationtype == null ? publication.getType() : (newtype = publicationtype.isEmpty() ? "default" : publicationtype);
                        if (newid.equals(publication.getId()) && newtype.equals(publication.getType())) break block53;
                        try {
                            Publications.edit((Database)db, (Publication)publication, (String)newid, (String)newtype);
                        }
                        catch (URIException ex) {
                            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.PUBLICATION_ID_EXISTING, "Can't move a publication onto an existing one: " + ex.getMessage());
                            return;
                        }
                        publicationUpdated = true;
                        if (!newid.equals(publication.getId())) {
                            publicationDeleted = publication;
                            publicationCreated = true;
                            XLink pub_xlink = DatabaseQuery.getXLinkById((Database)db, (Long)publication.getXLinkId());
                            publicationURIs = DatabaseQuery.getURIsForPublication((Database)db, (XLink)pub_xlink);
                        }
                        break block53;
                    }
                    if (publicationid != null) {
                        Publication existing = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
                        publication = Publications.create((Database)db, (Member)req.getMember(), (String)publicationid, (URI)uri, (Group)req.getGroup(), (String)(publicationtype == null || publicationtype.isEmpty() ? "default" : publicationtype));
                        publicationUpdated = true;
                        publicationCreated = existing == null;
                    }
                }
                catch (DatabaseException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to set URI publication details: " + ex.getMessage());
                    return;
                }
            }
        }
        try {
            String[] decpathElements;
            String current_name;
            RenameResult result = null;
            String previousPath = null;
            if (name != null && !name.isEmpty() && !name.equals(current_name = (decpathElements = uri.getDecodedPath().split("/"))[decpathElements.length - 1])) {
                if (name.toLowerCase().endsWith(".psml") != current_name.toLowerCase().endsWith(".psml")) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.ILLEGAL_FILENAME, "Can not change file extension to or from .psml");
                    return;
                }
                if ("folder".equals(uri.getType())) {
                    req.getTransaction().commitAndStart();
                } else {
                    String type = Medias.getMediaTypeForPath((String)name);
                    uri.setType(type != null ? type : "application/octet-stream");
                }
                previousPath = uri.getPath();
                result = this.renameURI(uri, name, req.getMember(), req.getGroup(), db);
                if (result.serverError != null) {
                    res.setError(GeneratorStatus.SERVER_ERROR, result.serverError);
                    return;
                }
                if (result.badRequestError != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, result.badRequestError);
                    return;
                }
                if (result.shouldIndex) {
                    somethingUpdated = true;
                    if (result.thread == null) {
                        metadataUpdated = true;
                    }
                }
            }
            if (metadataUpdated) {
                try {
                    URIRule.addURIHistoryXLink((URI)uri, (Member)req.getMember(), null, null, null, null, previousPath, null, (Database)db);
                }
                catch (DatabaseException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to add an history XLink to store URI metadata: " + ex.getMessage());
                    return;
                }
            }
            if (somethingUpdated || publicationUpdated || result != null && result.thread != null) {
                Date change_date = new Date();
                uri.setLastModified(change_date);
                if (somethingUpdated) {
                    try {
                        URIRule.updateLastModifedForXRefs((URI)uri, (Date)change_date, (Database)db);
                    }
                    catch (QueryFailedException ex) {
                        res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load URI's xrefs to update last modified date: " + ex.getMessage());
                        return;
                    }
                }
                req.getTransaction().commitAndStart();
                if (result != null && result.thread != null) {
                    ProcessManager.getInstance().start((ProcessThread)result.thread);
                }
                Publications.updateURI((URI)uri);
                ChangesManager manager = ChangesManager.getInstance();
                ChangesBatch batch = new ChangesBatch("Modifying properties of URI " + uri.getId());
                manager.startBatch(db, batch);
                Collection groups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
                manager.modifyURI(db, batch, uri, groups);
                if (titleUpdated) {
                    Comments.indexCommentsTasksWorkflows(db, uri, manager, batch);
                }
                if (publicationUpdated && !uri.getPath().contains("/archive/")) {
                    if (publicationDeleted != null) {
                        manager.deletePublication(db, batch, publicationDeleted, publicationCreated ? Collections.emptyList() : publicationURIs);
                    }
                    if (publicationCreated) {
                        manager.createPublication(db, batch, publication, publicationURIs);
                    } else if (publication != null) {
                        manager.modifyPublication(db, batch, publication, Collections.emptyList(), Collections.singleton(uri), Collections.emptyList(), Collections.emptyList());
                    }
                }
                if (somethingUpdated) {
                    PSML.indexXRefSourceTargetURIsWithBatch(db, uri, batch);
                }
                manager.completeBatch(db, batch);
            }
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("uri-modification");
            if (result != null && result.warning != null) {
                out.field("warning", result.warning);
            }
            out.writeURI(uri);
            if (result != null && result.thread != null) {
                result.thread.print((OutputPrinter)out);
                res.setStatus(GeneratorStatus.ACCEPTED);
            }
            out.endObject();
            out.flush();
        }
        catch (CommitTransactionException | StartTransactionException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to restart transaction: " + ex.getMessage());
        }
        catch (QueryFailedException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load URI's groups for indexing transaction: " + ex.getMessage());
        }
    }

    private RenameResult renameURI(URI uri, String name, Member author, Group group, Database db) {
        StringBuilder parentPath = new StringBuilder();
        String[] pathElements = uri.getPath().split("/");
        for (int i = 1; i < pathElements.length - 1; ++i) {
            parentPath.append('/').append(pathElements[i]);
        }
        RenameResult result = new RenameResult();
        String newname = RuleUtils.replaceNonFilenameChars((String)name);
        if (!newname.equals(name)) {
            result.warning = "The new name contained illegal characters so it has been modified (" + name + " --> " + newname + ")";
        }
        try {
            String targetPath = parentPath.toString() + "/" + RuleUtils.urlEncodeFilepath((String)newname);
            URI target = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)targetPath);
            if (target != null && target.getId().longValue() == uri.getId().longValue()) {
                target = null;
            }
            if (target != null) {
                result.badRequestError = "There is already a URI with the path " + targetPath;
            } else {
                File targetFile = new File(URIRule.getRealPath((String)targetPath));
                if (targetFile.exists() && !targetPath.equalsIgnoreCase(uri.getPath())) {
                    result.badRequestError = "There is already a file with the path " + targetPath;
                } else if (!URIRule.isFolder((URI)uri)) {
                    File sourceFile = new File(URIRule.getRealPath((String)uri.getPath()));
                    if (!sourceFile.exists()) {
                        uri.setPath(targetPath);
                        result.shouldIndex = true;
                        if (!URIRule.isPSML((URI)uri)) {
                            result.warning = "URI was renamed but source file was not found";
                        }
                    } else if (!sourceFile.renameTo(targetFile)) {
                        result.serverError = "Failed to rename source file to " + targetFile.getAbsolutePath();
                    } else {
                        uri.setPath(targetPath);
                        result.shouldIndex = true;
                    }
                } else {
                    result.thread = MoveURIThread.newInstance(false, author.getUsername(), group);
                    boolean destinationSet = false;
                    URI dad = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)parentPath.toString());
                    if (dad != null) {
                        result.thread.setDestinationURIID(dad.getId());
                        destinationSet = true;
                    } else {
                        GroupURI dadGuri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)(parentPath.toString() + "/*"));
                        if (dadGuri == null) {
                            result.serverError = "Failed to find parent URI/GroupURI with path " + parentPath.toString();
                        } else {
                            result.thread.setDestinationGroupURIID(dadGuri.getId());
                            destinationSet = true;
                        }
                    }
                    if (destinationSet) {
                        result.thread.addURIToMove(uri.getId(), newname);
                    }
                }
            }
        }
        catch (DatabaseException ex) {
            result.serverError = "Failed to rename URI to " + newname + ": " + ex.getMessage();
        }
        return result;
    }

    private static class RenameResult {
        private boolean shouldIndex = false;
        private MoveURIThread thread = null;
        private String serverError = null;
        private String badRequestError = null;
        private String warning = null;

        private RenameResult() {
        }
    }
}

