/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.List;

@Requires(database=true, uri=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetURIWorkflow
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getGroup(), req.getURI()));
        }
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri = req.getURI();
        boolean draft = req.getParameter((Parameter)StandardParameters.draft, false);
        List xlinks = URIRule.getWorkflowsForURI((Database)req.getDatabase(), (URI)uri, (Member)(draft ? req.getMember() : null));
        UniversalPrinter out = res.getUniversalWriter();
        out.writeWorkflow(xlinks, true, true, uri, null);
        out.flush();
    }
}

