/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

@Requires(database=true, parameters={"url"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetURIWithURL
implements Generator,
SingleCheck,
Cacheable {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        String url = req.getParameter((Parameter)StandardParameters.url);
        try {
            URI uri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)RuleUtils.urlEncodeNormalize((String)url));
            if (uri != null) {
                if (req.getMember() != null) {
                    return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(uri));
                }
                return new ViewURICheck(req.getGroup(), uri);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new NoCheck();
    }

    public String getETag(GeneratorRequest req) throws DatabaseException {
        String url = req.getParameter((Parameter)StandardParameters.url);
        try {
            URI uri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)RuleUtils.urlEncodeNormalize((String)url));
            if (uri == null) {
                return null;
            }
            Date modified = uri.getLastModified();
            boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, false);
            return modified != null && !sharing ? MD5.hash((String)Long.toString(modified.getTime())) : null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URL url;
        String urlString = req.getParameter((Parameter)StandardParameters.url);
        boolean sharing = req.getParameter((Parameter)StandardParameters.sharing, false);
        try {
            url = RuleUtils.urlEncodeNormalize((String)urlString);
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL, "Invalid URL " + urlString + ": " + ex.getMessage());
            return;
        }
        URI uri = URIRule.getURIByURL((Database)req.getDatabase(), (URL)url);
        UniversalPrinter out = res.getUniversalWriter();
        if (uri == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.URI_NOT_FOUND);
        } else {
            out.writeExternalURI(uri, false, null);
            if (req.getMember() != null && sharing) {
                this.addSharing(req.getDatabase(), uri, req.getMember(), out);
            }
            out.endObject();
            out.flush();
        }
    }

    private void addSharing(Database db, URI uri, Member member, UniversalPrinter out) {
        UserDetailsManager manager = new UserDetailsManager();
        UserDetails userdetails = manager.get(db, member.getId());
        if (!uri.getExternal().booleanValue()) {
            out.writeURISharingDetails(uri.getId(), userdetails, db);
        }
    }
}

