/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.CharsetDetector;
import com.pageseeder.db.model.Group;
import com.pageseeder.validation.Validators;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, parameters={"schema"})
@PublicAPI
public final class GetSchema
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        String name = req.getParameter((Parameter)StandardParameters.schema);
        String extension = req.getParameter((Parameter)StandardParameters.document_extension);
        String type = req.getParameter((Parameter)StandardParameters.document_type);
        File schema = Validators.findSchema(group, extension, type, name);
        XMLWriter xml = res.getXMLWriter();
        if (schema != null && schema.canRead()) {
            String content;
            CharBuffer cs = CharsetDetector.decode((File)schema);
            xml.openElement("schema", true);
            xml.attribute("name", name);
            if (extension != null) {
                xml.attribute("document-extension", extension);
            }
            if (type != null) {
                xml.attribute("document-type", type);
            }
            if ((content = cs.toString()).startsWith("<?xml ")) {
                content = content.substring(content.indexOf(62) + 1);
            }
            xml.writeXML(content);
            xml.closeElement();
        } else {
            xml.openElement("no-schema");
            xml.attribute("name", name);
            if (type != null) {
                xml.attribute("document-type", type);
            }
            xml.closeElement();
        }
        xml.flush();
    }
}

