/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.List;

@Requires(database=true, parameters={"host"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetExternalURIsForHost
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 200;

    @ContentPermission(value=AuthenticatedInternalCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        boolean archivedOnly = req.getParameter((Parameter)StandardParameters.archived, false);
        return archivedOnly ? new EditAllURLsCheck() : new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        String host = req.getParameter((Parameter)StandardParameters.host);
        boolean archivedOnly = req.getParameter((Parameter)StandardParameters.archived, false);
        int page = Long.valueOf(req.getParameter((Parameter)StandardParameters.page, 1L)).intValue();
        int pagesize = Long.valueOf(req.getParameter((Parameter)StandardParameters.pagesize, 200L)).intValue();
        List uris = DatabaseQuery.getExternalURIsByHost((Database)db, (String)host, (boolean)archivedOnly, (int)page, (int)pagesize, (boolean)true);
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("uris");
        if (uris.size() > pagesize) {
            out.field("limitreached", true);
        }
        for (int i = 0; i < uris.size() && i < pagesize; ++i) {
            out.writeExternalURI((URI)uris.get(i));
        }
        out.endCollection();
        out.flush();
    }
}

