/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.uri;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.utils.SchematronFileFilter;
import com.pageseeder.validation.Validators;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class AvailableSchemas
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        URI uri = req.getURI();
        Group group = req.getGroup();
        assert (group != null);
        if (uri == null) {
            return new ViewGroupCheck(group);
        }
        return new ViewURICheck(group, uri);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException {
        Group group = req.getGroup();
        URI uri = req.getURI();
        assert (group != null && uri != null);
        String owner = group.getOwnerDirectory();
        List<File> dirs = Validators.listSchemaDir(uri, owner, true);
        HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
        for (File dir : dirs) {
            AvailableSchemas.collect(dir, names);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("available-schemas");
        Set keys = names.keySet();
        for (String key : keys) {
            String[] tokens = key.split("\\|", -1);
            if (tokens.length != 3) continue;
            String ext = tokens[0];
            String dt = tokens[1];
            String ut = tokens[2];
            Set filenames = (Set)names.get(key);
            for (String name : filenames) {
                out.startObject("schema");
                out.field("name", name);
                if (!ext.isEmpty()) {
                    out.field("extension", ext);
                }
                if (!dt.isEmpty()) {
                    out.field("documenttype", dt);
                }
                if (!ut.isEmpty()) {
                    out.field("urltype", ut);
                }
                out.endObject();
            }
        }
        out.endCollection();
        out.flush();
    }

    private static void collect(File directory, Map<String, Set<String>> names) {
        if (directory.exists()) {
            String urltype;
            String type;
            String ext;
            File parent = directory.getParentFile();
            if ("psml".equals(parent.getName())) {
                ext = "psml";
                type = directory.getName();
                urltype = "";
            } else if ("url".equals(parent.getName())) {
                ext = "";
                type = "";
                urltype = directory.getName();
            } else {
                ext = directory.getName();
                type = "";
                urltype = "";
            }
            String key = ext + "|" + type + "|" + urltype;
            Set<String> filenames = names.get(key);
            File[] schemaFiles = directory.listFiles(SchematronFileFilter.getInstance());
            if (schemaFiles == null) {
                throw new IllegalArgumentException("Unable to list files for directory");
            }
            for (File f : schemaFiles) {
                if (filenames == null) {
                    filenames = new HashSet<String>();
                    names.put(key, filenames);
                }
                filenames.add(f.getName());
            }
        }
    }
}

