/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import java.io.IOException;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(parameters={"threadid"})
@PublicAPI
public final class CancelThread
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new AdminSystemCheck();
        }
        return new EditURICheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        ProcessManager manager = ProcessManager.getInstance();
        String threadId = req.getParameter((Parameter)StandardParameters.threadid);
        assert (threadId != null);
        ProcessThread t = manager.getThread(threadId);
        if (t != null) {
            Group group = req.getGroup();
            if (group != null && !group.getId().equals(t.getGroupID())) {
                res.setError(GeneratorStatus.NOT_FOUND, "There are no threads in group " + group.getName() + " with ID " + threadId);
                return;
            }
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "There are no threads with ID " + threadId);
            return;
        }
        manager.cancel(threadId);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("thread-cancel");
        out.field("cancelled", true, OutputPrinter.FieldOption.JSON_ONLY);
        out.endObject();
        out.flush();
    }
}

