/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class BackgroundThreadsManager {
    private static volatile BackgroundThreadsManager singleton = null;
    private static final int THREAD_PRIORITY = Math.round(2.0f);
    private final ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "ps-background-p" + THREAD_PRIORITY);
            t.setPriority(THREAD_PRIORITY);
            return t;
        }
    });

    private BackgroundThreadsManager() {
    }

    public static BackgroundThreadsManager getInstance() {
        if (singleton == null) {
            singleton = new BackgroundThreadsManager();
        }
        return singleton;
    }

    public void start(Runnable thread) {
        this.threadPool.execute(thread);
    }

    public void shutdown() {
        this.threadPool.shutdownNow();
    }
}

