/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, parameters={"content"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class ReportError
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportError.class);

    @ContentPermission(value=AuthenticatedInternalCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String errorReportAddress;
        String content = req.getParameter((Parameter)StandardParameters.content);
        assert (content != null);
        if (Emails.areDisabled()) {
            res.setError(GeneratorStatus.UNAVAILABLE, "Report cannot be sent when emails are disabled");
            return;
        }
        try {
            errorReportAddress = GroupProperties.get((Database)req.getDatabase(), (Group)req.getGroup()).getProperty("errorReportAddress");
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to load group properties", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Report could not be sent: " + ex.getMessage());
            return;
        }
        if (!Emails.isAddress((String)errorReportAddress)) {
            res.setError(GeneratorStatus.UNAVAILABLE, "Report cannot be sent when group property errorReportAddress is invalid");
            return;
        }
        try {
            Emails.sendErrorReport((Database)req.getDatabase(), (String)errorReportAddress, (Group)req.getGroup(), (String)content, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
        }
        catch (EmailException ex) {
            LOGGER.error("Failed to send error report email", (Throwable)ex);
            res.setError(GeneratorStatus.UNAVAILABLE, "Report could not be sent: " + ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("error-report");
        out.field("report-sent", "true");
        out.endObject();
        out.flush();
    }
}

