/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.Settings;
import java.io.IOException;
import java.util.Objects;

@Output(types={OutputType.JSON, OutputType.XML})
public final class GetVersion
implements Generator,
Cacheable {
    public String getETag(GeneratorRequest req) {
        return Settings.getPageSeederVersion();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String version = Objects.toString(Settings.getPageSeederVersion(), "");
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("version");
        int major = GetVersion.getMajor(version);
        int build = GetVersion.getBuild(version);
        out.field("major", (long)major);
        out.field("build", (long)build);
        out.field("string", version);
        out.endObject();
        out.flush();
    }

    private static int getMajor(String version) {
        int dot = version.indexOf(46);
        try {
            String major = dot > 0 ? version.substring(0, dot) : version;
            return Integer.parseInt(major);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static int getBuild(String version) {
        int sep = version.indexOf(46);
        try {
            String build = sep > 0 ? version.substring(sep + 1) : version;
            sep = build.indexOf(45);
            build = sep > 0 ? build.substring(0, sep) : build;
            return Integer.parseInt(build);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

